// LineData.cpp: LineData 饹Υץơ
//
//////////////////////////////////////////////////////////////////////


#include "LineData.h"
#include "DrawCharPos.h"
#include "TaEditDraw.h"
#include "TaEditShell.h"

//////////////////////////////////////////////////////////////////////
// /
//////////////////////////////////////////////////////////////////////

CLineData::CLineData() :
	vMoji( L"" ),
	vIro(),
	ExtendInfo(),
	ModifiedTime(),
	DrawCharPos()
{
	int i;
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();

	vIro.clear();
	ExtendInfo.clear();
	DrawCharPos.Clear();

	for ( i = 0; i < pConf->GetExInfoColumnCount(); i++ )
		ExtendInfo.push_back( false );

	clock_gettime( CLOCK_HIGHRES, &ModifiedTime );
	vIro.push_back( 0 );	// ʸĹ0Ǥ⿧1ʸɬפǤ롣
}

CLineData::CLineData( const CLineData &r ) :
	vIro( r.vIro ),
	vMoji( r.vMoji ),
	ExtendInfo(),
	ModifiedTime(),
	DrawCharPos()	
{
	int i;
	clock_gettime( CLOCK_HIGHRES, &ModifiedTime );
	DrawCharPos.Clear();
	ExtendInfo.clear();
	for ( i = 0; i < r.ExtendInfo.size(); i++ )
		ExtendInfo.push_back( r.ExtendInfo[i] );
}

CLineData::CLineData( const wchar_t *pStr ) :
	vMoji( L"" ),
	vIro(),
	ExtendInfo(),
	ModifiedTime(),
	DrawCharPos()
{
	int i;
	vMoji.clear();
	vIro.clear();
	ExtendInfo.clear();
	DrawCharPos.Clear();

	vMoji = pStr;
	vIro.swap( vector< unsigned char >( vMoji.length() + 1, 0 ) );
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	ExtendInfo.resize( pConf->GetExInfoColumnCount(), false );
	for ( i = 0; i < ExtendInfo.size(); i++ )
		ExtendInfo[i] = false;
	clock_gettime( CLOCK_HIGHRES, &ModifiedTime );
}

CLineData::~CLineData()
{

}

//////////////////////////////////////////////////////////////////////
// ᥽å
//////////////////////////////////////////////////////////////////////

// 
void CLineData::push_back( TA_CHAR c, const int MLMN )
{
	vMoji += c.moji;
	// ϺǸ夫2ܤؤȤʤ
	vIro.insert( vIro.begin() + vIro.size() - 1, c.iro );
	OnUpdate( MLMN );
}

TA_CHAR CLineData::operator []( size_t idx ) const
{
	assert( idx >= 0 && idx < vMoji.size() );
	return TA_CHAR( vMoji[ idx ], vIro[ idx ] );
}

unsigned char CLineData::getIro( int idx ) const
{
	// βԥɤοؤΥ
	assert( idx >= 0 && idx < vIro.size() );
	return vIro[idx];
}

void CLineData::setIro( int idx, unsigned char c )
{
	// βԥɤοؤΥ
	assert( idx >= 0 && idx < vIro.size() );
	vIro[idx] = c;
	clock_gettime( CLOCK_HIGHRES, &ModifiedTime );
}

void CLineData::set( size_t idx, TA_CHAR c, const int MLMN )
{
	assert( idx >= 0 && idx < vMoji.size() );
	vMoji[ idx ] = c.moji;
	vIro[ idx ] = c.iro;
	OnUpdate( MLMN );
}

size_t CLineData::length() const
{
	return vMoji.length();
}

const wstring& CLineData::getString() const
{
	return vMoji;
}

const CLineData& CLineData::operator =( const CLineData &r )
{
	vIro = r.vIro;
	vMoji = r.vMoji;
	ExtendInfo = r.ExtendInfo;
	DrawCharPos = r.DrawCharPos;
	OnUpdate( -1 );
	return (*this);
}

void CLineData::clear( const int MLMN )
{
	vIro.clear();
	vIro.push_back( 0 );	// ԥɤʬ
	vMoji = L"";
	OnUpdate( MLMN );
}

// ʸֳ֤ݤ
// ͤʸ
bool CLineData::InsertBlank( size_t pos, size_t length, const int MLMN )
{
	if ( vMoji.length() < pos ) return false;
	if ( length <= 0 ) return true;	// ٤ʸĹ0ʤФʤˤ⤷ʤ

	vMoji.insert( pos, length, L' ' );
	vIro.insert( vIro.begin() + pos, length, 0 );

	OnUpdate( MLMN );
	return true;
}

// ꤵ줿ϰϤʸ
void CLineData::Delete( size_t s, size_t e, const int MLMN )
{
	vIro.erase( vIro.begin() + s, vIro.begin() + e );
	vMoji.erase( vMoji.begin() + s, vMoji.begin() + e );
	OnUpdate( MLMN );
}

// Ǹ˹줿֤
const CTimeSpec& CLineData::GetModifiedTime() const
{
	return ModifiedTime;
}

// ־Ѳǽݤ
bool CLineData::IsEnableDrawCharPos() const
{
	return DrawCharPos.GetIsEnable();
}

// ʸ֤򻲾
const CDrawCharPos& CLineData::GetDrawCharPos() const
{
	return DrawCharPos;
}

// ֤򹹿
bool CLineData::UpdateDrawCharPos( const CTaEditDraw *pDraw ) const
{
	int i;
	unsigned int XPos = 0;

	if ( DrawCharPos.GetIsEnable() ) return true;

	DrawCharPos.Clear();
	for ( i = 0; i < vMoji.length(); i++ ) {
		DrawCharPos.AddChar( XPos );
		XPos += pDraw->GetCharWidth( vMoji[i], XPos );
	}
	DrawCharPos.SetRightXPos( XPos );

	DrawCharPos.SetIsEnable( true );	// ־ͭˤʤä
	return true;
}

// 줿
void CLineData::OnUpdate( const int MLMN )
{
	clock_gettime( CLOCK_HIGHRES, &ModifiedTime );	// ֤
	DrawCharPos.Clear();
	DrawCharPos.SetIsEnable( false );	// ־̵ˤʤä

	// ե饰ꤹ
	if ( MLMN >= 0 && MLMN < ExtendInfo.size() )
		ExtendInfo[MLMN] = true;
}

// ĥμ
bool CLineData::GetExtendInfo( int idx ) const
{
	assert( idx >= 0 && idx < ExtendInfo.size() );
	return ExtendInfo[idx];
}

// ĥ
void CLineData::SetExtendInfo( int idx, bool f )
{
	assert( idx >= 0 && idx < ExtendInfo.size() );
	if ( ExtendInfo[idx] != f ) {
		ExtendInfo[idx] = f;
		clock_gettime( CLOCK_HIGHRES, &ModifiedTime );
	}
}

// ֤򹹿
// ʸѲϤʤ褵˻
void CLineData::UpdateTime()
{
	clock_gettime( CLOCK_HIGHRES, &ModifiedTime );
}

