/////////////////////////////////////////////////////////////////////////
// CConfigInfo 饹Υ󥿥ե
//
////////////////////////////////////////////////////////////////////////////

#if !defined( CONFIGINFO_H_INCLUDED_ )
#define CONFIGINFO_H_INCLUDED_

#include <Xm/XmAll.h>
#include "TaEdit_std.h"
#include "CompoundStr.h"

#include <map>

using namespace std;


class CConfigInfo : public CCPInterface
{
public:
	CConfigInfo( const CConfigInfo& r );	// ʣʶػߡ
	CConfigInfo( Widget widget );

	~CConfigInfo();

	// 
	void Initialize();

	const CCompoundStr& RefOkStr() const;
	const CCompoundStr& RefCancelStr() const;
	const CCompoundStr& RefYesStr() const;
	const CCompoundStr& RefNoStr() const;
	const wstring& RefNewFileWndTitleStr() const;
	const CCompoundStr& RefFailToConvertCharSet() const;
	const CCompoundStr& RefBrokenLineMsg() const;
	const CCompoundStr& RefIOErrorMsg( int ErrorNo ) const;
	const CCompoundStr& RefFileNameIsNotInputtedErrorMsg() const;
	const CCompoundStr& RefOutOfMemoryErrorMsg() const;
	const CCompoundStr& RefUnexpectedErrorMsg() const;
	const CCompoundStr& RefFileIsNotExistMsg() const;
	const CCompoundStr& RefSpecifiedNameIsDirMsg() const;
	const CCompoundStr& RefFaultFileOpenMsg() const;
	const CCompoundStr& RefPreservationCheckMsg() const;
	const CCompoundStr& RefRunScriptEAGAINMsg() const;
	const CCompoundStr& RefRunScriptEINTRMsg() const;
	const CCompoundStr& RefRunScriptENOMEMMsg() const;
	const CCompoundStr& RefRunScriptCancelOpenMsg() const;
	const CCompoundStr& RefRunScriptCancelSaveMsg() const;
	const CCompoundStr& RefRunScriptErrnoMsg( int e ) const;
	bool GetShowCancelOpenMsg() const;
	bool GetShowCancelSaveMsg() const;
	bool GetFaultLoadPluginLibraryMsg( CCompoundStr *pCS, const string &rLibraryName, const char* pReason ) const;
	bool GetFaultGetPluginFunctionMsg( CCompoundStr *pCS, const string &rLibraryName, const string &rFunctionName, const char* pReason ) const;
	const CCompoundStr& RefFaultToSaveTmpFileMsg() const;
	const CCompoundStr& RefRetryWithoutSaveTmpFileMsg() const;
	const CCompoundStr& RefFailedToInitConstructionModeMsg() const;
	const CCompoundStr& RefConstructionCommunicationErrorMsg() const;
	const CCompoundStr& RefRebootServerMsg() const;
	const CCompoundStr& RefFailedToRebootServerMsg() const;
	const CCompoundStr& RefServerRevokedMsg() const;
	const CCompoundStr& RefFileIsOpenedByAnotherMsg() const;
	const CCompoundStr& RefReplaceStrIsNullMsg() const;
	const CCompoundStr& RefFailedToStartEncConvMsg() const;
	const CCompoundStr& RefEncodeNameIsInvalidMsg() const;
	const CCompoundStr& RefFailedToConvertEncodeMsg() const;
	const CCompoundStr& RefFailedToReadKeywordListMsg() const;
	const CCompoundStr& RefFailToGetPID() const;
	const CCompoundStr& RefFailToCreateChildProcess() const;
	const CCompoundStr& RefFileOpenDlgTitle() const;
	const CCompoundStr& RefFileSaveDlgTitle() const;
	Pixel RefNormalTextF_Color();
	Pixel RefNormalTextB_Color();
	Pixel RefSelectedTextF_Color();
	Pixel RefSelectedTextB_Color();
	Pixel RefBackgroundColor();
	Pixel RefCursorColor();
	Pixel RefPreEditTextF_Color();
	Pixel RefPreEditTextB_Color();
	Pixel RefCurLineUnderBar_Color();
	bool GetDrawCurLineUnderBar() const;
	Pixel RefEditMark_Color();
	bool GetDrawEditMark() const;
	const string& RefFontName() const;
	int RefTabWidth() const;
	const CCompoundStr& RefCantFindTextMsg() const;
	bool GetWrongRegexPatternMsg( CCompoundStr *pCS, const wstring &msg, int idx ) const;
	const wstring& RefWRP_EofNotAnticipated() const;
	const wstring& RefWRP_OutOfMemory() const;
	const wstring& RefWRP_UncertainChar() const;
	const wstring& RefWRP_ZeroLengthPattern() const;
	const wstring& RefWRP_Unexpected() const;
	const wstring& RefAppTitle() const;
	const wstring& RefTitleFormat() const;
	enumCHARSELTYPE GetCharSelType() const;
	int GetLeftPadding() const;
	int GetRightPadding() const;
	int GetLineNumberOrigin() const;
	int GetLineGapWidth() const;
	enumTABWIDTHCALCMETHOD GetTabWidthCalculationMethod() const;
	const wstring& RefTabString() const;
	const string& RefProcUpScript() const;
	const string& RefFileReadScript() const;
	const string& RefFileAfterReadScript() const;
	const string& RefFileBeforeWriteScript() const;
	const string& RefFileWriteScript() const;
	const string& RefFileCloseScript() const;
	const string& RefProcDownScript() const;
	bool GetAutoIndent() const;
	const wstring& RefIndentChar() const;
	const wstring& RefWordCharSet() const;
	enumDROPFILEOPENMETHOD GetDropFileOpenMethod() const;
	enumBTN2FUNC GetBtn2Func() const;
	int GetMaxUndoCount() const;
	int GetHScrollAt() const;
	const string& RefClipboardEncode() const;
	int GetShowPrecessingDlgDelay() const;
	int GetWindowWidth() const;
	int GetWindowHeight() const;
	int GetScrollMouseSpeed() const;
	const string& RefIconImageName() const;
	int GetExInfoColumnCount() const;
	int GetExInfoColumnWidth() const;
	Pixel RefExInfoColumnColor( int idx );
	bool GetDrawSeparatorLine() const;
	Pixel RefSeparatorLineColor();
	int GetAutoSaveInterval() const;
	enumAUTOSAVE_NEWFILE GetAutoSaveNewFileMethod() const;
	const wstring& RefModifiedSignStr() const;
	bool GetInsertTabToEmptyLine() const;
	bool GetUseDoubleBuffering() const;
	int GetCPUCount() const;
	bool GetUseWriteTmpFile() const;
	const vector< string >& RefEncodeName() const;
	const string& RefCurrentEncodeText() const;
	enumCURSORBEHAVIORMODE GetCursorBehaviorMode() const;
	int GetLineNumberColumnWidth() const;
	Pixel RefLineNumberF_Color();
	int GetModifyLineMarkNumber() const;

	// Ƹ̤
	int GetLangTypeEnableMaxSize() const;
	const string& RefCPP_FileExt() const;
	const string& RefCPP_KeywordList() const;
	const string& RefJAVA_FileExt() const;
	const string& RefJAVA_KeywordList() const;
	const string& RefCOBOL_FileExt() const;
	const string& RefCOBOL_KeywordList() const;
	const string& RefJS_FileExt() const;
	const string& RefJS_KeywordList() const;
	const string& RefVBS_FileExt() const;
	const string& RefVBS_KeywordList() const;
	const string& RefCS_FileExt() const;
	const string& RefCS_KeywordList() const;
	const string& RefHTML_FileExt() const;
	const string& RefHTML_KeywordList() const;

	Pixel RefCPP_NormalTextF_Color();
	Pixel RefCPP_KeywordF_Color();
	Pixel RefCPP_CommentF_Color();
	Pixel RefCPP_SringF_Color();
	Pixel RefJAVA_NormalTextF_Color();
	Pixel RefJAVA_KeywordF_Color();
	Pixel RefJAVA_CommentF_Color();
	Pixel RefJAVA_SringF_Color();
	Pixel RefCOBOL_NormalTextF_Color();
	Pixel RefCOBOL_KeywordF_Color();
	Pixel RefCOBOL_CommentF_Color();
	Pixel RefCOBOL_SringF_Color();
	Pixel RefCOBOL_SequenceNumberF_Color() ;
	Pixel RefJS_NormalTextF_Color();
	Pixel RefJS_KeywordF_Color();
	Pixel RefJS_CommentF_Color();
	Pixel RefJS_SringF_Color();
	Pixel RefVBS_NormalTextF_Color();
	Pixel RefVBS_KeywordF_Color();
	Pixel RefVBS_CommentF_Color();
	Pixel RefVBS_SringF_Color();
	Pixel RefCS_NormalTextF_Color();
	Pixel RefCS_KeywordF_Color();
	Pixel RefCS_CommentF_Color();
	Pixel RefCS_SringF_Color();
	Pixel RefHTML_NormalTextF_Color();
	Pixel RefHTML_TagF_Color();
	Pixel RefHTML_KeywordF_Color();
	Pixel RefHTML_CommentF_Color();
	Pixel RefHTML_SringF_Color();

	const string& RefPluginConfigFileName() const;

	// ʶػߡ
	const CConfigInfo& operator =( const CConfigInfo& r );
protected:
	// ̾Pixelͤ
	Pixel GetColorByName( const string& rStr, bool DefaultIsBlack );

	// ޤǶڤ줿ʸѴ
	vector< string > DiviteStringWithComma( const char *pStr );

	Widget m_Widget;

	CCompoundStr OkStr;
	CCompoundStr CancelStr;
	CCompoundStr YesStr;
	CCompoundStr NoStr;
	wstring NewFileWndTitleStr;
	CCompoundStr FailToConvertCharSet;
	CCompoundStr BrokenLineMsg;
	CCompoundStr DeviceIOErrorMsg;
	CCompoundStr TextEncodeErrorMsg;
	CCompoundStr IOErrorMsg;
	CCompoundStr OutOfMemoryErrorMsg;
	CCompoundStr FileNameIsNotInputtedErrorMsg;
	CCompoundStr UnexpectedErrorMsg;
	CCompoundStr FileIsNotExistMsg;
	CCompoundStr SpecifiedNameIsDirMsg;
	CCompoundStr FaultFileOpenMsg;
	CCompoundStr PreservationCheckMsg;
	CCompoundStr RunScriptEAGAINMsg;
	CCompoundStr RunScriptEINTRMsg;
	CCompoundStr RunScriptENOMEMMsg;
	CCompoundStr RunScriptCancelOpenMsg;
	CCompoundStr RunScriptCancelSaveMsg;
	bool ShowCancelOpenMsg;
	bool ShowCancelSaveMsg;
	string FaultLoadPluginLibraryMsg;
	string FaultGetPluginFunctionMsg;
	CCompoundStr FaultToSaveTmpFileMsg;
	CCompoundStr RetryWithoutSaveTmpFileMsg;
	CCompoundStr FailedToInitConstructionModeMsg;
	CCompoundStr ConstructionCommunicationErrorMsg;
	CCompoundStr RebootServerMsg;
	CCompoundStr FailedToRebootServerMsg;
	CCompoundStr ServerRevokedMsg;
	CCompoundStr FileIsOpenedByAnotherMsg;
	CCompoundStr ReplaceStrIsNullMsg;
	CCompoundStr FailedToStartEncConvMsg;
	CCompoundStr EncodeNameIsInvalidMsg;
	CCompoundStr FailedToConvertEncodeMsg;
	CCompoundStr FailedToReadKeywordListMsg;
	CCompoundStr FailToGetPID;
	CCompoundStr FailToCreateChildProcess;
	CCompoundStr FileOpenDlgTitle;
	CCompoundStr FileSaveDlgTitle;
	string NormalTextF_Color;
	string NormalTextB_Color;
	string SelectedTextF_Color;
	string SelectedTextB_Color;
	string BackgroundColor;
	string CursorColor;
	string PreEditTextF_Color;
	string PreEditTextB_Color;
	string CurLineUnderBar_Color;
	bool DrawCurLineUnderBar;
	string EditMark_Color;
	bool DrawEditMark;
	string FontName;
	int TabWidth;
	CCompoundStr CantFindTextMsg;
	wstring WrongRegexPatternMsg;
	wstring WRP_EofNotAnticipated;
	wstring WRP_OutOfMemory;
	wstring WRP_UncertainChar;
	wstring WRP_ZeroLengthPattern;
	wstring WRP_Unexpected;
	wstring AppTitle;
	wstring TitleFormat;
	enumCHARSELTYPE CharSelType;
	int LeftPadding;
	int RightPadding;
	int LineNumberOrigin;
	int LineGapWidth;
	enumTABWIDTHCALCMETHOD TabWidthCalculationMethod;
	wstring TabString;
	string ProcUpScript;
	string FileReadScript;
	string FileAfterReadScript;
	string FileBeforeWriteScript;
	string FileWriteScript;
	string FileCloseScript;
	string ProcDownScript;
	bool AutoIndent;
	wstring IndentChar;
	wstring WordCharSet;
	enumDROPFILEOPENMETHOD DropFileOpenMethod;
	enumBTN2FUNC Btn2Func;
	int MaxUndoCount;
	int HScrollAt;
	string ClipboardEncode;
	int ShowPrecessingDlgDelay;
	int WindowWidth;
	int WindowHeight;
	int ScrollMouseSpeed;
	string IconImageName;
	int ExInfoColumnCount;
	int ExInfoColumnWidth;
	string *pExInfoColumnColor;
	bool DrawSeparatorLine;
	string SeparatorLineColor;
	int AutoSaveInterval;
	enumAUTOSAVE_NEWFILE AutoSaveNewFileMethod;
	wstring ModifiedSignStr;
	bool InsertTabToEmptyLine;
	bool UseDoubleBuffering;
	int CPUCount;
	bool UseWriteTmpFile;
	vector< string > EncodeName;
	string CurrentEncodeText;
	enumCURSORBEHAVIORMODE CursorBehaviorMode;
	int LineNumberColumnWidth;
	string LineNumberF_Color;
	int ModifyLineMarkNumber;

	int LangTypeEnableMaxSize;
	string CPP_FileExt;
	string CPP_KeywordList;
	string JAVA_FileExt;
	string JAVA_KeywordList;
	string COBOL_FileExt;
	string COBOL_KeywordList;
	string JS_FileExt;
	string JS_KeywordList;
	string VBS_FileExt;
	string VBS_KeywordList;
	string CS_FileExt;
	string CS_KeywordList;
	string HTML_FileExt;
	string HTML_KeywordList;

	string CPP_NormalTextF_Color;
	string CPP_KeywordF_Color;
	string CPP_CommentF_Color;
	string CPP_SringF_Color;
	string JAVA_NormalTextF_Color;
	string JAVA_KeywordF_Color;
	string JAVA_CommentF_Color;
	string JAVA_SringF_Color;
	string COBOL_NormalTextF_Color;
	string COBOL_KeywordF_Color;
	string COBOL_CommentF_Color;
	string COBOL_SringF_Color;
	string COBOL_SequenceNumberF_Color;
	string JS_NormalTextF_Color;
	string JS_KeywordF_Color;
	string JS_CommentF_Color;
	string JS_SringF_Color;
	string VBS_NormalTextF_Color;
	string VBS_KeywordF_Color;
	string VBS_CommentF_Color;
	string VBS_SringF_Color;
	string CS_NormalTextF_Color;
	string CS_KeywordF_Color;
	string CS_CommentF_Color;
	string CS_SringF_Color;
	string HTML_NormalTextF_Color;
	string HTML_TagF_Color;
	string HTML_KeywordF_Color;
	string HTML_CommentF_Color;
	string HTML_SringF_Color;

	string PluginConfigFileName;

	map< string, Pixel > mapPixelCash;	// ̾PixelͤȤбݻ륭å
};

#endif // CONFIGINFO_H_INCLUDED_

/*
TitleFormat
%1 : AppTitle
%2 : ե̾ʥեѥˤޤNewFileWndTitle
%3 : ե̾ޤNewFileWndTitle
%4 : ModifiedSignStr
%5 : ֹ
%6 : 1
*/

