////////////////////////////////////////////////////////////////////////////
// CCompoundStr 饹Υ󥿥ե
//
////////////////////////////////////////////////////////////////////////////

#if !defined( COMPOUNDSTR_H_INCLUDED_ )
#define COMPOUNDSTR_H_INCLUDED_

#include <Xm/Xm.h>
#include <string>
#include <GlbFunc.h>
#include "TaEditJPEXT.h"

class CCompoundStr
{
public:
	CCompoundStr() : m_str( NULL ){};
	CCompoundStr( const char *pStr ) : m_str( NULL ) {
		SetStr( pStr );
	};
	CCompoundStr( const string &rStr ) : m_str( NULL ) {
		SetStr( rStr.c_str() );
	};
	CCompoundStr( const wstring &rStr ) : m_str( NULL ) {
		SetStr( rStr.c_str() );
	};
	CCompoundStr( const wchar_t *pStr ) : m_str( NULL ) {
		SetStr( pStr );
	};
	CCompoundStr( XmString str ) : m_str( str ) {};
	CCompoundStr( const CCompoundStr& r ) : m_str( NULL ) {
		m_str = XmStringCopy( r.m_str );
	}
	~CCompoundStr() {
		Free();
	};

	// ʸ
	void SetStr( const char *pStr ) {
		Free();
		if ( NULL == pStr ) return ;
		m_str = XmStringCreateLocalized( const_cast< char* >( pStr ) );
		// m_str = XmStringCreateLtoR( const_cast< char* >( pStr ), XmFONTLIST_DEFAULT_TAG );
	};
	void SetStr( const wchar_t *pStr ) {
		std::string wStr;
		if ( GlbFunc::WCStoMBS( pStr, &wStr ) )
			SetStr( wStr.c_str() );
	};
	void SetStr( const string& rStr ) {
		SetStr( rStr.c_str() );
	}
	void SetStr( const wstring& rStr ) {
		SetStr( rStr.c_str() );
	}
	void SetStr( XmString pStr ) {
		Free();
		m_str = pStr;
	}

	// ʸ
	XmString GetStr()  const {
		return m_str;
	};

	operator XmString()  const {
		return m_str;
	};

	// ʸ
	void Free() {
		if ( m_str )
			XmStringFree( m_str );
		m_str = NULL;
	};

	const CCompoundStr& operator =( const CCompoundStr& r ) {
		m_str = XmStringCopy( r.m_str );
		return (*this);
	};
protected:
	XmString m_str;
};

#endif // COMPOUNDSTR_H_INCLUDED_

