////////////////////////////////////////////////////////////////////////////
// CProcStart 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>
#include <alloca.h>
#include <sys/wait.h>
#include <assert.h>
#include <time.h>

#include "ProcStart.h"

////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CProcStart::CProcStart() :
	cmd(),
	listArg()
{

}

CProcStart::CProcStart( const CProcStart& r ) :
	cmd( r.cmd ),
	listArg( r.listArg )
{

}

CProcStart::~CProcStart()
{

}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// ư륳ޥɤ
void CProcStart::SpecifyCommand( const string& rCmd )
{
	assert( NULL != this );
	cmd = rCmd;
	listArg.push_back( rCmd );
}

// ɲ
void CProcStart::AddArg( const string& rArg )
{
	assert( NULL != this );
	listArg.push_back( rArg );
}

// ץư
// ưץpid֤
// Ԥ-1֤
int CProcStart::Start() const
{
	int r;
	int status;
	char **vArg;

	assert( NULL != this );

	// Ѱդ
	vArg = CreateArgVec();
	if ( NULL == vArg ) return -1;

	r = fork();
	if ( r < 0 ) {
		FreeArgVec( vArg );
		vArg = NULL;
		return -1;
	}

	// ƥץϤʾ夹Ϥʤ
	if ( r > 0 ) {
		FreeArgVec( vArg );
		vArg = NULL;

		waitpid( r, &status, 0 );
		if ( !WIFEXITED( status ) )
			return -1;

		// ҥץϡ¹ץpid֤
		// Ԥ0֤
		if ( WEXITSTATUS( status ) == 0 )
			return -1;
		return WEXITSTATUS( status );
	}

	r = fork();
	if ( r < 0 ) {
		// 顼
		_exit( 0 );
	}

	// ҥץϤǽλ
	if ( r > 0 ) {
		// λơȤơ¹ץpid֤
		_exit( r );
	}

	// exec
	Exec( cmd, vArg );
	return -1;
}

// ץươλԤ碌
// ץνλơ֤
// Ԥ-1֤
int CProcStart::StartWait() const
{
	char **vArg;
	int r;

	assert( NULL != this );

	// Ѱդ
	vArg = CreateArgVec();
	if ( NULL == vArg ) return -1;

	r = fork();
	if ( r < 0 ) {
		FreeArgVec( vArg );
		vArg = NULL;
		return -1;
	}

	if ( r > 0 ) {
		int status;
		// ƥץϡҥץνλԤ碌

		// 
		FreeArgVec( vArg );
		vArg = NULL;

		// Ԥ碌
		waitpid( r, &status, 0 );
		if ( !WIFEXITED( status ) )
			return -1;

		// λơ֤
		return WEXITSTATUS( status );
	}

	// exec
	Exec( cmd, vArg );
	return -1;
	
}

// ץươ郎ΩޤԤ碌
// ҥץνλơ֤Ԥ-1֤
// (*pFlg)δ֡ʿˤʤޤǡԤ碌롣
// (*pFlg)ˤʤԤ碌λˤϡ(*pid)˥ץIDꤹ롣
int CProcStart::StartWaitCondition( volatile const bool *pFlg, int *pid ) const
{
	char **vArg;
	int r;
	volatile const bool wflg = false;	// 

	assert( NULL != this );

	if ( !pFlg ) pFlg = &wflg;
	if ( pid ) (*pid) = -1;

	// Ѱդ
	vArg = CreateArgVec();
	if ( NULL == vArg ) return -1;

	r = fork();
	if ( r < 0 ) {
		FreeArgVec( vArg );
		vArg = NULL;
		return -1;
	}

	if ( r > 0 ) {
		int status;
		struct timespec req;

		// 
		FreeArgVec( vArg );
		vArg = NULL;

		// 100msñ̤ǴƻԤ
		req.tv_sec = 0;
		req.tv_nsec = 100 * 1000 * 1000;

		// Ԥ碌
		while ( !(*pFlg) && waitpid( r, &status, WNOHANG ) == 0 ) {
			// ֤Ԥ
			if( nanosleep( &req, NULL ) )
				return -1;
		}

		if ( (*pFlg) ) {
			// ޤ줿
			if ( pid ) (*pid) = r;
			return -1;
		}

		if ( !WIFEXITED( status ) )
			return -1;

		// λơ֤
		return WEXITSTATUS( status );
	}

	// exec
	Exec( cmd, vArg );
	return -1;
}

// 
char** CProcStart::CreateArgVec() const
{
	list< string >::const_iterator itr;
	char **vArg;
	int i;

	assert( NULL != this );

	// ʸʤΥɥ쥹ˤݻۤ
	vArg = (char**)calloc( sizeof( char* ), listArg.size() + 1 );

	// θġʸۤ
	itr = listArg.begin();
	for ( i = 0; i < listArg.size(); i++ ) {
		// ʸΥΰ
		vArg[i] = (char*)calloc( sizeof( char ), ( itr->length() + 2 ) );
		// Ԥ顢ޤǳݤΰơNULL֤
		if ( !vArg[i] ) {
			FreeArgVec( vArg );
			vArg = NULL;
			return NULL;
		}
		strncpy( vArg[i], itr->c_str(), itr->length() + 1 );
		itr++;
	}
	return vArg;
}

// ˴
void CProcStart::FreeArgVec( char** p ) const
{
	char **wp;

	assert( NULL != this );

	// NULLꤵ줿ϲ⤷ʤ
	if ( NULL == p ) return ;

	// ġʸ˴
	wp = p;
	while ( (*wp) ) {
		free( (*wp) );
		(*wp) = NULL;
		wp++;
	}

	// ʸΥɥ쥹ݻ
	free( p );
}

// exec
void CProcStart::Exec( const string &rCmd, char** pArg ) const
{
	// ҥץexec롣
	execv( rCmd.c_str(), pArg );

	// ԤϤɤ褦ʤΤǡɸ२顼Ϥ˥åФƤ
	fprintf( stderr, "It Failed to exec. command = \"%s\".", rCmd.c_str() );

	_exit( -1 );
}

// 
const CProcStart& CProcStart::operator =( const CProcStart& r )
{
	cmd = r.cmd;
	listArg = r.listArg;
	return (*this);
}

