/////////////////////////////////////////////////////////////
// TaEditClient.c
// ɮ饤

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <door.h>
#include <string.h>
#include <sys/mman.h>
#include <memory.h>
#include <errno.h>
#include <unistd.h>
#include <sys/wait.h>
#include <limits.h>

#include <string>
#include <list>
#include <map>

#include "VPtr.h"
#include "ClientCO.h"
#include "CommandID.h"
#include "NegCmd.h"
#include "ProcStart.h"
#include "DoorClient.h"
#include "GlbFunc.h"

#include <StringTable.h>
#include <EnvValSet.h>

using namespace NNabikiVPtr;
using namespace std;

static string AddYen( const string& rStr );
static string AttachStdIO( int d );
static char *CopyString( const char* p, const CStringTable &rStringTable );
static string GetDoorFilePath( const CStringTable &rStringTable );
static bool StartServer( const CStringTable &rStringTable );
static bool StartSyuhitu( const CClientCO &option, const CStringTable &rStringTable );
static bool StartSyuhituByServer( const CClientCO &option, const CStringTable &rStringTable );
static bool SendCommand( const CNegCmd &negcmd, CNegCmd *pRetNC, const CStringTable &rStringTable );
bool PrintMessage( const CNegCmd &rmsg, const CStringTable &rStringTable );
static void StopServer( bool ByForce, const CStringTable &rStringTable );
static bool ShowFName( const CStringTable &rStringTable );
static bool UnjoinConstructionMode( int pid, const CStringTable &rStringTable );

// /ĤƤ뤳Ȥݾڤ
string AddYen( const string& rStr )
{
	if ( rStr.length() == 0 ) return "/";
	if ( rStr[ rStr.length() - 1 ] != '/' )
		return rStr + '/';
	else
		return rStr;
}


// ɸϤʤɤե˴ϢŤ
string AttachStdIO( int d )
{
	char Buf[ L_tmpnam + 1];
	int fd;

	// ƥݥΥե̾
	tmpnam( Buf );

	// ե
	fd = open( Buf, O_RDWR | O_CREAT | O_EXCL, 0600 );
	if ( fd < 0 ) return "";
	close( fd );

	// ǰΤ
	fdetach( Buf );

	// å
	if ( !fattach( d, Buf ) )
		return Buf;	// 

	// Ԥե
	remove( Buf );
	return "";
}

// doorΥե̾
string GetDoorFilePath( const CStringTable &rStringTable )
{
	string r;
	const char *p = getenv( SCEV_COMMUNITY_PATH );
	if ( !p ) {
		fprintf( stderr,
			"ERROR Syuhitu client : %s - %s\n",
			rStringTable.GetStr( L"CLIENT_ERRMSG_FAILED_GET_ENVIRONMENT_VALIABLES", "" ).c_str(),
			SCEV_COMMUNITY_PATH
		);
		return "";
	}

	r = AddYen( string( p ) ) + SCPX_DOOR;

	return r;
}

// Фư
bool StartServer( const CStringTable &rStringTable )
{
	string DoorFileName = GetDoorFilePath( rStringTable );
	const char *pServerPath = getenv( SCEV_SERVER_PATH );
	char wBuf[256];
	int fd[2] = { -1, -1 };
	bool r = false;
	int i;
	CProcStart procStart;

	// doorͭݤǧ
	// ѲǽǤСäˤ뤳ȤϤʤ
	if ( CDoorClient::CheckDoor( DoorFileName.c_str() ) )
		return true;

	if ( DoorFileName.empty() ) goto ERR_EXIT;

	// ФȤ̿ѤΥѥפ
	if ( pipe( fd ) ) goto ERR_EXIT;

	// Фư
	snprintf( wBuf, 256, "%d", fd[1] );
	procStart.SpecifyCommand( string( pServerPath ) );
	procStart.AddArg( DoorFileName );
	procStart.AddArg( string( wBuf ) );
	r = procStart.Start();
	if ( r < 0 ) goto ERR_EXIT;

	// ФαԤ
	i = read( fd[0], wBuf, 256 );
	if ( i > 0 && i < 256 ) {
		wBuf[i] = '\0';
		if ( strncmp( wBuf,"OK\n", i ) )
			r = false;
	}

ERR_EXIT:
	// ѥפĤ
	if ( fd[0] >= 0 ) close( fd[0] );
	if ( fd[1] >= 0 ) close( fd[1] );

	// ɬפ˱ƥ顼åɽ
	if ( !r ) {
		fprintf( stderr, "ERROR Syuhitu client : %s\n",
			rStringTable.GetStr( L"CLIENT_ERRMSG_FAILED_START_SERVER", "" ).c_str()
		);
	}

	return r;
}

// ɮư
bool StartSyuhitu( const CClientCO &option, const CStringTable &rStringTable )
{
	const char *p;
	CProcStart procStart;

	p = getenv( SCEV_TAEDIT_PATH );
	if ( NULL == p ) {
		fprintf( stderr,
			"ERROR Syuhitu client : %s - %s\n",
			rStringTable.GetStr( L"CLIENT_ERRMSG_FAILED_GET_ENVIRONMENT_VALIABLES", "" ).c_str(),
			SCEV_TAEDIT_PATH
		);
		return false;
	}

	procStart.SpecifyCommand( string( p ) );

	if ( option.GetFileName().length() > 0 )
		procStart.AddArg( string( "/file:" ) + option.GetFileName() );

	if ( option.GetLineNumber() > 0 ) {
		char wBuf[128];
		snprintf( wBuf, 128, "/line:%d", option.GetLineNumber() );
		procStart.AddArg( string( wBuf ) );
	}

	if ( option.GetLangType().length() > 0 )
		procStart.AddArg( string( "/syntax:" ) + option.GetLangType() );

	if ( option.GetStandAlone() )
		procStart.AddArg( string( "/standalone" ) );

	if ( option.GetEncodeName().length() > 0 )
		procStart.AddArg( string( "/encode:" ) + option.GetEncodeName() );

	if ( option.GetAdditionalArgument().length() > 0 )
		procStart.AddArg( option.GetAdditionalArgument() );

	if ( procStart.Start() < 0 ){
		fprintf( stderr, "ERROR Syuhitu client : %s\n",
			rStringTable.GetStr( L"CLIENT_ERRMSG_FAILED_START_SYUHITU", "" ).c_str()
		);
		return false;
	}
	return true;
}

// зͳǼɮư
bool StartSyuhituByServer( const CClientCO &option, const CStringTable &rStringTable )
{
	string StdOutName;	// ɸϤϢŤեΥѥ̾
	string StdErrName;	// Ʊɸ२顼
	string FileName;	// ե̾
	int LineNumber;		// ֹ
	string LangType;	// ʸ
	string EncodeName;	// 󥳡
	CEnvValSet EnvValSet;	// Ķѿ
	string AdditionalArgument;	// ɮư˻ꤹɲäΰ
	CNegCmd negcmd;
	CNegCmd retcmd;
	bool r = false;
	int len;
	int i;

	// ɸϤɸ२顼Ϥե˴ϢŤ
	StdOutName = AttachStdIO( 1 );
	if ( StdOutName.length() == 0 ) {
		fprintf( stderr, "ERROR Syuhitu client : %s - stdout\n",
			rStringTable.GetStr( L"CLIENT_ERRMSG_FAILED_ATTACH_FILE", "" ).c_str()
		);
	}

	StdErrName = AttachStdIO( 2 );
	if ( StdErrName.length() == 0 ) {
		fprintf( stderr, "ERROR Syuhitu client : %s - stderr\n",
			rStringTable.GetStr( L"CLIENT_ERRMSG_FAILED_ATTACH_FILE", "" ).c_str()
		);
	}

	// ץͤ
	FileName = option.GetFileName();
	LineNumber = option.GetLineNumber();
	LangType = option.GetLangType();
	EncodeName = option.GetEncodeName();
	AdditionalArgument = option.GetAdditionalArgument();

	// ޥɼ̤
	negcmd.AddData( SCI_S_COMMAND, SCID_CMD_OPENFILE_CS );

	// ե̾
	if ( !FileName.empty() )
		negcmd.AddData( SCI_S_FILE_NAME, FileName );

	// ֹ
	if ( LineNumber > 0 )
		negcmd.AddData( SCI_S_LINE_NUMBER, LineNumber );

	// ʸ
	if ( !LangType.empty() )
		negcmd.AddData( SCI_S_SYNTAX, LangType );

	// 󥳡
	if ( !EncodeName.empty() )
		negcmd.AddData( SCI_S_ENCODE_NAME, EncodeName );

	// ɮϤɲäΰ
	if ( !AdditionalArgument.empty() )
		negcmd.AddData( SCI_S_ADDITION_ARG, AdditionalArgument );

	// ɸϤΥե̾
	if ( !StdOutName.empty() )
			negcmd.AddData( SCI_S_STDOUT, StdOutName );

	// ɸ२顼ϤΥե̾
	if ( !StdErrName.empty() )
		negcmd.AddData( SCI_S_STDERR, StdErrName );

	// ߤδĶѿ
	EnvValSet.ReadEnvironment();
	negcmd.AddData( SCI_S_ENV_VAL_SET, EnvValSet );

	// Ф˥ޥɤ
	r = SendCommand( negcmd, &retcmd, rStringTable );
	if ( r ) PrintMessage( retcmd, rStringTable );

	// ɸϤʤɤ˥å줿ե
	if ( StdOutName.length() > 0 ) {
		fdetach( StdOutName.c_str() );
		remove( StdOutName.c_str() );
	}
	if ( StdErrName.length() > 0 ) {
		fdetach( StdErrName.c_str() );
		remove( StdErrName.c_str() );
	}

	return r;
}

// Ф˥ޥɤ
bool SendCommand( const CNegCmd &negcmd, CNegCmd *pRetNC, const CStringTable &rStringTable )
{
	string DoorFileName;
	VPtr< char > pRetBuf;
	CDoorClient doorClient;

	// doorΥե̾
	DoorFileName = GetDoorFilePath( rStringTable );
	if ( DoorFileName.length() <= 0 ) return false;

	// door򳫤
	if ( !doorClient.Open( DoorFileName.c_str() ) ) {
		fprintf( stderr, "ERROR Syuhitu client : %s\n",
			rStringTable.GetStr( L"CLIENT_ERRMSG_SERVER_MIGHT_STOPPED", "" ).c_str()
		);
		return false;
	}

	// doorƤӽФ
	pRetBuf = doorClient.Call( &negcmd );
	if ( !pRetBuf.GetPtr() ) {
		// ƤӽФ˼Ԥ
		fprintf( stderr, "ERROR Syuhitu client : %s\n",
			rStringTable.GetStr( L"CLIENT_ERRMSG_FAILED_CALL_SERVER", "" ).c_str()
		);
		return false;
	}

	// ̤᤹
	CNegCmd rmsg( pRetBuf.GetPtr(), pRetBuf.GetLen() );
	if ( pRetNC ) (*pRetNC) = rmsg;
	return true;
}

// ͤΥåɽ
// äϡ⤷ʤǿ֤
bool PrintMessage( const CNegCmd &rmsg, const CStringTable &rStringTable )
{
	string ErrMsg;

	// OKʤ齪λ
	if ( rmsg.GetData( SCI_R_STATUS, SCID_RSTAT_ERR ) == SCID_RSTAT_OK )
		return true;

	// 顼å
	switch ( rmsg.GetData( SCI_R_MSG_NUMBER, SCID_RMSG_UNEXPENTED ) ) {
	case SCID_RMSG_OUTOFMEMORY:
		ErrMsg = rStringTable.GetStr( L"SCID_RMSG_OUTOFMEMORY", "" );
		break;
	case SCID_RMSG_FILEISOPEND:
		ErrMsg = rStringTable.GetStr( L"SCID_RMSG_FILEISOPEND", "" );
		break;
	case SCID_RMSG_TAEDIT_IS_EXIST:
		ErrMsg = rStringTable.GetStr( L"SCID_RMSG_TAEDIT_IS_EXIST", "" );
		break;
	case SCID_RMSG_SERVER_REVOKED:
		ErrMsg = rStringTable.GetStr( L"SCID_RMSG_SERVER_REVOKED", "" );
		break;
	case SCID_RMSG_CMDDATA_INSUFFICIENCY:
		ErrMsg = rStringTable.GetStr( L"SCID_RMSG_CMDDATA_INSUFFICIENCY", "" );
		break;
	default:
		ErrMsg = rmsg.GetData( SCI_R_FREE_MSG, "" );
		if ( ErrMsg.empty() )
			ErrMsg = rStringTable.GetStr( L"SCID_RMSG_UNEXPENTED", "" );
	}

	// 顼åɽ
	fprintf( stderr,
		"ERROR Syuhitu client : %s - %s\n",
		rStringTable.GetStr( L"CLIENT_ERRMSG_INTERNAL_SERVER_ERR", "" ).c_str(),
		ErrMsg.c_str()
	);

	return false;
}

// Фߤ
void StopServer( bool ByForce, const CStringTable &rStringTable )
{
	CNegCmd negcmd;
	CNegCmd retcmd;

	if ( ByForce )
		negcmd.AddData( SCI_S_COMMAND, SCID_CMD_STOP_FORCE_CS );
	else
		negcmd.AddData( SCI_S_COMMAND, SCID_CMD_STOP_CS );

	if ( !SendCommand( negcmd, &retcmd, rStringTable ) ) return ;

	if ( PrintMessage( retcmd, rStringTable ) ) {
		// åɽƤ
		fprintf( stderr,
			"Syuhitu client : %s\n",
			rStringTable.GetStr( L"CLIENT_SUCCEED_STOP_SERVER", "" ).c_str()
		);
	}
}

// ƤեΥե̾ɽ
bool ShowFName( const CStringTable &rStringTable )
{
	CNegCmd negcmd;
	CNegCmd r_negcmd;
	string rstr;
	int i, j;

	// ޥɤ
	negcmd.AddData( SCI_S_COMMAND, SCID_CMD_REQUEST_FNAME );

	// ޥɤ
	if ( !SendCommand( negcmd, &r_negcmd, rStringTable ) ) return false;
	if ( !PrintMessage( r_negcmd, rStringTable ) ) return false;

	// ե̾ΰɽ
	rstr = r_negcmd.GetData( SCI_S_OTHER, "" );
	if ( rstr.length() == 0 ) {
		// ɽΤϲʤ
		return true;
	}

	// pidȥե̾ɽ
	i = 0;
	while ( i < rstr.length() ) {
		// pidɽ
		printf( "%s : ", rstr.c_str() + i );

		// ե̾ʬ򸡺
		for (; i < rstr.length() && rstr[i] != '\0'; i++ );
		if ( i >= rstr.length() ) break;
		i++;

		// ե̾ɽ
		printf( "%s\n", rstr.c_str() + i );

		// pidʬ򸡺
		for (; i < rstr.length() && rstr[i] != '\0'; i++ );
		if ( i >= rstr.length() ) break;
		i++;
	}
	return true;
}

// pid˻ꤷɮ򡢥ɥ⡼ɤذܹԤ
bool UnjoinConstructionMode( int pid, const CStringTable &rStringTable )
{
	CNegCmd negcmd;
	CNegCmd retcmd;

	// ޥɤ
	negcmd.AddData( SCI_S_COMMAND, SCID_CMD_UNJOIN_CS );
	negcmd.AddData( SCI_S_PID, pid );

	// ޥɤ
	if ( !SendCommand( negcmd, &retcmd, rStringTable ) ) return false;
	return PrintMessage( retcmd, rStringTable );
}

// ե¸Ȥη̤ɽ
void PrintMessage_OnSave( const CNegCmd &retcmd, const CStringTable &rStringTable )
{
	bool r = ( retcmd.GetData( SCI_R_STATUS, SCID_RSTAT_ERR ) == SCID_RSTAT_OK );
	if ( r ) {
		// ե̾ξ¸ϹԤäƤʤ
		if ( retcmd.GetData( SCI_S_FILE_NAME, "" ).length() > 0 )
			fprintf( stderr, "Succeed : " );
		else
			fprintf( stderr, "Skipped : " );
	}
	else
		fprintf( stderr, "Failed : " );
	fprintf( stderr, "%d : %s : %s : %s\n",
		retcmd.GetData( SCI_S_PID, -1 ),
		retcmd.GetData( SCI_S_FILE_NAME, "" ).c_str(),
		retcmd.GetData( SCI_S_ENCODE_NAME, "" ).c_str(),
		retcmd.GetData( SCI_S_CR_TYPE, "" ).c_str()
	);
	if ( !r ) {
		// ԤȤϥåɽ
		fprintf( stderr, "---" );
		PrintMessage( retcmd, rStringTable );
	}
}

// ꤷɮˡե¸ؼ
bool Save( const CClientCO &rOption, const CStringTable &rStringTable )
{
	CNegCmd negcmd;
	CNegCmd retcmd;
	bool r = true;

	// ޥɤ
	negcmd.AddData( SCI_S_COMMAND, SCID_CMD_SAVE_CS );
	if ( rOption.GetQueryFileName() )
		negcmd.AddData( SCI_S_FLG, "query" );
	else
		negcmd.AddData( SCI_S_FLG, "nothing" );
	negcmd.AddData( SCI_S_PID, rOption.GetProcID() );
	negcmd.AddData( SCI_S_FILE_NAME, rOption.GetFileName() );
	negcmd.AddData( SCI_S_ENCODE_NAME, rOption.GetEncodeName() );
	negcmd.AddData( SCI_S_CR_TYPE, rOption.GetCRTypeName() );

	// ޥɤ
	if ( !SendCommand( negcmd, &retcmd, rStringTable ) ) return false;

	// ̤ɽ
	PrintMessage_OnSave( retcmd, rStringTable );

	return r;
}

// ٤Ƥμɮˡե¸ؼ
bool SaveAll( const CClientCO &rOption, const CStringTable &rStringTable )
{
	CNegCmd negcmd;
	CNegCmd retcmd;
	vector< CNegCmd > vcmd;
	int i;
	bool r;

	// ޥɤ
	negcmd.AddData( SCI_S_COMMAND, SCID_CMD_SAVE_ALL_CS );
	if ( rOption.GetQueryFileName() )
		negcmd.AddData( SCI_S_FLG, "query" );
	else
		negcmd.AddData( SCI_S_FLG, "nothing" );

	// ޥɤ
	if ( !SendCommand( negcmd, &retcmd, rStringTable ) ) return false;

	// ¸ե뤴ȡ̤ɽ
	vcmd = retcmd.GetData( SCI_S_NEGCMT_VEC, vector< CNegCmd >() );
	for ( i = 0; i < vcmd.size(); i++ )
		PrintMessage_OnSave( vcmd[i], rStringTable );

	return true;
}

int main( int argc, char *argv[] )
{
	string DoorFileName;
	CClientCO option;
	CStringTable StringTable;

	// ȥ󥰥ơ֥
	StringTable.Initialize( getenv( SCEV_STRINGTABLE_PATH ) );

	// ǥեͤ
	StringTable.SetDefault( L"SCID_RMSG_UNEXPENTED", L"Unexpected Error" );
	StringTable.SetDefault( L"SCID_RMSG_OUTOFMEMORY", L"Out of memory" );
	StringTable.SetDefault( L"SCID_RMSG_FILEISOPEND", L"Specified file is opened" );
	StringTable.SetDefault( L"SCID_RMSG_TAEDIT_IS_EXIST", L"Syuhitu instance is exist" );
	StringTable.SetDefault( L"SCID_RMSG_SERVER_REVOKED", L"Syuhitu server was revoked" );
	StringTable.SetDefault( L"SCID_RMSG_CMDDATA_INSUFFICIENCY", L"Internal error" );
	StringTable.SetDefault( L"CLIENT_ERRMSG_FAILED_GET_ENVIRONMENT_VALIABLES", L"Failed to get environment valiable." );
	StringTable.SetDefault( L"CLIENT_ERRMSG_FAILED_START_SERVER", L"Failed to start syuhitu server." );
	StringTable.SetDefault( L"CLIENT_ERRMSG_FAILED_START_SYUHITU", L"Failed to start syuhitu." );
	StringTable.SetDefault( L"CLIENT_ERRMSG_FAILED_ATTACH_FILE", L"Failed to attach a file." );
	StringTable.SetDefault( L"CLIENT_ERRMSG_SERVER_MIGHT_STOPPED", L"Server might be stopped." );
	StringTable.SetDefault( L"CLIENT_ERRMSG_FAILED_CALL_SERVER", L"Faile to call server." );
	StringTable.SetDefault( L"CLIENT_ERRMSG_INTERNAL_SERVER_ERR", L"Internal server error." );
	StringTable.SetDefault( L"CLIENT_SUCCEED_STOP_SERVER", L"Succeed to stop server." );

	// ޥɤΥץ
	if ( !option.Initialize( argc, argv ) ) return 0;

	switch ( option.GetCmdType() ) {
	case CT_FILE_OPEN:
		// եΥץ

		if ( option.GetStandAlone() ) {
			// ɥξϡɮưƽλ
			if ( StartSyuhitu( option, StringTable ) )
				return 0;
			else
				return 1;
		}

		// Фư
		if ( !StartServer( StringTable ) ) return 1;

		// ɮư
		if ( !StartSyuhituByServer( option, StringTable ) ) return 1;

		break;

	case CT_BOOT_SERVER:
		// ФεưΤ
		if ( !StartServer( StringTable ) ) return 1;
		break;

	case CT_STOP_SERVER:
		// Ф
		StopServer( option.GetStopSvrByForce(), StringTable );
		break;

	case CT_SHOW_FNMAE:
		// ƤեΥե̾ɽ
		if ( !ShowFName( StringTable ) ) return 1;
		break;

	case CT_UNJOIN_CONSTRUCTION_MODE:
		// ꤷɮ򥹥ɥ⡼ɤذܹԤ
		if ( !UnjoinConstructionMode( option.GetProcID(), StringTable ) )
			return 1;
		break;

	case CT_SAVE:
		// ꤷɮˡե¸ؼ
		if ( !Save( option, StringTable ) )
			return 1;
		break;

	case CT_SAVE_ALL:
		// ٤Ƥμɮ˥ե¸ؼ
		if ( !SaveAll( option, StringTable ) )
			return 1;
		break;
	}

	return 0;
}
