////////////////////////////////////////////////////////////////////////////
// CClientCO 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include <stdlib.h>
#include <assert.h>

#include "ClientCO.h"
#include "GlbFunc.h"

using namespace GlbFunc;

#define SWITCH_CHAR '-'

////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CClientCO::CClientCO() :
	FileName( "" ),
	LineNumber( 1 ),
	LangType( "" ),
	StandAlone( false ),
	StopSvrByForce( false ),
	CmdType( CT_FILE_OPEN ),
	ProcID( 0 ),
	EncodeName( "" ),
	CRTypeName( "" ),
	QueryFileName( false ),
	AdditionalArgument( "" )
{

}

CClientCO::CClientCO( const CClientCO &r ):
	CmdType( r.CmdType ),
	FileName( r.FileName ),
	LineNumber( r.LineNumber ),
	LangType( r.LangType ),
	StandAlone( r.StandAlone ),
	StopSvrByForce( r.StopSvrByForce ),
	ProcID( r.ProcID ),
	QueryFileName( r.QueryFileName ),
	EncodeName( r.EncodeName ),
	CRTypeName( r.CRTypeName ),
	AdditionalArgument( r.AdditionalArgument )
{

}

CClientCO::~CClientCO()
{

}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// 
// η³Բǽʾϵ֤
bool CClientCO::Initialize( int argc, char *argv[] )
{
	int i;

	if ( argc <= 1 ) return true;

	// ǽΰåǤʤС[file][-s]η
	if ( argv[1][0] != SWITCH_CHAR ) {
		if ( argc >= 4 ) return help( argv[0] );
		if ( argc == 3 ) {
			// ɥ⡼
			if ( strcmp( argv[2], "-s" ) ) return help( argv[0] );
			StandAlone = true;
		}
		FileName = GlbFunc::ResolvPath( string( argv[1] ) );	// ե̾
		CmdType = CT_FILE_OPEN;
		return true;
	}

	if ( !strcmp( argv[1], "-h" ) ) return help( argv[0] );

	if ( !strcmp( argv[1], "-b" ) ) {
		// ФΥ֡ȤΤ
		if ( argc >= 3 ) return help( argv[0] );
		CmdType = CT_BOOT_SERVER;
		return true;
	}

	if ( !strcmp( argv[1], "-k" ) ) {
		// Ф
		if ( argc >= 3 ) return help( argv[0] );
		CmdType = CT_STOP_SERVER;
		StopSvrByForce = false;
		return true;
	}

	if ( !strcmp( argv[1], "-K" ) ) {
		// Фζ
		if ( argc >= 3 ) return help( argv[0] );
		CmdType = CT_STOP_SERVER;
		StopSvrByForce = true;
		return true;
	}

	if ( !strcmp( argv[1], "-FN" ) ) {
		// ƤեΥե̾ɽ
		if ( argc >= 3 ) return help( argv[0] );
		CmdType = CT_SHOW_FNMAE;
		return true;
	}

	if ( !strcmp( argv[1], "-UJ" ) ) {
		// ƤեΥե̾ɽ
		if ( argc != 3 ) return help( argv[0] );
		CmdType = CT_UNJOIN_CONSTRUCTION_MODE;
		ProcID = atoi( argv[2] );
		return true;
	}

	if ( !strcmp( argv[1], "-SV" ) ) {
		// ե¸
		CmdType = CT_SAVE;
		return InitiFileSave( argc, argv );
	}

	if ( !strcmp( argv[1], "-SVA" ) ) {
		// ٤ƤΥե¸
		if ( argc != 2 && argc != 3 )
			return help( argv[0] );
		QueryFileName = false;
		if ( argc == 3 ) {
			if ( !strcmp( argv[2], "-q" ) )
				QueryFileName = true;
			else
				return help( argv[0] );
		}
		CmdType = CT_SAVE_ALL;
		return true;
	}

	// ե򳫤
	CmdType = CT_FILE_OPEN;
	return InitiFileOpen( argc, argv );

	return true;
}

// ե򳫤ȤΥޥɤ᤹
bool CClientCO::InitiFileOpen( int argc, char *argv[] )
{
	int i = 1;

i = 1;

	FileName = "";
	LineNumber = 0;
	LangType = "";
	StandAlone = false;
	EncodeName = "";
	while ( i < argc ) {
		if ( !strcmp( argv[i], "-f" ) ) {
			// ե̾
			// -fμΰϡʶŪˡ˥ե̾ȸʤ
			if ( i >= argc - 1 ) {
				// ե̾ꤵƤʤȤϡά줿Τȸʤ
				// CDEΥեȥѥͥ뤫鵯ư硢Υѥ󤬵ꤦ
				FileName = "";
				i++;
			}
			else {
				FileName = GlbFunc::ResolvPath( string( argv[i+1] ) );
				i += 2;
			}
		}
		else if ( !strcmp( argv[i], "-l" ) ) {
			// ֹ
			if ( i >= argc - 1 ) return help( argv[0] );
			LineNumber = atoi( argv[i+1] );
			i += 2;
		}
		else if ( !strcmp( argv[i], "-t" ) ) {
			// ʸ
			if ( i >= argc - 1 ) return help( argv[0] );
			LangType = argv[i+1];
			i += 2;
		}
		else if ( !strcmp( argv[i], "-s" ) ) {
			// ɥ⡼
			StandAlone = true;
			i++;
		}
		else if ( !strcmp( argv[i], "-e" ) ) {
			// 󥳡
			if ( i >= argc - 1 ) return help( argv[0] );
			EncodeName = argv[i+1];
			i += 2;
		}
		else if ( !strcmp( argv[i], "-AA" ) ) {
			// ɮư˻ꤹɲäΰ
			if ( i >= argc - 1 ) return help( argv[0] );
			AdditionalArgument = argv[i+1];
			i += 2;
		}
		else {
			// 顼
			return help( argv[0] );
		}
	}
	if ( FileName.length() == 0 ) {
		// ե̾ꤵƤʤäϡ
		// ʸ̤ʤɤλ̵뤹
		LineNumber = 1;
		LangType = "";
		EncodeName = "";
	}
	return true;
}

// ե¸ȤΥޥɤ᤹
bool CClientCO::InitiFileSave( int argc, char *argv[] )
{
	int i = 3;

	if ( argc <= 2 ) return help( argv[0] );

	// pid
	ProcID = atoi( argv[2] );

	FileName = "";
	QueryFileName = false;
	EncodeName = "";
	CRTypeName = "";
	while ( i < argc ) {
		if ( !strcmp( argv[i], "-q" ) ) {
			// ե̾ʤˡ桼¸ե̾䤤碌뤫ݤ
			QueryFileName = true;
			i++;
		}
		else if ( !strcmp( argv[i], "-f" ) ) {
			// ¸ե̾
			if ( i >= argc - 1 ) return help( argv[0] );
			FileName = GlbFunc::ResolvPath( string( argv[i+1] ) );
			i += 2;
		}
		else if ( !strcmp( argv[i], "-e" ) ) {
			// 󥳡
			if ( i >= argc - 1 ) return help( argv[0] );
			EncodeName = argv[i+1];
			i += 2;
		}
		else if ( !strcmp( argv[i], "-c" ) ) {
			// ԥɤμ
			CRTypeName = argv[i+1];
			i += 2;
		}
		else {
			// 顼
			return help( argv[0] );
		}
	}
	return true;
}

// ޥɤΥץɽ
bool CClientCO::help( const char *cmd )
{
	string CmdName;
	int len;
	int i;

	assert( cmd );

	// ̤ɽ륳ޥ̾ꤹ
	len = strlen( cmd );
	if ( len == 0 ) {
		CmdName = "TaEditClient";
	}
	else {
		for ( i = len - 1; i >= 0 && cmd[i] != '/'; i-- );
		if ( i < 0 )
			CmdName = cmd;
		else
			CmdName = cmd + i + 1;
	}

	fprintf( stderr, "%s : Syuhitu Client\n", CmdName.c_str() );
	fprintf( stderr, "  Command Option\n" );
	fprintf( stderr, "   %s [file] [-s]\n", CmdName.c_str() );
	fprintf( stderr, "   %s -f file [-l line] [-t syntax] [-s] [-e encode] [-AA arg]\n", CmdName.c_str() );
	fprintf( stderr, "   %s -h\n", CmdName.c_str() );
	fprintf( stderr, "   %s -b\n", CmdName.c_str() );
	fprintf( stderr, "   %s -k\n", CmdName.c_str() );
	fprintf( stderr, "   %s -K\n", CmdName.c_str() );
	fprintf( stderr, "   %s -FN\n", CmdName.c_str() );
	fprintf( stderr, "   %s -UJ pid\n", CmdName.c_str() );
	fprintf( stderr, "   %s -SV pid [-q] [-f file] [-e encode] [-c CRType]\n", CmdName.c_str() );
	fprintf( stderr, "   %s -SVA [ -q ]\n", CmdName.c_str() );
	fprintf( stderr, "  -s : Stand alone mode.\n" );	
	fprintf( stderr, "  -l : Cursor position.\n" );	
	fprintf( stderr, "  -t : Syntax mode.\n" );	
	fprintf( stderr, "  -h : Show this message.\n" );	
	fprintf( stderr, "  -b : Boot server only.\n" );
	fprintf( stderr, "  -k : Stop server.\n" );
	fprintf( stderr, "  -K : Stop server by force.\n" );
	fprintf( stderr, "  -FN : Show file names opend by Syuhitu.\n" );
	fprintf( stderr, "  -UJ : Set standalone mode to Syuhitu.\n" );
	fprintf( stderr, "  -SV : Save a file.\n" );
	fprintf( stderr, " -SVA : Save all files.\n" );

	return false;
}

// ե饰Ϥ
int CClientCO::RecognizeFlg( int argc, char *argv[], const char *pFlg )
{
	int i;

	for ( i = 0; i < argc; i++ ) {
		if ( strcmp( argv[i], pFlg ) == 0 )
			return i;
	}
	return i;
}

// ޥɤμ̤
CMDTYPE CClientCO::GetCmdType() const
{
	return CmdType;
}

const string& CClientCO::GetFileName() const
{
	return FileName;
}

int CClientCO::GetLineNumber() const
{
	return LineNumber;
}

const string& CClientCO::GetLangType() const
{
	return LangType;
}

bool CClientCO::GetStandAlone() const
{
	return StandAlone;
}

bool CClientCO::GetStopSvrByForce() const
{
	return StopSvrByForce;
}

int CClientCO::GetProcID() const
{
	return ProcID;
}

bool CClientCO::GetQueryFileName() const
{
	return QueryFileName;
}

const string& CClientCO::GetEncodeName() const
{
	return EncodeName;
}

const string& CClientCO::GetCRTypeName() const
{
	return CRTypeName;
}

const string& CClientCO::GetAdditionalArgument() const
{
	return AdditionalArgument;
}

// 
const CClientCO& CClientCO::operator =( const CClientCO &r )
{
	CmdType = r.CmdType;
	FileName = r.FileName;
	LineNumber = r.LineNumber;
	LangType = r.LangType;
	StandAlone = r.StandAlone;
	StopSvrByForce = r.StopSvrByForce;
	ProcID = r.ProcID;
	QueryFileName = r.QueryFileName;
	EncodeName = r.EncodeName;
	CRTypeName = r.CRTypeName;
	AdditionalArgument = r.AdditionalArgument;
	return (*this);
}
