////////////////////////////////////////////////////////////////////////////
// TaEditJPEXT.cc Хؿ
//
////////////////////////////////////////////////////////////////////////////

#include "TaEditJPEXT.h"
#include "TaEditShell.h"
#include "CompoundStr.h"


#include <Xm/XmAll.h>
#include <limits.h>
#include <iconv.h>
#include <langinfo.h>

using namespace std;

static bool ChangeEncodeSpecifiedCD( iconv_t cd, const char *pSrc, string *pDst );
static CErrorBool UCStoClipboardEncode( const wchar_t *pSrc, string *pDest );
static CErrorBool ClipboardEncodetoCUS( const char *pSrc, wstring *pDest );

/*//////////////////////////////////////////////////////////
// եѤδؿʤɤ
//////////////////////////////////////////////////////////*/

// ե̾եȥåȤۤ
// XLoadQueryFontؿ֤
XFontSet JPEXT_CreateFontSet( Display *pDisplay, const char *pFontName )
{
	char **missing_list;
	int missing_count;
	char *def_string;
	XFontSet fontSet;

	// ꤵ줿ե̾ǥեȥåȤۤ
	fontSet = XCreateFontSet( pDisplay, pFontName, &missing_list, &missing_count, &def_string );

	// 顢ΥեȥåȤ֤
	if ( fontSet ) return fontSet;

	// Ԥ顢Ȥꤢ餫ΥեȥåȤۤ롣
	fontSet = XCreateFontSet( pDisplay, "*", &missing_list, &missing_count, &def_string );

	// 顢ȤꤢΥեȥåȤ֤
	if ( fontSet ) return fontSet;

	// Ԥ饢ܡȤ롣
	fprintf( stderr, "Can't create fontset." );
	abort();
}


// եȥåȤ顢ʸ
// flg = 0
// flg = 1Ǿ
short JPEXT_GetFontWidth( XFontSet fs, int flg )
{
	XFontStruct **pvFontStr;
	char **pvFontName;
	short Width;
	int cnt;
	int i;

	// եȹ¤Τȥե̾ΥꥹȤ
	cnt = XFontsOfFontSet( fs, &pvFontStr, &pvFontName );

	Width = SHRT_MAX * flg;
	// ⤷ϺǾͤ
	for ( i = 0; i < cnt; i++ ) {
		if ( 0 == flg ) {
			if ( Width < pvFontStr[ i ]->max_bounds.width )
				Width = pvFontStr[ i ]->max_bounds.width;
		}
		else {
			if ( Width > pvFontStr[ i ]->min_bounds.width )
				Width = pvFontStr[ i ]->min_bounds.width;
		}
	}

	return Width;
}

// եȥåȤ顢ʸ
// (CFontStruct)->max_bounds.width֤
short JPEXT_GetMaxWidth( XFontSet fs )
{
	return JPEXT_GetFontWidth( fs, 0 );
}

// եȥåȤ顢ʸ
// (CFontStruct)->min_bounds.width֤
short JPEXT_GetMinWidth( XFontSet fs )
{
	return JPEXT_GetFontWidth( fs, 1 );
}

// ascent
short JPEXT_GetFont_ascent( XFontSet fs )
{
	XFontStruct **pvFontStr;
	char **pvFontName;
	long Max = 0;
	int cnt = XFontsOfFontSet( fs, &pvFontStr, &pvFontName );
	int i;
	for ( i = 0; i < cnt; i++ ) {
		if ( Max < pvFontStr[ i ]->ascent )
			Max = pvFontStr[ i ]->ascent;
	}
	return Max;
}

// descent
short JPEXT_GetFont_descent( XFontSet fs )
{
	XFontStruct **pvFontStr;
	char **pvFontName;
	long Max = 0;
	int i;
	int cnt = XFontsOfFontSet( fs, &pvFontStr, &pvFontName );
	for ( i = 0; i < cnt; i++ ) {
		if ( Max < pvFontStr[ i ]->descent )
			Max = pvFontStr[ i ]->descent;
	}
	return Max;
}

// եȥåȤ顢⤵
short JPEXT_GetFontHeight( XFontSet fs )
{
	return JPEXT_GetFont_ascent( fs ) + JPEXT_GetFont_descent( fs );
}

/*//////////////////////////////////////////////////////////
// ʸɤ䥨󥳡ɤѴ
//////////////////////////////////////////////////////////*/

// ޥХʸ֤ˤơ󥳡ɤѴ
bool JPEXT_ChangeEncode( const char *pSrc, string *pDst, const char *pSrcEncode, const char *pDestEncode )
{
	bool r;

	pDst->clear();
	iconv_t cd = iconv_open( pDestEncode, pSrcEncode );
	if ( cd == (iconv_t)-1 ) return false;
	r = ChangeEncodeSpecifiedCD( cd, pSrc, pDst );
	iconv_close( cd );
	return r;
}

// iconv_tꤷƤΥ󥳡Ѵ
bool ChangeEncodeSpecifiedCD( iconv_t cd, const char *pSrc, string *pDst )
{
	char OutBuf[128*8];	// iconvνϥХåե
	size_t OutBufLen;	// OutBufΤλѤǤХåեĹ
	const char *ip;
	size_t InBufLen;
	char *op = OutBuf;
	int i;

	pDst->clear();
	InBufLen = strlen( pSrc ) * sizeof( char );
	ip = pSrc;
	op = OutBuf;
	OutBufLen = 128;
	while ( InBufLen > 0 ) {
		errno = 0;
		size_t r = iconv( cd, &ip, &InBufLen, &op, &OutBufLen );
		if ( r == (size_t)-1 ) {
			if ( errno == EILSEQ ) {
				// ̵ʥХȤ¸ߤϡ̵뤹
				ip++;
				InBufLen--;
			}
		}
		OutBuf[ op - OutBuf ] = L'\0';
		pDst->insert( pDst->length(), OutBuf, op - OutBuf );
		op = OutBuf;
		OutBufLen = 128;
	}
	return true;
}

// 磻ɥХʸǤդΥ󥳡ɤΥޥХʸѴ
bool JPEXT_WCStoSpecifiedEncodeMBS( const wchar_t *pWCS, string *pMBS, const char *pDestEncode )
{
	const char *pCurEncode = nl_langinfo( CODESET );	// ߤΥˤ륨󥳡
	char wBuf[ 128 + MB_LEN_MAX + 1 ];
	size_t InBufLen;
	size_t WCSLen;
	int i, j;
	string wStr;

	pMBS->clear();
	iconv_t cd = iconv_open( pDestEncode, pCurEncode );
	if ( cd == (iconv_t)-1 ) return false;

	WCSLen = wcslen( pWCS );	// ʸĹ
	i = 0;
	while ( i < WCSLen ) {
		// 磻ɥХʸ򡢰öޥХʸѴ
		j = 0;
		while ( j < 128 && i < WCSLen ) {
			j += wctomb( wBuf + j, pWCS[i] );
			i++;
		}
		wBuf[j] = '\0';

		// ޥХʸΥ󥳡ɤѴ
		if ( !ChangeEncodeSpecifiedCD( cd, wBuf, &wStr ) ) {
			iconv_close( cd );
			return false;
		}

		// ѤʸϢ뤹
		(*pMBS) += wStr;
	}
	iconv_close( cd );
	return true;
}

// ǤդΥ󥳡ɤΥޥХʸ磻ɥХʸѴ
bool JPEXT_SpecifiedEncodeMBStoWCS( const char *pMBS, wstring *pWCS, const char *pSrcEncode )
{
	const char *pCurEncode = nl_langinfo( CODESET );	// ߤΥˤ륨󥳡
	string wStr;
	pWCS->clear();

	// 󥳡ɤѴ
	if ( !JPEXT_ChangeEncode( pMBS, &wStr, pSrcEncode, pCurEncode ) )
		return false;

	// ޥХʸ磻ɥХʸѴ
	return GlbFunc::MBStoWCS( wStr.c_str(), pWCS );
}

// åץܡɤ˥ǡꤹ
CErrorBool JPEXT_SetClipboardData( Widget w, const std::wstring &rStr )
{
	Display *pDisplay = XtDisplay( w );
	Window window = XtWindow( w );
	CCompoundStr ClipLabel( "text" );
	int status;
	long item_id = 0;
	string wStr, wStr2;
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	CErrorBool r;

	// 磻ɥХʸޥХʸѴ
	if ( !GlbFunc::WCStoMBS( rStr.c_str(), &wStr ) )
		return pConf->RefOutOfMemoryErrorMsg();

/*	if ( !JPEXT_WCStoSpecifiedEncodeMBS( rStr.c_str(), &wStr, pConf->RefClipboardEncode().c_str() ) )
		return pConf->RefOutOfMemoryErrorMsg();
*/

	// åץܡɤå
	do {
		status = XmClipboardStartCopy(
			pDisplay, window, ClipLabel, CurrentTime, NULL, NULL, &item_id
		);
	} while ( status == ClipboardLocked );

	// ǡϿ
	do {
		status = XmClipboardCopy (
			pDisplay, window, item_id, const_cast< char* >( "STRING" ),
			(char*)wStr.c_str(), ( wStr.length() + 1 ) * sizeof( char ), 0, NULL
		);
	} while ( status == ClipboardLocked );

	// åץܡɤ˥ǡž롣
	do {
		status = XmClipboardEndCopy ( pDisplay, window, item_id );
	} while ( status == ClipboardLocked );
	return true;
}

// åץܡɤǡ
CErrorBool JPEXT_GetClipboardData( Widget w, std::wstring *pStr )
{
	Display *pDisplay = XtDisplay( w );
	Window window = XtWindow( w );
	int status;
	long item_id = 0;
	unsigned long DataLength = 0;
	VPtr< char > pBuf;
	const char FormatString[3][10] = { "TEXT", "C_STRING", "STRING" };
	int type;	// FormatStringΥǥݻ
	int i, j;
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();

	// åץܡɤ˵ϿƤǡĹ
	type = 0;
	do {
		do {
			status = XmClipboardInquireLength(
				pDisplay, window, const_cast< char* >( FormatString[type] ), &DataLength );
		} while ( status == ClipboardLocked );
		if ( ClipboardNoData == status || 0 == DataLength )
			type++;
	} while ( type < 3 && ClipboardNoData == status );
	if ( type == 3 ) {
		(*pStr) = L"";	// ֤٤ΤϤʤ
		return true;
	}

	// ΰݤ
	if ( !pBuf.Malloc( DataLength + 1 ) )
		return pConf->RefOutOfMemoryErrorMsg();

	// åץܡɤǡ
	do {
		status = XmClipboardRetrieve(
			pDisplay, window, const_cast< char* >( FormatString[type] ), pBuf.GetPtr(),
                        DataLength, NULL, NULL );
	} while ( status == ClipboardLocked );

/*
for ( i = 0; i < DataLength; i++ ) {
	printf( "%d : %c : 0x%02X\n", i, pBuf[i], 0xFF & pBuf[i] );
}
printf( "\n\n" );
*/

	if ( type == 0 ) {
		// ISO 2022ǥ󥳡ɤƤ餷
		// ѤƤޤ
		i = 0;
		j = 0;
		while ( i < DataLength ) {
			if ( pBuf[i] != 0x1b ) {
				pBuf[j] = pBuf[i];
				i++;
				j++;
			}
			else {
				if ( i + 1 < DataLength ) {
					if ( pBuf[ i + 1 ] == '$' )
						i += 4;
					else
						i += 3;
				}
				else
					i++;
			}
		}
		DataLength = j;
	}

	pBuf[DataLength] = '\0';
	GlbFunc::MBStoWCS( pBuf.GetPtr(), pStr );
	return true;
}

// ɽʸ򥯥åץܡѤʸѴ
CErrorBool UCStoClipboardEncode( const wchar_t *pSrc, string *pDest )
{
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	const string &rEncode = pConf->RefClipboardEncode();
	iconv_t cd;
	char OutBuf[1024];
	size_t OutBufLen;
	size_t InBufLen;
	const char *pInBuf;
	char *pOutBuf;
	size_t r;

	// ѴǥץƤ
	cd = iconv_open( rEncode.c_str(), "UTF-8" );
	if ( cd == (iconv_t)-1 )
		return pConf->RefFailToConvertCharSet();

	// ѴԤ
	OutBufLen = 128;
	InBufLen = wcslen( pSrc ) * sizeof( wchar_t );
	pInBuf = reinterpret_cast< const char* >( pSrc );
	pOutBuf = OutBuf;
	r = 0;
	while( InBufLen > 0 ) {
		errno = 0;
		r = iconv( cd, &pInBuf, &InBufLen, &pOutBuf, &OutBufLen );
		if ( r == (size_t)-1 ) {
			switch ( errno ) {
			case EINVAL:
				InBufLen = 0;
				break;
			case EILSEQ:
				InBufLen--;
				break;
			}
		}
		pOutBuf[0] = '\0';
		pDest->insert( pDest->length(), OutBuf, pOutBuf - OutBuf );
		OutBufLen = 128;
		pOutBuf = OutBuf;
	}
	
	// Ѵǥץ
	iconv_close( cd );

	return true;
}

// åץܡѤʸɽʸѴ
CErrorBool ClipboardEncodetoCUS( const char *pSrc, wstring *pDest )
{
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	const string &rEncode = pConf->RefClipboardEncode();
	return true;
}
