////////////////////////////////////////////////////////////////////////////
// CPlugin 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include "Plugin.h"
#include "TaEditShell.h"
#include "TaEditDraw.h"
#include "PluginFunc.h"
#include "CompoundStr.h"

////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CPlugin::CPlugin() :
	pPluginConf( NULL ),
	pCurPlugin( NULL ),
	pView( NULL ),
	Modified( false )
{

}

CPlugin::~CPlugin()
{
	confman_Close( pPluginConf );
	pPluginConf = NULL;
}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// ץ饰ν
////////////////////////////////////////////////////////////////////////////

// ץ饰
// ץ饰ξɤ߹ߡ˥塼ؤɲáɬפ˱ƥ˥塼ΥޥåפԤ
// Ѳǽʥץ饰̵ϡ֥ġץ˥塼ɽʤ
CErrorBool CPlugin::ConfigurePlugin( const string &rConfigFile, Widget wgtCascade, Widget wgtPullDown, CTaEditDraw *argpView )
{
	CErrorBool r;
	pView = argpView;

	// ե̾ꤵƤʤСץ饰ɤ߹ߤϹԤʤ
	if ( rConfigFile.empty() ) return true;

	// ѥ֥Ȥ
	m_WorkMemoryMgr.Initialize();

	// ɤ߹
	r = ReadPluginInfo( rConfigFile );
	if ( !r ) return r;

	// ɤ߹ǧ롣
	CheckPluginInfo();

	// ̤Ȥơͭʥץ饰󤬻ĤʤСλ
	if ( vPluginInfo.empty() ) return true;

	// ˥塼ۤ
	return CreateMenu( wgtCascade, wgtPullDown );
}

// ץ饰ξɤ߹
CErrorBool CPlugin::ReadPluginInfo( const string &rConfigFile )
{
	assert( this && NULL == pPluginConf );
	const CCompoundStr *pErrMsg = NULL;
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();

	VPtr< wchar_t > wBuf;
	const wchar_t *wptr;
	void *h;
	int length;

	vPluginInfo.clear();

	// ɤ߹
	pPluginConf = confman_CreateConf( rConfigFile.c_str() );
	if ( NULL == pPluginConf )
		return CErrorBool( pConf->RefOutOfMemoryErrorMsg() );
	if ( !confman_Open( pPluginConf ) ) {
		pErrMsg = &( pConf->RefIOErrorMsg( errno ) );
		goto ERR_EXIT;
	}

	// ̾
	h = exconf_CreateInternalSectionList( pPluginConf, &length );
	if ( NULL == h ) {
		pErrMsg = &( pConf->RefOutOfMemoryErrorMsg() );
		goto ERR_EXIT;
	}
	if ( !wBuf.Malloc( length ) ) {
		pErrMsg = &( pConf->RefOutOfMemoryErrorMsg() );
		goto ERR_EXIT;
	}
	exconf_GetInternalList( h, wBuf.GetPtr(), length );

	// ƥξɤ߹
	wptr = wBuf.GetPtr();
	while( (*wptr)  ) {
		// ˥֥Ȥɲ
		PLUGIN_INFO workObj;
		vector< PLUGIN_INFO >::iterator itr;
		vPluginInfo.push_back( workObj );
		itr = vPluginInfo.begin() + vPluginInfo.size() - 1;
		const wchar_t *pInfo;

		// ɬפʾɤ߹
		itr->SectionName = wptr;
		pInfo = exconf_GetConstStr( pPluginConf, wptr, L"PluginName" );
		if ( pInfo ) GlbFunc::WCStoMBS( pInfo, &( itr->PluginName ) );
		pInfo = exconf_GetConstStr( pPluginConf, wptr, L"IsSeparator" );
		if ( pInfo && wscasecmp( pInfo, L"True" ) == 0 ) {
				itr->IsSeparator = true;
		}
		else {
			itr->IsSeparator = false;
			pInfo = exconf_GetConstStr( pPluginConf, wptr, L"LibraryName" );
			if ( pInfo ) GlbFunc::WCStoMBS( pInfo, &( itr->LibraryName ) );
			pInfo = exconf_GetConstStr( pPluginConf, wptr, L"FunctionName" );
			if ( pInfo ) GlbFunc::WCStoMBS( pInfo, &( itr->FunctionName ) );
			itr->MenuLabel = "";
			pInfo = exconf_GetConstStr( pPluginConf, wptr, L"MenuLabel" );
			if ( pInfo ) GlbFunc::WCStoMBS( pInfo, &( itr->MenuLabel ) );
		}

		CF_SKIPPTR( wptr );
	}

	return true;

ERR_EXIT:
	vPluginInfo.clear();
	if ( pPluginConf ) confman_Close( pPluginConf );
	pPluginConf = NULL;
	return CErrorBool( (*pErrMsg) );
}

// ɤ߹ץ饰ξǧ ʥ顼ǡ
void CPlugin::CheckPluginInfo()
{
	int i;
	int j;

	i = vPluginInfo.size() - 1;
	while ( i >= 0 ) {
		bool r = true;
		// Ʊץ饰̾ʸ¸ߤϥ顼
		j = 0;
		while( j < i ) {
			if ( vPluginInfo[i].PluginName == vPluginInfo[j].PluginName ) {
				vPluginInfo.erase( vPluginInfo.begin() + j );
				r = false;
				--i;
			}
			else
				++j;
		}
		if ( !r )
			vPluginInfo.erase( vPluginInfo.begin() + i );
		else {
			// ̾ǧ
			if ( !CheckNameStr( vPluginInfo[i].PluginName ) ||
				 ( !vPluginInfo[i].IsSeparator && !CheckNameStr( vPluginInfo[i].FunctionName ) ) )
				vPluginInfo.erase( vPluginInfo.begin() + i );
		}
		--i;
	}
}

// ̾˻ѤƤʸǧ
// ʳ̾ˤA-Za-z0-9ڤ_Τ߻Ѳǽ
bool CPlugin::CheckNameStr( const string& r ) const
{
	const char *wp = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_";
	int i;

	if ( r.empty() ) return false;	// ̵̾Բ

	// ԲĤʸޤޤƤʤȤǧ
	for ( i = 0; i < r.length(); ++i )
		if ( strchr( wp, r[i] ) == NULL ) return false;
	return true;
}

// ˥塼ۤ
CErrorBool CPlugin::CreateMenu( Widget wgtCascade, Widget wgtPullDown )
{
	Arg al[3];
	int ac = 0;
	int i;
	const CCompoundStr *pMsg = NULL;
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();

	// Ѥ
	for ( i = 0; i < vPluginInfo.size(); ++i )
		vPluginInfo[i].wgtMenuBtn = NULL;

	// ƥץ饰󤴤ȡ˥塼ۤ
	for ( i = 0; i < vPluginInfo.size(); ++i ) {
		CCompoundStr wCStr;

		// ˥塼ΥƥȤ
		ac = 0;
		if ( !( vPluginInfo[i].MenuLabel.empty() ) ) {
			wCStr.SetStr( vPluginInfo[i].MenuLabel.c_str() );
			XtSetArg( al[ac], XmNlabelString, wCStr.GetStr() );
			ac++;
		}

		// å̾
		string wWgtName = string( "TEPI_") + vPluginInfo[i].PluginName;

		// åȤ
		if ( vPluginInfo[i].IsSeparator )
			vPluginInfo[i].wgtMenuBtn = XmCreateSeparator( wgtPullDown, const_cast< char* >( wWgtName.c_str() ), al, ac );
		else
			vPluginInfo[i].wgtMenuBtn = XmCreatePushButton( wgtPullDown, const_cast< char* >( wWgtName.c_str() ), al, ac );
		if ( NULL == vPluginInfo[i].wgtMenuBtn ) {
			pMsg = &( pConf->RefOutOfMemoryErrorMsg() );
			goto ERR_EXIT;
		}

		// ХåϿ
		if ( !vPluginInfo[i].IsSeparator )
			XtAddCallback( vPluginInfo[i].wgtMenuBtn, XmNactivateCallback, PluginMenuCallback, this );

		XtManageChild( vPluginInfo[i].wgtMenuBtn );
	}

	// ֥ġץ˥塼ͭˤ
	XtMapWidget( wgtCascade );

	return true;

ERR_EXIT:
	// ޤåȤ˴
	for ( i = 0; i < vPluginInfo.size(); ++i ) {
		if ( vPluginInfo[i].wgtMenuBtn )
			XtDestroyWidget( vPluginInfo[i].wgtMenuBtn );
	}
	// ץ饰ξ˴
	vPluginInfo.clear();
	vPluginInfo.swap( vector< PLUGIN_INFO >() );
	return CErrorBool( (*pMsg) );
}

// ˥塼줿ȤΥХå
void CPlugin::PluginMenuCallback( Widget wgt, XtPointer client_data, XtPointer call_data )
{
	CPlugin *p = reinterpret_cast< CPlugin* >( client_data );
	p->OnMenu( wgt );
}

// ˥塼򤵤줿Υ٥
void CPlugin::OnMenu( Widget wgt )
{
	int i;

	// 줿˥塼줫򸡺롣
	for ( i = 0; i < vPluginInfo.size() && wgt != vPluginInfo[i].wgtMenuBtn; i++ );
	if ( i >= vPluginInfo.size() ) {
		VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
		m_TaEditShell->ProcErrorMsg( pConf->RefUnexpectedErrorMsg() );
		return ;
	}

	// ץ饰ƤӽФ
	pCurPlugin = vPluginInfo.begin() + i;
	Modified = false;
	CallPlugin( pCurPlugin->LibraryName, pCurPlugin->FunctionName );
	pCurPlugin = NULL;

	// ץ饰μ¹Ԥˤѹ줿ϡƥԽλΤ
	if ( Modified ) {
		m_TaEditShell->GetDocument()->EndEdit();
	}
}

// ץ饰μ¹
////////////////////////////////////////////////////////////////////////////

// ץ饰δؿƤӽФ
void CPlugin::CallPlugin( const string &rLibraryName, const string &rFunctionName )
{
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	void* handle = NULL;
	void (*pFunc)( void* (*)( unsigned int ) ) = NULL;
	CCompoundStr CS;

	// 饤֥ɤ
	handle = dlopen( rLibraryName.c_str(), RTLD_LOCAL | RTLD_FIRST | LM_ID_LDSO );
	if ( NULL == handle ) {
		pConf->GetFaultLoadPluginLibraryMsg( &CS, rLibraryName, dlerror() );
		m_TaEditShell->ProcErrorMsg( CS );
		return ;
	}

	// ؿΥɥ쥹
	pFunc = reinterpret_cast< void(*)( void* (*)( unsigned int ) ) >( dlsym( handle, rFunctionName.c_str() ) );
	if ( NULL == pFunc ) {
		pConf->GetFaultGetPluginFunctionMsg( &CS, rLibraryName, rFunctionName, dlerror() );
		m_TaEditShell->ProcErrorMsg( CS );
		goto ERR_EXIT;
	}

	// ؿƤӽФ
	pFunc( GetFunctionAddress );

ERR_EXIT:
	if ( handle ) dlclose( handle );
}

// ץ饰εǽμ
////////////////////////////////////////////////////////////////////////////

// ֤μ
const T_CurPos& CPlugin::GetCurPos() const
{
	assert( NULL != this && NULL != pView );
	return pView->GetCursorInfo()->GetCurPos();
}

// ϰϤμ
const T_SelRange& CPlugin::GetSelRange() const
{
	assert( NULL != this && NULL != pView );
	return pView->GetCursorInfo()->GetSelRange();
}

// ֤ϰϤ
bool CPlugin::SetCurPos_SelRange( const T_CurPos &rCurPos, const T_SelRange& rSelRange )
{
	assert( NULL != this && NULL != pView );
	VClsPtr< CCursor > pCursor = pView->GetCursorInfo();
	ScrollInfoPacket scrPacket;
	T_CurPos vc[3] = { rCurPos, rSelRange.GetSPos(), rSelRange.GetEPos() };
	int i;

	// ǧ
	const CTaEditDoc *pDoc = m_TaEditShell->GetDocument();
	if ( NULL == pDoc ) return false;
	const T_LineData& rData = pDoc->RefData();

	for ( i = 0; i < 3; i++ ) {
		if ( vc[i].GetLine() < 0 || vc[i].GetLine() >= rData.size() )
			return false;
		if ( vc[i].GetCPos() < 0 || vc[i].GetCPos() > rData[ vc[i].GetLine() ].length() )
			return false;
	}

	// ֤
	pCursor->SetCurPos( rCurPos, &scrPacket, rSelRange );

	// 
	if ( scrPacket.NeedXScroll || scrPacket.NeedYScroll )
		pView->AfterEditRedraw( scrPacket );
	else
		pView->AfterSelRangeRedraw( scrPacket.ChangeSLine, scrPacket.ChangeELine );
	return true;
}

// ʸִ
bool CPlugin::Replace( const T_SelRange &rRange, const wchar_t *pStr )
{
	CTaEditDoc *pDoc = m_TaEditShell->GetDocument();
	T_CurPos NextPos;
	ScrollInfoPacket ScrPacket;
	bool r = true;

	// ꤵ줿ϰϤʸִ
	if ( !m_TaEditShell->ProcErrorMsg( pDoc->Insert( pStr, rRange.GetSPos(), rRange, &NextPos ) ) )
		r = false;

	// 
	pView->GetCursorInfo()->SetCurPos( NextPos, &ScrPacket, T_SelRange( NextPos, NextPos ) );

	// 
	pView->AfterEditRedraw( ScrPacket );

	// ƥȤѹ줿Ȥ򼨤
	Modified = true;

	return r;
}

// ߼¹Υץ饰
const wchar_t* CPlugin::GetCurPluginConfig( const wchar_t *pName ) const
{
	assert( NULL != this );
	// ɬפʾ󤬼ǤʤäNULL֤
	if ( NULL == pCurPlugin || NULL == pPluginConf ) return NULL;
	// 򸡺
	return exconf_GetConstStr( pPluginConf, pCurPlugin->SectionName.c_str(), pName );
}

// ĥꤹ
bool CPlugin::SetExtendInfo( unsigned long Line, int idx, bool flg )
{
	CTaEditDoc *pDoc = m_TaEditShell->GetDocument();
	ScrollInfoPacket ScrPacket;
	bool r = true;

	if ( !m_TaEditShell->ProcErrorMsg( pDoc->SetExtendInfo( Line, idx, flg ) ) )
		return false;

	// ϰϤѲʤ⤷ʤ
	ScrPacket.NeedXScroll = false;
	ScrPacket.NeedYScroll = false;
	ScrPacket.IsSelCange = false;
	pView->AfterEditRedraw( ScrPacket );

	return true;
}

// ߼¹ԤƤץ饰̤ID
const wchar_t* CPlugin::GetPluginID() const
{
	// ץ饰եΥ̾Ǽ̤
	if ( NULL == pCurPlugin ) return NULL;
	return pCurPlugin->SectionName.c_str();
}

// ѥ֥Ȥ
CWorkMemoryMgr& CPlugin::GetWorkMemoryMgr()
{
	return m_WorkMemoryMgr;
}

// ƥԽե饰򥯥ꥢ
void CPlugin::ClearModifiedFlg()
{
	// ե¸䥪ץԤäȤϡƥԽե饰򤪤ɬפ
	Modified = false;
}

