#include <wchar.h>
#include <stdlib.h>
#include <vector>
#include <widec.h>
#include "spf.h"

using namespace std;

// ƸĤбݻ
typedef struct tagBRACKET_PAIR {
	wchar_t Left;
	wchar_t Right;
} BRACKET_PAIR;

static vector< BRACKET_PAIR > CreateBracketPairVec( const wchar_t *p );
static void ExistBracketOnLeftSide( CSyuhituPlugin spf, const vector< BRACKET_PAIR > &rvBracket, int *pIdx, bool *pIsBra );
static void ExistBracketOnRightSide( CSyuhituPlugin spf, const vector< BRACKET_PAIR > &rvBracket, int *pIdx, bool *pIsBra );
static void SearchToLeft( CSyuhituPlugin spf, const BRACKET_PAIR &bp, bool IsCurLeft );
static void SearchToRight( CSyuhituPlugin spf, const BRACKET_PAIR &bp, bool IsCurLeft );

extern "C" void FindBracket( PFT_GetAPIFunction GetAPIFunction )
{
	CSyuhituPlugin spf( GetAPIFunction );
	vector< BRACKET_PAIR > vBracketPair;
	int idx;
	bool IsBra;

	try {
		// 
		const wchar_t *pPrioritySide = spf.GetConfigValue( L"PrioritySide" );
		const wchar_t *pBracketChar = spf.GetConfigValue( L"BracketChar" );

		if ( !pPrioritySide )
			pPrioritySide = L"Left";
		if ( !pBracketChar )
			pBracketChar = L"(){}[]<>";

		vBracketPair = CreateBracketPairVec( pBracketChar );

		// ζ᤯˳̤뤫ݤ
		if ( wscasecmp( pPrioritySide, L"Left" ) == 0 ) {
			ExistBracketOnLeftSide( spf, vBracketPair, &idx, &IsBra );
			if ( idx != -1 ) {
				if ( IsBra )
					SearchToRight( spf, vBracketPair[idx], true );
				else
					SearchToLeft( spf, vBracketPair[idx], true );
				return ;
			}
			ExistBracketOnRightSide( spf, vBracketPair, &idx, &IsBra );
			if ( idx != -1 ) {
				if ( IsBra )
					SearchToRight( spf, vBracketPair[idx], false );
				else
					SearchToLeft( spf, vBracketPair[idx], false );
				return ;
			}
		}
		else {
			ExistBracketOnRightSide( spf, vBracketPair, &idx, &IsBra );
			if ( idx != -1 ){
				if ( IsBra )
					SearchToRight( spf, vBracketPair[idx], false );
				else
					SearchToLeft( spf, vBracketPair[idx], false );
				return ;
			}
			ExistBracketOnLeftSide( spf, vBracketPair, &idx, &IsBra );
			if ( idx != -1 ) {
				if ( IsBra )
					SearchToRight( spf, vBracketPair[idx], true );
				else
					SearchToLeft( spf, vBracketPair[idx], true );
				return ;
			}
		}
	}
	catch ( CSP_Err e ) {
		printf( "ERROR\n" );
	};
}

// ƸĤбݻۤ
vector< BRACKET_PAIR > CreateBracketPairVec( const wchar_t *p )
{
	BRACKET_PAIR pair;
	bool flg;
	const wchar_t *wp;
	vector< BRACKET_PAIR > rv;

	flg = true;
	wp = p;
	while ( (*wp) ) {
		if ( flg ) {
			pair.Left = (*wp);
			flg = false;
		}
		else {
			pair.Right = (*wp);
			rv.push_back( pair );
			flg = true;
		}
		wp++;
	}	
	return rv;
}

// κ¦˳̤뤫ݤ
void ExistBracketOnLeftSide( CSyuhituPlugin spf, const vector< BRACKET_PAIR > &rvBracket, int *pIdx, bool *pIsBra )
{
	unsigned long LP, CP;
	int i;
	wchar_t wc;

	(*pIdx) = -1;

	// ΰ֤
	spf.GetCurPosition( &LP, &CP );

	// 뤬üˤϡ¦ˤϥ¸ߤʤ
	if ( CP == 0 ) return ;

	// κ¦ʸ
	wc = spf.GetChar( LP, CP - 1 );

	// ʸ뤫ݤȽǤ
	for ( i = 0; i < rvBracket.size(); i++ ) {
		if ( rvBracket[i].Left == wc ) {
			(*pIdx) = i;
			(*pIsBra) = true;
			return ;
		}
		if ( rvBracket[i].Right == wc ) {
			(*pIdx) = i;
			(*pIsBra) = false;
			return ;
		}
	}
}

// α¦˳̤뤫ݤ
void ExistBracketOnRightSide( CSyuhituPlugin spf, const vector< BRACKET_PAIR > &rvBracket, int *pIdx, bool *pIsBra )
{
	unsigned long LP, CP;
	unsigned long len;
	int i;
	wchar_t wc;

	(*pIdx) = -1;

	// ΰ֤
	spf.GetCurPosition( &LP, &CP );
	// 뤬Ԥʸ
	len = spf.GetCharCount( LP );

	// 뤬üˤϡ¦ˤϥ¸ߤʤ
	if ( CP >= len ) return ;

	// α¦ʤĤޤꥫΤ֡ˤʸ
	wc = spf.GetChar( LP, CP );

	// ʸ뤫ݤȽǤ
	for ( i = 0; i < rvBracket.size(); i++ ) {
		if ( rvBracket[i].Left == wc ) {
			(*pIdx) = i;
			(*pIsBra) = true;
			return ;
		}
		if ( rvBracket[i].Right == wc ) {
			(*pIdx) = i;
			(*pIsBra) = false;
			return ;
		}
	}
}

// ˰֤麸˸äƸ
// IsCurLeft : Ĥä̤ϡκ¦ˤΤݤ
void SearchToLeft( CSyuhituPlugin spf, const BRACKET_PAIR &bp, bool IsCurLeft )
{
	unsigned long CP, LP;
	int cnt;
	wchar_t wc;

	// ֤
	spf.GetCurPosition( &LP, &CP );
	if ( IsCurLeft ) {
		if ( CP == 0 ) {
			if ( LP == 0 ) return ;
			LP--;
			CP = spf.GetCharCount( LP ) - 1;
		}
		CP--;
	}

	cnt = 1;
	while( -1 ) {
		if ( CP == 0 ) {
			if ( LP == 0 ) return ;
			LP--;
			CP = spf.GetCharCount( LP ) - 1;
		}
		else
			CP--;
		// ʸ
		wc = spf.GetChar( LP, CP );
		if ( wc == bp.Left ) {
			cnt--;
			if ( cnt == 0 ) {
				// б̤Ĥä
				spf.SetCurPosition( LP, CP );
				return ;
			}
		}
		if ( wc == bp.Right )
			cnt++;
	};
}

// α¦˸äƸ
void SearchToRight( CSyuhituPlugin spf, const BRACKET_PAIR &bp, bool IsCurLeft )
{
	unsigned long CP, LP;
	int cnt;
	unsigned long len;
	unsigned long LineCnt;
	wchar_t wc;

	// ֤
	spf.GetCurPosition( &LP, &CP );

	// ʸ
	len = spf.GetCharCount( LP );

	// Կ
	LineCnt = spf.GetLineCount();

	if ( !IsCurLeft ) {
		if ( CP == len - 1 ) {
			if ( LP == LineCnt - 1 ) return ;
			LP++;
			CP = 0;
			len = spf.GetCharCount( LP );
		}
		else
			CP++;
	}

	cnt = 1;
	while( -1 ) {
		if ( CP == len - 1 ) {
			if ( LP == LineCnt - 1 ) return ;
			LP++;
			CP = 0;
			len = spf.GetCharCount( LP );
		}
		else
			CP++;
		// ʸ
		wc = spf.GetChar( LP, CP );
		if ( wc == bp.Right ) {
			cnt--;
			if ( cnt == 0 ) {
				// б̤Ĥä
				spf.SetCurPosition( LP, CP );
				return ;
			}
		}
		if ( wc == bp.Left )
			cnt++;
	}
}

