////////////////////////////////////////////////////////////////////////////
// CTaEditShell 饹Υ󥿥ե
//
////////////////////////////////////////////////////////////////////////////

#if !defined( TAEDITSHELL_H_INCLUDED_ )
#define TAEDITSHELL_H_INCLUDED_

#include <Xm/XmAll.h>

#include "TaEdit_std.h"

#include "output/gui.h"
#include "TaEditDoc.h"
#include "TaEditFileSelDlg.h"
#include "TaEditFindDlg.h"
#include "ConfigInfo.h"
#include "TextEdit.h"
#include "CmdOption.h"
#include "lang/LangConfig.h"
#include "Plugin.h"
#include "MsgBox.h"
#include "CompoundStr.h"

class CConsruction;

class CTaEditShell :
	public CAppShell
{
public:
	CTaEditShell();
	~CTaEditShell();

	// ۤȤƤФ
	void create (Display *display, char *app_name, int app_argc, char **app_argv, char *app_class_name = NULL);

	// 
	void OnCreate( Widget argWgt, XtPointer client_data );

	// Ʋ̤ɽȤƤФ
	void OnFirstExpose();

	// ˥塼Υ٥
	void OnWriteFile( Widget argWgt, XtPointer client_data );	// ̾դ¸
	void OnSaveFile( Widget argWgt, XtPointer client_data );	// ¸
	void OnOpenFile( Widget argWgt, XtPointer client_data );	// 
	void OnNewFile( Widget argWgt, XtPointer client_data );		// 
	void SetFileTypeTXT( Widget argWgt, XtPointer client_data );	// Text⡼ɤѹ
	void SetFileTypeCPP( Widget argWgt, XtPointer client_data );	// C/C++⡼ɤѹ
	void SetFileTypeJAVA( Widget argWgt, XtPointer client_data );	// Java⡼ɤѹ
	void SetFileTypeCBL( Widget argWgt, XtPointer client_data );	// COBOL⡼ɤѹ
	void SetFileTypeVBS( Widget argWgt, XtPointer client_data );	// VBScript⡼ɤѹ
	void SetFileTypeJS( Widget argWgt, XtPointer client_data );	// JavaScript⡼ɤѹ
	void SetFileTypeCS( Widget argWgt, XtPointer client_data );	// C#⡼ɤѹ
	void OnConstruction( Widget argWgt, XtPointer client_data );	// 󥹥ȥ饯⡼ɤѹ
	void OnStandalone( Widget argWgt, XtPointer client_data );		// ɥ⡼ɤѹ
	void OnCloseAppMenu( Widget argWgt, XtPointer client_data );	// λ

	void OnEditMenuShow( Widget argWgt, XtPointer client_data );	// Խ˥塼ɽ
	void OnEditRedo( Widget argWgt, XtPointer client_data );	// ɥ˥塼
	void OnEditUndo( Widget argWgt, XtPointer client_data );	// ɥ˥塼
	void OnEditCut( Widget argWgt, XtPointer client_data );		// ڤ˥塼
	void OnEditCopy( Widget argWgt, XtPointer client_data );	// ԡ˥塼
	void OnEditPaste( Widget argWgt, XtPointer client_data );	// ĥդ˥塼
	void OnEditFullSelect( Widget argWgt, XtPointer client_data );	// ˥塼
	void OnEditFind( Widget argWgt, XtPointer client_data );	// ִ˥塼
	void OnEditMoveto( Widget argWgt, XtPointer client_data );	// Ԥذư

	// ɥĤ
	void OnClose( Widget argWgt, XtPointer client_data );

	// åܥåɽ
	void ShowInformationMsgBox( const CCompoundStr &rStr ) const;
	int ShowQuestionMsgBox( const CCompoundStr &rStr, bool ShowCancel ) const;
	void ShowErrorMsgBox( const CCompoundStr &rStr ) const;

	// ɥȥ֥Ȥλ
	CTaEditDoc *GetDocument();

	// 󥪥֥Ȥλ
	VClsPtr< CConfigInfo > GetConfigInfo();

	// ޥɹԥץ󥪥֥Ȥλ
	const CCmdOption& GetCmdOption() const;

	// Խ֥Ȥ
	VClsPtr< CTextEdit > GetTextEditor();

	// ꤷե򳫤
	bool OpenFile( const string &rFileName, enumLANGTYPE LangType = LANGTYPE_NAN, const string &rEncodeName = "" );

	// եξ¸ν
	bool SaveFileProcedure();

	// ե̾դ¸
	bool WriteFileProcedure();

	// ե̾ꤷƥե¸
	bool WriteFile( const string &rFileName, const CEncodeInfo &rEncodeInfo );

	// ԡڤ˥塼̵ͭꤹ
	void SetEnableCopyPasteMenu( bool flg ) const;

	// Undo˥塼̵ͭꤹ
	void SetEnableUndoMenu( bool flg ) const;

	// Redo˥塼̵ͭꤹ
	void SetEnableRedoMenu( bool flg ) const;

	// ԡڤ˥塼̵ͭ
	bool GetEnableCopyPasteMenu() const;

	// Undo˥塼̵ͭ
	bool GetEnableUndoMenu() const;

	// Redo˥塼̵ͭ
	bool GetEnableRedoMenu() const;

	// ɬפ˱ƥ顼åɽ
	bool ProcErrorMsg( CErrorBool r ) const;

	// ̾󥪥֥Ȥ
	const NLangExt::CLangConfig* GetLangConfig() const;

	// ץ饰֥Ȥ򻲾
	CPlugin& RefPluginMgr();

	// ɥåɥɥåפ줿ե򳫤
	void OpenDnDFiles( int cnt, char **pFileName );

	// ɥǥե򳫤
	bool OpenFileInNewWindow( const string &rfile, int Line, const string &rEncode, const string &LangType );

	// ɥ˥եꤹ
	void RaiseWindow() const
	{
		Display *pDisplay = XtDisplay( m_TaEditShell );
		Window window = XtWindow( m_TaEditShell );
		XMapWindow( pDisplay, window );
		XmUpdateDisplay( m_TaEditShell );
		XSetInputFocus( pDisplay, window, RevertToParent, CurrentTime );
	}

	// ѥޤٱ䤵
	void DelayCursorTimer();

	// ȥꤷľ
	void ResetTitle() const;

	// ꤷֹذư
	void MoveTo( int Line );

	// 󥹥ȥ饯󡦥⡼ɤݤ
	bool IsConstructionMode() const;

	// ɥ󡦥⡼ɤˤ
	CErrorBool SetStandaloneMode();

	// 󥹥ȥ饯󡦥⡼ɤˤ
	CErrorBool SetConstructionMode();

private:
	// ޥ٥ȤΥȥѴؿ
	static void OnTimer( XtPointer client_data, XtIntervalId *timer );

	// ޥ٥
	void OnTimer();

	// ư¸ѤΥޤΥȥ
	static void OnAutoSaveTimer( XtPointer client_data, XtIntervalId *timer );

	// ư¸ѤΥޥ٥
	void OnAutoSaveTimer();

protected:

	// ɥΥȥ
	void SetWindowTitle( const string &Title ) const;

	// եΥѥ̾ե̾Τߤ
	string GetFileNameFromFullPathName( const string& FullPathName ) const;

	// ե¸ɬפ뤫ݤǧ
	bool MakeSure_FileSave();

	// եɤ߹ߡ񤭹ߤλΥޥɤ¹
	bool RunFileReadScript( const string& rFileName, const CEncodeInfo &rEncodeInfo ) const;
	bool RunFileAfterReadScript( const string& rFileName, const CEncodeInfo &rEncodeInfo ) const;
	bool RunFileCloseScript() const;
	bool RunFileBeforeWriteScript( const string& NewFileName, const CEncodeInfo &rNewEncodeInfo ) const;
	bool RunFileWriteScript( const string& OldFileName, const CEncodeInfo &rOldEncodeInfo ) const;

	// ץλ
	void ExitProcess( int r );

	// 󥹥ȥ饯󡿥ɥ⡼ɤΥ˥塼ꤹ
	void SetCSModeMenu() const;

protected:
	// ɥȥ֥
	CTaEditDoc theDocument;

	// åܥå֥
	CMsgBox MsgBoxMgr;

	// 
	VClsPtr< CConfigInfo > pConfigInfo;

	// ޥɤΥץ
	CCmdOption m_CmdOption;

	// ̤ξ󥪥֥
	NLangExt::CLangConfig *pLangConfig;

	// ץ饰֥
	CPlugin m_Plugin;

	// ѥԥåޥå
	Pixmap IconPixmap;

	// ѥޡID
	XtIntervalId CursorTimerID;

	// ֥̿
	CConsruction *pConstruction;
};

#endif // TAEDITSHELL_H_INCLUDED_

