////////////////////////////////////////////////////////////////////////////
// CurPos.h CCurPos饹Υץơ
// ΰ֤Ԥݻ
////////////////////////////////////////////////////////////////////////////

#if !defined( CURPOS_H_INCLUDED_ )
#define CURPOS_H_INCLUDED_

template < typename T_ >
class CCurPos
{
public:
	CCurPos() : line( 0 ), cpos( 0 ){};
	CCurPos( T_ argLine ) : line( argLine ), cpos( 0 ){};
	CCurPos( const CCurPos &r ) : line( r.line ), cpos( r.cpos ){};
	CCurPos( T_ argLine, T_ argCPos ) : line( argLine ), cpos( argCPos ){};

	// 
	const CCurPos& operator =( const CCurPos &r ) {
		line = r.line;
		cpos = r.cpos;
		return (*this);
	};
	void SetLine( T_ argLine ) {
		line = argLine;
	};
	void SetCPos( T_ argCPos ) {
		cpos = argCPos;
	};

	// 黻
	void IncrLine() {
		line++;
	};
	void DecrLine() {
		line--;
	};
	void IncrCPos() {
		cpos++;
	};
	void DecrCPos() {
		cpos--;
	};
	CCurPos operator +( const CCurPos &r ) const {
		return CCurPos( line + r.line, cpos + r.cpos );
	};
	const CCurPos& operator +=( const CCurPos &r ) {
		(*this) = (*this) + r;
		return (*this);
	};
	CCurPos operator -( const CCurPos &r ) const {
		return CCurPos( line - r.line, cpos - r.cpos );
	};
	const CCurPos& operator -=( const CCurPos &r ) {
		(*this) = (*this) - r;
		return (*this);
	};

	// 
	bool operator ==( const CCurPos &r ) const {
		return line == r.line && cpos == r.cpos;
	};
	bool operator <( const CCurPos &r ) const {
		return ( line == r.line && cpos < r.cpos ) || line < r.line;
	};
	bool operator >( const CCurPos &r ) const {
		return r.operator <( (*this ) );
	};
	bool operator !=( const CCurPos &r ) const {
		return !( operator ==( r ) );
	};
	bool operator >=( const CCurPos &r ) const {
		return !( operator <( r ) );
	};
	bool operator <=( const CCurPos &r ) const {
		return !( operator >( r ) );
	};

	// ͤλ
	T_ GetLine() const {
		return line;
	};
	T_ GetCPos() const {
		return cpos;
	};
protected:
	T_ line;
	T_ cpos;
};

#endif // CURPOS_H_INCLUDED_
