////////////////////////////////////////////////////////////////////////////
// CCmdOption 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include "lang/LangConfig.h"
#include "CmdOption.h"

////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CCmdOption::CCmdOption() :
	IsEnableFileNameFlg( false ),
	IsEnableInitLineFlg( false ),
	IsEnableLangTypeFlg( false ),
	InitLine( 0 ),
	LangType( LANGTYPE_NAN ),
	IsConstructionModeFlg( false ),
	Arg0( "" )
{

}

CCmdOption::~CCmdOption()
{

}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// ץꤹ
void CCmdOption::SetOption( int argc, char *argv[] )
{
	// ޥɥ饤Υץ᤹
	// ʤλǤϡXtʤɤѤץ̵ʤäƤ

	const char *wp;
	int i, j, len;
	const char *pErrMsg = "It failed to resolve path name of process.";
	char buf[ PATH_MAX + 1 ];	// ưΥޥɤ뤿ΥХåե

	// ޥɤ˻ꤵ륹å
	const char *pOptStr[] = {
		"/file:",
		"/line:",
		"/syntax:",
		"/standalone",
		"/construction",
		"/encode:"
	};

	// åο
	const int OptStrCnt = sizeof( pOptStr ) / sizeof( pOptStr[0] );

	// ƥåꤵ줿ݤ
	bool wStandaloneFlg = false;
	bool wConstructionFlg = false;
	bool *pEnableFlg[] = {
		&IsEnableFileNameFlg,
		&IsEnableInitLineFlg,
		&IsEnableLangTypeFlg,
		&wStandaloneFlg,
		&wConstructionFlg,
		&IsEnableEncodeNameFlg
	};

	if ( argc < 0 ) {
		fprintf( stderr, pErrMsg );
		Arg0 = "";
		return ;
	}

	// argv[0]ΰ򤹤
	if ( realpath( argv[0], buf ) == NULL ) {
		fprintf( stderr, pErrMsg );
		Arg0 = argv[0];
	}
	else {
		buf[ PATH_MAX ] = '\0';
		Arg0 = buf;
	}

	// ư缡
	for ( i = 1; i < argc; i++ ) {
		string curarg = GlbFunc::Trim( argv[i], " \t", "" );

		// ѲǽʥåȾȹ礹
		for ( j = 0; j < OptStrCnt; j++ ) {
			len = strlen( pOptStr[j] );
			// Ѳǽʥå˳뤫ݤ
			if ( !strncasecmp( pOptStr[j], curarg.c_str(), len ) )
				break;
		}

		if ( j >= OptStrCnt ) continue;	// ǧǤʤå

		// å̾θͭͤꤵƤ뤫ݤ
		if ( curarg.length() <= len )
			wp = NULL;
		else
			wp = argv[i] + len;

		// ΥåͭǤ뤳Ȥ򼨤ե饰ꤹ
		*(pEnableFlg[j]) = true;

		// ƥå̤ͤ
		switch ( j ) {
		case 0:	// ե̾
			if ( wp )
				FileName = wp;
			else
				FileName = "";
			break;
		case 1:	// ֹ
			if ( wp )
				InitLine = atoi( wp );
			else
				InitLine = 1;
			break;
		case 2:	// ʸĴɽμ
			if ( wp )
				LangType = NLangExt::GetLangTypeID_ByLangName( wp );
			else
				LangType = LANGTYPE_TEXT;
			break;
		case 3:
			// ɥ⡼
			// 󥹥ȥ饯⡼ɤλ̵
			IsConstructionModeFlg = false;
			break;
		case 4:
			// 󥹥ȥ饯⡼
			// /standaloneꤵƤ硢/construction̵뤹
			if ( !wStandaloneFlg ) IsConstructionModeFlg = true;
			break;
		case 5:
			// 󥳡̾
			if ( wp )
				EncodeName = wp;
			else
				EncodeName = "";
		}
	}
}

// ե̾ץͭݤ
bool CCmdOption::IsEnableFileName() const
{
	return IsEnableFileNameFlg;
}

// ե̾ץ
const string& CCmdOption::GetFileName() const
{
	return FileName;
}

// ֹ楪ץͭݤ
bool CCmdOption::IsEnableInitLine() const
{
	return IsEnableInitLineFlg;
}

// ֹ楪ץͤ
int CCmdOption::GetInitLine() const
{
	return InitLine;
}

// ʸĴɽμ̤꤬ͭݤ
bool CCmdOption::IsEnableLangType() const
{
	return IsEnableLangTypeFlg;
}

//  ʸĴɽμ̤Υץ
enumLANGTYPE CCmdOption::GetLangType() const
{
	if ( IsEnableLangType() )
		return LangType;
	else
		return LANGTYPE_NAN;
}

// argv[0]ͤ򻲾
const string& CCmdOption::GetArg0() const
{
	return Arg0;
}

// Ф³뤫ݤ
bool CCmdOption::IsConstructionMode() const
{
	return IsConstructionModeFlg;
}

// 󥳡̾λ꤬ͭݤ
bool CCmdOption::IsEnableEncodeName() const
{
	return IsEnableEncodeNameFlg;
}

// 󥳡̾
const string& CCmdOption::GetEncodeName() const
{
	return EncodeName;
}

