////////////////////////////////////////////////////////////////////////////
// CSyInstance 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include <assert.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <string>


#include "CommandID.h"
#include "SyInstance.h"
#include "ProcStart.h"
#include "NegCmd.h"
#include "FD.h"
#include "VPtr.h"

using namespace NNabikiVPtr;

////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CSyInstance::CSyInstance() :
	pErrorMsg( NULL )
{

}

CSyInstance::~CSyInstance()
{

}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// 
bool CSyInstance::Initialize()
{
	const char *p = getenv( SCEV_COMMUNITY_PATH );

	if ( NULL == p ) {
		fprintf( stderr, "ERROR Syuhitu server : %s environment valuable is empty.\n", SCEV_COMMUNITY_PATH );
		return false;
	}
	CommunityPath = p;

	listInstance.clear();

	return true;
}

// ¸μɮξ
void CSyInstance::UpdateExistTaEditInfo()
{
	list< TAEDIT_INFO > wList;

	if ( !SearchExistTaEditInfo( &wList ) )
		fprintf( stderr, "ERROR Syuhitu server : It failed to update exist Syuhitu information.\n" );
	else
		listInstance = wList;
}

// ¸μɮξ
bool CSyInstance::SearchExistTaEditInfo( list< TAEDIT_INFO > *pList )
{
	DIR *pDir;
	struct dirent *pEnt;
	const char *p;
	string DirName;
	int suflen;
	string fname;

	assert( pList );

	// ̾դѥפǼǥ쥯ȥ
	p = getenv( SCEV_COMMUNITY_PATH );
	if ( !p ) return false;

	DirName = p;
	if ( DirName.length() <= 0 ) DirName = ".";
	if ( DirName[ DirName.length() - 1 ] == '/' )
		DirName = DirName.substr( 0, DirName.length() - 1 );

    // ǥ쥯ȥ򳫤
	pDir = opendir( DirName.c_str() );
	if ( NULL == pDir ) return false;

	suflen = strlen( SCPX_TO_SYUHITU );
	while ( -1 ) {
		// Υե򸡺
		pEnt = readdir( pDir );
		if ( !pEnt ) break;

		string subname = pEnt->d_name;

		// ɮإǡ뤿Υѥפݤ
		if ( strncmp( pEnt->d_name, SCPX_TO_SYUHITU, suflen ) ) continue;

		// ե̾pid
		int pid = atoi( subname.c_str() + suflen );

		// ե̾䤤碌	
		if ( RequestFileName_ToTaEdit( pid, &fname ) ) {
			// ꥹȤɲä
			TAEDIT_INFO wInfo( fname, pid );
			pList->push_back( wInfo );
			// ФƵư줿ȤΤ
			NoticeServerReboot_ToTaEdit( pid );
		}
	}

	// ϥɥĤ
	closedir( pDir );

	return true;
}

// ե򳫤ʼɮεưʤƥֲ
void CSyInstance::OpenFile_CS( const CNegCmd &rCmd, CNegCmd *pToClient )
{
	list< TAEDIT_INFO >::iterator itr;

	assert( this );
	pToClient->AddData( SCI_R_STOPPED, SCID_RSTOP_RESUME );

	// ե̾
	const string &FileName = rCmd.GetData( SCI_S_FILE_NAME, string( "" ) );

	// ꤵ줿ե򳫤Ƥּɮפ̵ͭǧ
	if ( !FileName.empty() ) {
		itr = listInstance.begin();
		for (; itr != listInstance.end() && itr->FileName != FileName; itr++ );
	}
	else
		itr = listInstance.end();

	if ( itr == listInstance.end() ) {
		// Υե򳫤Ƥʪʤäϡư
		if ( StartSyuhitu( FileName, rCmd ) >= 0 )
			pToClient->AddData( SCI_R_STATUS, SCID_RSTAT_OK );
		else {
			pToClient->AddData( SCI_R_STATUS, SCID_RSTAT_ERR );
			pToClient->AddData( SCI_R_FREE_MSG, "It failed to start Syuhitu." );
		}
	}
	else {
		// ꤵ줿ե򳫤ƤΤ򥢥ƥ֤ˤ
		if ( ActivateSyuhitu( itr->pid, rCmd ) )
			pToClient->AddData( SCI_R_STATUS, SCID_RSTAT_OK );
		else {
			pToClient->AddData( SCI_R_STATUS, SCID_RSTAT_ERR );
			pToClient->AddData( SCI_R_FREE_MSG, "It failed to avtivate syuhitu." );
		}
	}
}

// ɮ¦ǥե뤬
// ݤȽǤƱ롣ݻƤե̾ѹϹԤʤ
void CSyInstance::OpenFile_TS( const CNegCmd &rCmd, CNegCmd *pToClient )
{
	list< TAEDIT_INFO >::iterator itr1, itr2;
	int pid;

	// ե̾ȥץID
	const string &FileName = rCmd.GetData( SCI_S_FILE_NAME, string( "" ) );
	pid = rCmd.GetData( SCI_S_PID, -1 );
	if ( FileName.empty() || pid < 0 ) {
		pToClient->AddData( SCI_R_STATUS, SCID_RSTAT_ERR );
		pToClient->AddData( SCI_R_STOPPED, SCID_RSTOP_STOP );
		pToClient->AddData( SCI_R_MSG_NUMBER, SCID_RMSG_CMDDATA_INSUFFICIENCY );
		return ;
	}

	// ƤӽФץξ򸡺
	itr1 = listInstance.begin();
	for (; itr1 != listInstance.end() && itr1->pid != pid; itr1++ );
	if ( itr1 == listInstance.end() ) {
		pToClient->AddData( SCI_R_STATUS, SCID_RSTAT_ERR );
		pToClient->AddData( SCI_R_STOPPED, SCID_RSTOP_STOP );
		pToClient->AddData( SCI_R_MSG_NUMBER, SCID_RMSG_CMDDATA_INSUFFICIENCY );
		return ;
	}

	// ꤵ줿ե򳫤Ƥּɮפ̵ͭǧ
	if ( !FileName.empty() ) {
		itr2 = listInstance.begin();
		for (; itr2 != listInstance.end() && itr2->FileName != FileName; itr2++ );
	}
	else
		itr2 = listInstance.end();

	if ( itr2 == listInstance.end() ) {
		// Υե򳫤ƤۤʤСƤӽФ˳
		pToClient->AddData( SCI_R_STATUS, SCID_RSTAT_OK );
		pToClient->AddData( SCI_R_STOPPED, SCID_RSTOP_RESUME );
	}
	else {
		if ( itr2->pid == pid ) {
			// ƤӽФƤեٳϡ
			// äˤ뤳ȤϤʤ
			pToClient->AddData( SCI_R_STATUS, SCID_RSTAT_OK );
			// ʤƤӽФμɮˤϺɹԤ碌
			pToClient->AddData( SCI_R_STOPPED, SCID_RSTOP_RESUME );
		}
		else {
			// ʥƥֲԤ˴ؤ餺ƤӽФ¦ǥե򳫤ʤ
			pToClient->AddData( SCI_R_STOPPED, SCID_RSTOP_STOP );

			// ꤵ줿ե򳫤Ƥɮ򥢥ƥ֤ˤ
			if ( !ActivateSyuhitu( itr2->pid, rCmd ) ) {
				pToClient->AddData( SCI_R_STATUS, SCID_RSTAT_ERR );
				pToClient->AddData( SCI_R_FREE_MSG, "It failed to activate Syuhitu." );
			}
			else {
				pToClient->AddData( SCI_R_STATUS, SCID_RSTAT_OK );
			}
		}
	}
}

// ɮ¦ǥե̾դ¸Ԥ
// ݤȽǤƱ롣ݻƤե̾ѹϹԤʤ
void CSyInstance::WriteFile_TS( const CNegCmd &rCmd, CNegCmd *pToClient )
{
	list< TAEDIT_INFO >::iterator itr2;
	int pid;

	// ե̾ȥץID
	const string &FileName = rCmd.GetData( SCI_S_FILE_NAME, string( "" ) );
	pid = rCmd.GetData( SCI_S_PID, -1 );
	if ( FileName.empty() || pid < 0 ) {
		pToClient->AddData( SCI_R_STATUS, SCID_RSTAT_ERR );
		pToClient->AddData( SCI_R_STOPPED, SCID_RSTOP_STOP );
		pToClient->AddData( SCI_R_MSG_NUMBER, SCID_RMSG_CMDDATA_INSUFFICIENCY );
		return ;
	}

	// ꤵ줿ե򳫤Ƥץ򸡺
	itr2 = listInstance.begin();
	for (; itr2 != listInstance.end() && itr2->FileName != FileName; itr2++ );

	if ( itr2 == listInstance.end() ) {
		// ꤵ줿ե򳫤ƤۤϤʤ
		pToClient->AddData( SCI_R_STATUS, SCID_RSTAT_OK );
		pToClient->AddData( SCI_R_STOPPED, SCID_RSTOP_RESUME );
	}
	else {
		if ( itr2->pid != pid ) {
			// ꤵ줿եϡ¾μɮˤäƳƤ
			pToClient->AddData( SCI_R_STATUS, SCID_RSTAT_OK );
			pToClient->AddData( SCI_R_STOPPED, SCID_RSTOP_STOP );
			pToClient->AddData( SCI_R_MSG_NUMBER, SCID_RMSG_FILEISOPEND );
		}
		else {
			// ɤν¸
			pToClient->AddData( SCI_R_STATUS, SCID_RSTAT_OK );
			pToClient->AddData( SCI_R_STOPPED, SCID_RSTOP_RESUME );
		}
	}
}

// ɮ¦ǳƤե̾ѹ
void CSyInstance::ChangeFileName_TS( const CNegCmd &rCmd, CNegCmd *pToClient )
{
	list< TAEDIT_INFO >::iterator itr;
	int pid;

	// ե̾ȥץID
	const string &FileName = rCmd.GetData( SCI_S_FILE_NAME, string( "" ) );
	pid = rCmd.GetData( SCI_S_PID, -1 );
	if ( pid < 0 ) {
		pToClient->AddData( SCI_R_STATUS, SCID_RSTAT_ERR );
		pToClient->AddData( SCI_R_STOPPED, SCID_RSTOP_STOP );
		pToClient->AddData( SCI_R_MSG_NUMBER, SCID_RMSG_CMDDATA_INSUFFICIENCY );
		return ;
	}

	// ƤӽФץ򸡺
	for ( itr = listInstance.begin(); itr != listInstance.end() && itr->pid != pid; itr++ );

	// ƤӽФץξ򹹿
	if ( itr != listInstance.end() )
		itr->FileName = FileName;
	else
		// 󤬤ʤäϡȤꤢɲäƤ
		listInstance.push_back( TAEDIT_INFO( FileName, pid ) );

	pToClient->AddData( SCI_R_STATUS, SCID_RSTAT_OK );
	pToClient->AddData( SCI_R_STOPPED, SCID_RSTOP_RESUME );
}

// ɮ¦λ
void CSyInstance::Exit_TS( const CNegCmd &rCmd, CNegCmd *pToClient )
{
	list< TAEDIT_INFO >::iterator itr;
	int pid;

	// λΤ顢ǤƤʤ
	pToClient->AddData( SCI_R_STATUS, SCID_RSTAT_OK );
	pToClient->AddData( SCI_R_STOPPED, SCID_RSTOP_RESUME );

	// pid
	pid = rCmd.GetData( SCI_S_PID, -1 );
	if ( pid < -1 ) {
		// 顼֤Ƥ
		pToClient->AddData( SCI_R_STATUS, SCID_RSTAT_ERR );
		pToClient->AddData( SCI_R_MSG_NUMBER, SCID_RMSG_CMDDATA_INSUFFICIENCY );
		return ;
	}

	// 󥹥󥹤򸡺
	itr = listInstance.begin();
	for (; itr != listInstance.end() && itr->pid != pid; itr++ );

	// map
	if ( itr != listInstance.end() )
		listInstance.erase( itr );
}

// Фߤ뤳Ȥǽݤ
bool CSyInstance::CanBeStopServer() const
{
	// ưμɮ¸ߤʤСߤ뤳ȤǤ
	return listInstance.empty();
}

// Фߤ
void CSyInstance::StopServerByForce_CS()
{
	CNegCmd send_cmd;
	CNegCmd resp_cmd;
	list< TAEDIT_INFO >::iterator itr;

	// ޥɤ
	send_cmd.AddData( SCI_S_COMMAND, SCID_CMD_SET_STANDALONE_ST );

	// Ƥμɮˡɥ⡼ɤˤ褦ؼФ
	for ( itr = listInstance.begin(); itr != listInstance.end(); itr++ ) {
		// ޥɤ
		// 顼ȯƤ⶯Ԥ
		SendCmdToTaEdit( send_cmd, itr->pid, &resp_cmd );
	}
}

// ɮǥե򳫤
void CSyInstance::OpenFileNW_TS( const CNegCmd &rCmd, CNegCmd *pToClient )
{
	list< TAEDIT_INFO >::iterator itr1, itr2;

	assert( this );
	pToClient->AddData( SCI_R_STOPPED, SCID_RSTOP_STOP );

	// ե̾ȥץID
	const string &FileName = rCmd.GetData( SCI_S_FILE_NAME, string( "" ) );
	int pid = rCmd.GetData( SCI_S_PID, -1 );
	if ( pid < 0 ) {
		pToClient->AddData( SCI_R_STATUS, SCID_RSTAT_ERR );
		pToClient->AddData( SCI_R_MSG_NUMBER, SCID_RMSG_CMDDATA_INSUFFICIENCY );
		return ;
	}

	// ƤӽФץξ򸡺
	itr1 = listInstance.begin();
	for (; itr1 != listInstance.end() && itr1->pid != pid; itr1++ );
	if ( itr1 == listInstance.end() ) {
		// ƤӽФץξ󤬸Ĥʤ
		pToClient->AddData( SCI_R_STATUS, SCID_RSTAT_ERR );
		pToClient->AddData( SCI_R_MSG_NUMBER, SCID_RMSG_UNEXPENTED );
		return ;
	}

	// ꤵ줿ե򳫤Ƥּɮפ̵ͭǧ
	if ( !FileName.empty() ) {
		itr2 = listInstance.begin();
		for (; itr2 != listInstance.end() && itr2->FileName != FileName; itr2++ );
	}
	else
		itr2 = listInstance.end();

	if ( itr2 != listInstance.end() ) {
		if ( itr1->pid != itr2->pid ) {
			// ꤵ줿ե򳫤Ƥɮ򥢥ƥ֤ˤ
			if ( ActivateSyuhitu( itr2->pid, rCmd ) )
				pToClient->AddData( SCI_R_STATUS, SCID_RSTAT_OK );
			else {
				pToClient->AddData( SCI_R_STATUS, SCID_RSTAT_ERR );
				pToClient->AddData( SCI_R_FREE_MSG, "It failed to avtivate syuhitu." );
			}
		}
		else
			// ƤӽФƤ뤫顢⤹ɬפʤ
			pToClient->AddData( SCI_R_STATUS, SCID_RSTAT_OK );
	}
	else {
		// ɮ򿷤ư
		if ( StartSyuhitu( FileName, rCmd ) >= 0 )
			pToClient->AddData( SCI_R_STATUS, SCID_RSTAT_OK );
		else {
			pToClient->AddData( SCI_R_STATUS, SCID_RSTAT_ERR );
			pToClient->AddData( SCI_R_FREE_MSG, "It failed to start Syuhitu." );
		}
	}
}


void CSyInstance::Join_TS( const CNegCmd &rCmd, CNegCmd *pToClient )
{
	list< TAEDIT_INFO >::iterator itr;

	assert( this );
	pToClient->AddData( SCI_R_STOPPED, SCID_RSTOP_RESUME );

	// ե̾ȥץID
	const string &FileName = rCmd.GetData( SCI_S_FILE_NAME, string( "" ) );
	int pid = rCmd.GetData( SCI_S_PID, -1 );
	if ( pid < 0 ) {
		pToClient->AddData( SCI_R_STATUS, SCID_RSTAT_ERR );
		pToClient->AddData( SCI_R_MSG_NUMBER, SCID_RMSG_CMDDATA_INSUFFICIENCY );
		return ;
	}

	// ƤӽФץ򸡺
	itr = listInstance.begin();
	for (; itr != listInstance.end() && itr->pid != pid; itr++ );

	// ƤӽФξ󤬤ǤϿƤϡξ򹹿ƽλ
	if ( itr != listInstance.end() ) {
		itr->FileName = FileName;
		pToClient->AddData( SCI_R_STATUS, SCID_RSTAT_OK );
		return ;
	}

	// ꤵ줿ե򳫤Ƥɮ򸡺
	if ( !FileName.empty() ) {
		itr = listInstance.begin();
		for (; itr != listInstance.end() && itr->FileName != FileName; itr++ );
	}
	else
		itr = listInstance.end();

	if ( itr == listInstance.end() ) {
		// եνʣʤСɲäƽλ
		listInstance.push_back( TAEDIT_INFO( FileName, pid ) );
		pToClient->AddData( SCI_R_STATUS, SCID_RSTAT_OK );
		return ;
	}

	// Ʊե򳫤Ƥۤ뤿ᡢä䤹
	pToClient->AddData( SCI_R_STATUS, SCID_RSTAT_ERR );
	pToClient->AddData( SCI_R_MSG_NUMBER, SCID_RMSG_FILEISOPEND );
}

// ƤեΡե̾׵ᤵ줿
void CSyInstance::RequestFNameLine_CS( const CNegCmd &rCmd, CNegCmd *pToClient )
{
	list< TAEDIT_INFO >::iterator itr;
	char Buf[10];
	string rstr = "";

	// pidȥե̾ʸȤϢ뤹
	for ( itr = listInstance.begin(); itr != listInstance.end(); itr++ ) {
		snprintf( Buf, 10, "%d", itr->pid );
		rstr += Buf;;
		rstr += '\0';
		rstr += itr->FileName;
		rstr += '\0';
	}
	pToClient->AddData( SCI_R_STATUS, SCID_RSTAT_OK );
	pToClient->AddData( SCI_S_OTHER, rstr );
}

// ꤵ줿ɮ򡢥󥹥ȥ饯⡼ɤڤΥ
void CSyInstance::Unjoin_CS( const CNegCmd &rCmd, CNegCmd *pToClient )
{
	int pid;
	CNegCmd resp_cmd;
	CNegCmd send_cmd;
	list< TAEDIT_INFO >::iterator itr;

	// pid
	pid = rCmd.GetData( SCI_S_PID, -1 );
	if ( !rCmd.HasData( SCI_S_PID ) ) {
		pToClient->AddData( SCI_R_STATUS, SCID_RSTAT_ERR );
		pToClient->AddData( SCI_R_MSG_NUMBER, SCID_RMSG_CMDDATA_INSUFFICIENCY );
		return ;
	}

	// ꤵ줿pidμɮ¸ߤ뤫ݤǧ
	itr = listInstance.begin();
	for (; itr != listInstance.end() && itr->pid != pid; itr++ );
	if ( itr == listInstance.end() ) {
		pToClient->AddData( SCI_R_STATUS, SCID_RSTAT_ERR );
		pToClient->AddData( SCI_R_FREE_MSG, "Specified pid is unknown." );
		return ;
	}

	// ɥ⡼ɤؤܤؼå
	send_cmd.AddData( SCI_S_COMMAND, SCID_CMD_SET_STANDALONE_ST );

	// å
	if ( !SendCmdToTaEdit( send_cmd, pid, &resp_cmd ) ) {
		pToClient->AddData( SCI_R_STATUS, SCID_RSTAT_ERR );
		pToClient->AddData( SCI_R_MSG_NUMBER, SCID_RMSG_UNEXPENTED );
		return ;
	}

	// ̤
	if ( resp_cmd.GetData( SCI_R_STATUS, SCID_RSTAT_ERR ) == SCID_RSTAT_OK ) {
		// ݻƤ
		listInstance.erase( itr );
		pToClient->AddData( SCI_R_STATUS, SCID_RSTAT_OK );
	}
	else {
		// ͤ
		pToClient->AddData( SCI_R_STATUS, SCID_RSTAT_ERR );
		if ( resp_cmd.HasData( SCI_R_MSG_NUMBER ) )
			resp_cmd.GetData( SCI_R_MSG_NUMBER, SCID_RMSG_UNEXPENTED );
		if ( resp_cmd.HasData( SCI_R_FREE_MSG ) )
			resp_cmd.GetData( SCI_R_FREE_MSG, "Unexpected Error." );
	}
}

// ե¸׵ᤵ줿
void CSyInstance::Save_CS( const CNegCmd &rCmd, CNegCmd *pToClient )
{
	int pid;
	CNegCmd send_cmd;
	list< TAEDIT_INFO >::iterator itr;

	// pid
	pid = rCmd.GetData( SCI_S_PID, -1 );
	if ( !rCmd.HasData( SCI_S_PID ) ) {
		pToClient->AddData( SCI_R_STATUS, SCID_RSTAT_ERR );
		pToClient->AddData( SCI_R_MSG_NUMBER, SCID_RMSG_CMDDATA_INSUFFICIENCY );
		return ;
	}

	// ꤵ줿pidμɮ¸ߤ뤫ݤǧ
	itr = listInstance.begin();
	for (; itr != listInstance.end() && itr->pid != pid; itr++ );
	if ( itr == listInstance.end() ) {
		pToClient->AddData( SCI_R_STATUS, SCID_RSTAT_ERR );
		pToClient->AddData( SCI_R_FREE_MSG, "Specified pid is unknown." );
		return ;
	}

	// ե¸ؼ륳ޥɤۤ
	send_cmd.AddData( SCI_S_COMMAND, SCID_CMD_SAVE_ST );

	// ե̾󥳡̾ԥɤμ̡ե饰
	send_cmd.AddData( SCI_S_FILE_NAME, rCmd.GetData( SCI_S_FILE_NAME, "" ) );
	send_cmd.AddData( SCI_S_ENCODE_NAME, rCmd.GetData( SCI_S_ENCODE_NAME, "" ) );
	send_cmd.AddData( SCI_S_CR_TYPE, rCmd.GetData( SCI_S_CR_TYPE, "" ) );
	send_cmd.AddData( SCI_S_FLG, rCmd.GetData( SCI_S_FLG, "" ) );

	// å
	if ( !SendCmdToTaEdit( send_cmd, pid, pToClient ) ) {
		pToClient->AddData( SCI_R_STATUS, SCID_RSTAT_ERR );
		pToClient->AddData( SCI_R_MSG_NUMBER, SCID_RMSG_UNEXPENTED );
	}

	// ͤΥåˡpidղä
	pToClient->AddData( SCI_S_PID, pid );

	// ե¸ϡݻƤե̾򹹿
	if ( pToClient->GetData( SCI_R_STATUS, SCID_RSTAT_ERR ) == SCID_RSTAT_OK )
		itr->FileName = rCmd.GetData( SCI_S_FILE_NAME, "" );
}

// ٤ƤΥե¸׵ᤵ줿
void CSyInstance::SaveAll_CS( const CNegCmd &rCmd, CNegCmd *pToClient )
{
	int pid;
	CNegCmd resp_cmd;
	CNegCmd send_cmd;
	list< TAEDIT_INFO >::iterator itr;
	vector< CNegCmd > vRetNegCmd;

	itr = listInstance.begin();
	for (; itr != listInstance.end(); itr++ ) {
		pid = itr->pid;
		send_cmd.Initialize();
		resp_cmd.Initialize();

		// ե¸ؼ륳ޥɤۤ
		send_cmd.AddData( SCI_S_COMMAND, SCID_CMD_SAVE_ST );

		// ե饰
		send_cmd.AddData( SCI_S_FLG, rCmd.GetData( SCI_S_FLG, "" ) );

		// ե̾󥳡̾ԥɤμ̤ϡޥɤǤϻǤʤΤȤ
		send_cmd.AddData( SCI_S_FILE_NAME, "" );
		send_cmd.AddData( SCI_S_ENCODE_NAME, "" );
		send_cmd.AddData( SCI_S_CR_TYPE, "" );

		// å
		if ( !SendCmdToTaEdit( send_cmd, pid, &resp_cmd ) ) {
			resp_cmd.AddData( SCI_R_STATUS, SCID_RSTAT_ERR );
			resp_cmd.AddData( SCI_R_MSG_NUMBER, SCID_RMSG_UNEXPENTED );
		}
		// ͤΥåˡpidղä
		resp_cmd.AddData( SCI_S_PID, pid );

		// ե¸ϡݻƤե̾򹹿
		if ( resp_cmd.GetData( SCI_R_STATUS, SCID_RSTAT_ERR ) == SCID_RSTAT_OK )
			itr->FileName = resp_cmd.GetData( SCI_S_FILE_NAME, "" );

		// ͤΥåɲ
		vRetNegCmd.push_back( resp_cmd );
	}

	// ƥץȤν̤󤴤ͤΥå˲ͤ
	pToClient->AddData( SCI_S_NEGCMT_VEC, vRetNegCmd );
	pToClient->AddData( SCI_R_STATUS, SCID_RSTAT_OK );
}

// ɮ󥹥ȥ饯󡦥⡼ɤ˻ä
int CSyInstance::StartSyuhitu( const string &FileName, const CNegCmd &rCmd ) const
{
	int pid;
	const char *SyuhituCommand = getenv( SCEV_TAEDIT_PATH );
	CProcStart procStart;

	int LineNumber = rCmd.GetData( SCI_S_LINE_NUMBER, 0 );
	const string &SyntaxName = rCmd.GetData( SCI_S_SYNTAX, string( "" ) );
	const string &EncodeName = rCmd.GetData( SCI_S_ENCODE_NAME, string( "" ) );
	const string &StdOutName = rCmd.GetData( SCI_S_STDOUT, string( "" ) );
	const string &StdErrName = rCmd.GetData( SCI_S_STDERR, string( "" ) );
	int OldFD_StdOout = -1;	// 򤷤ɸ
	int OldFD_StdErr = -1;	// 򤷤ɸ२顼

	if ( NULL == SyuhituCommand ) return -1;

	// ޥ
	procStart.SpecifyCommand( SyuhituCommand );

	// ե̾
	if ( FileName.length() > 0 )
		procStart.AddArg( string( "/file:" ) + FileName );

	// ֹ
	if ( LineNumber > 0 ) {
		char Buf[30];
		snprintf( Buf, 30, "/line:%d", LineNumber );
		procStart.AddArg( string( Buf ) );
	}

	// ʸ
	if ( SyntaxName.length() > 0 )
		procStart.AddArg( string( "/syntax:" ) + SyntaxName );

	// 󥳡
	if ( EncodeName.length() > 0 )
		procStart.AddArg( string( "/encode:" ) + EncodeName );

	// 󥹥ȥ饯⡼
	procStart.AddArg( string( "/construction" ) );

	// ɸϡɸ२顼ϤκؤԤȡ
	// ǥץϲ񤹤뤿ᡢ꡼ǤǤϤνϹԤʤ

	// ɸϤʤɤ򺹤ؤ
/*	if ( StdOutName.length() > 0 )
		OldFD_StdOout = BindFD( 1, StdOutName, false );
	if ( StdErrName.length() > 0 )
		OldFD_StdErr = BindFD( 2, StdErrName, false );
*/
	// ư
	pid = procStart.Start();
/*
	// ɸϤʤɤ򸵤᤹
	if ( OldFD_StdOout >= 0 ) dup2( OldFD_StdOout, 1 );
	if ( OldFD_StdErr >= 0 ) dup2( OldFD_StdErr, 2 );
*/
	return pid;
}

// ꤵ줿ɮ򥢥ƥ֤ˤ
bool CSyInstance::ActivateSyuhitu( int pid, const CNegCmd &rCmd ) const
{
	CNegCmd send_cmd;
	CNegCmd resp_cmd;
	int LineNumber = rCmd.GetData( SCI_S_LINE_NUMBER, 0 );
	const string &SyntaxName = rCmd.GetData( SCI_S_SYNTAX, string( "" ) );

	// ɮ륳ޥɤ
	send_cmd.AddData( SCI_S_COMMAND, SCID_CMD_ACTIVATE_ST );
	if ( LineNumber > 0 )
		send_cmd.AddData( SCI_S_LINE_NUMBER, LineNumber );
	if ( !SyntaxName.empty() )
		send_cmd.AddData( SCI_S_SYNTAX, SyntaxName.c_str() );

	// ޥɤ
	if ( !SendCmdToTaEdit( send_cmd, pid, &resp_cmd ) )
		return false;

	// ̤
	if ( resp_cmd.GetData( SCI_R_STATUS, SCID_RSTAT_ERR ) == SCID_RSTAT_OK )
		return true;
	else
		return false;
}

// Ϳ줿̾Υѥפꤵ줿ǥץ֤
// fdΥǥץ򤷤Υǥץ֤
int CSyInstance::BindFD( int fd, const string &FName, bool IsRead ) const
{
	int d = -1;
	int newFD = -1;

	// ꤵ줿ե򳫤
	if ( IsRead )
		d = open( FName.c_str(), O_RDONLY );
	else
		d = open( FName.c_str(), O_WRONLY );
	if ( d < 0 ) return -1;

	// fdΥեǥץʣ
	newFD = dup( fd );
	if ( newFD < 0 ) goto ERR_EXIT;

	// fd򳫤եΥǥץ˺ؤ
	if ( dup2( d, fd ) < 0 ) goto ERR_EXIT;

	return newFD;

ERR_EXIT:
	if ( d > 0 ) close( d );
	if ( newFD > 0 ) close( newFD );
	return -1;
}

// ɮ˳Ƥե̾䤤碌
bool CSyInstance::RequestFileName_ToTaEdit( int pid, string *pFName )
{
	CNegCmd send_cmd;
	CNegCmd resp_cmd;

	assert( NULL != pFName );

	// ޥɤ
	send_cmd.AddData( SCI_S_COMMAND, SCID_CMD_RQ_FNAME_ST );

	// ޥɤ
	if ( !SendCmdToTaEdit( send_cmd, pid, &resp_cmd ) ) return false;

	// ̤
	if ( !resp_cmd.HasData( SCI_S_FILE_NAME ) )
		return false;
	(*pFName) = resp_cmd.GetData( SCI_S_FILE_NAME, "" );
	return true;
}

// ɮ˥ФƵưȤΤ
bool CSyInstance::NoticeServerReboot_ToTaEdit( int pid )
{
	CNegCmd send_cmd;
	CNegCmd resp_cmd;

	// ޥɤ
	send_cmd.AddData( SCI_S_COMMAND, SCID_CMD_SVR_RESTART_ST );

	// ޥɤ
	if ( !SendCmdToTaEdit( send_cmd, pid, &resp_cmd ) ) return false;

	// ̤
	if ( resp_cmd.GetData( SCI_R_STATUS, SCID_RSTAT_ERR ) == SCID_RSTAT_OK )
		return true;
	else
		return false;	
}

// ɮ˥ޥɤ
bool CSyInstance::SendCmdToTaEdit( const CNegCmd& r, int pid, CNegCmd *pRet ) const
{
	string DirName;
	string fname_ST;	// ФɮؤΥѥפ̾
	string fname_TS;	// ɮ饵ФؤΥѥפ̾
	CFD fd_ST;			// ѥǥץ
	CFD fd_TS;			// ѥǥץ
	char Buf[15];
	struct stat wStat;

	assert( pRet );

	// ̾դѥפǼǥ쥯ȥ
	const char *p = getenv( SCEV_COMMUNITY_PATH );
	if ( !p ) {
		fprintf( stderr, "ERROR Syuhitu server : %s environment valuable is empty.\n", SCEV_COMMUNITY_PATH );
		return "";
	}
	DirName = p;
	if ( DirName.length() <= 0 ) DirName = ".";
	if ( DirName[ DirName.length() - 1 ] != '/' ) DirName += '/';

	// ե̾
	snprintf( Buf, sizeof( Buf ) * sizeof( char ), "%d", pid );
	fname_ST = DirName + SCPX_TO_SYUHITU + Buf;
	fname_TS = DirName + SCPX_FROM_SYUHITU + Buf;

	// ĤΥե뤬ѥפǤ뤳Ȥǧ
	if ( stat( fname_ST.c_str(), &wStat ) ) return false;
	if ( !S_ISFIFO( wStat.st_mode ) ) return false;
	if ( stat( fname_TS.c_str(), &wStat ) ) return false;
	if ( !S_ISFIFO( wStat.st_mode ) ) return false;

	// ѥפ򳫤
	if ( !fd_ST.Open( fname_ST.c_str(), O_WRONLY ) ) return false;
	if ( !fd_TS.Open( fname_TS.c_str(), O_RDONLY ) ) return false;

	// ѥǡ
	string SendData = r.GetSendData();

	// ޥɤ
	if ( !fd_ST.Write( SendData.c_str(), SendData.length() ) )
		return false;

	// ̤
	CNegCmd response( fd_TS );
	(*pRet) = response;

	return true;
}
