/////////////////////////////////////////////////////////////
// TaEditClient.c
// ɮ饤

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <door.h>
#include <string.h>
#include <sys/mman.h>
#include <memory.h>
#include <errno.h>
#include <unistd.h>
#include <sys/wait.h>
#include <limits.h>

#include <string>
#include <list>
#include <map>

#include "VPtr.h"
#include "ClientCO.h"
#include "CommandID.h"
#include "NegCmd.h"
#include "ProcStart.h"
#include "DoorClient.h"
#include "GlbFunc.h"

using namespace NNabikiVPtr;
using namespace std;

static string AddYen( const string& rStr );
static string AttachStdIO( int d );
static char *CopyString( const char* p );
static string GetDoorFilePath();
static bool StartServer();
static bool StartSyuhitu( const CClientCO &option );
static bool StartSyuhituByServer( const CClientCO &option );
static bool SendCommand( const CNegCmd &negcmd, CNegCmd *pRetNC );
bool PrintMessage( const CNegCmd &rmsg );
static void StopServer( bool ByForce );
static bool ShowFName();
static bool UnjoinConstructionMode( int pid );

// /ĤƤ뤳Ȥݾڤ
string AddYen( const string& rStr )
{
	if ( rStr.length() == 0 ) return "/";
	if ( rStr[ rStr.length() - 1 ] != '/' )
		return rStr + '/';
	else
		return rStr;
}


// ɸϤʤɤե˴ϢŤ
string AttachStdIO( int d )
{
	char Buf[ L_tmpnam + 1];
	int fd;

	// ƥݥΥե̾
	tmpnam( Buf );

	// ե
	fd = open( Buf, O_RDWR | O_CREAT | O_EXCL, 0600 );
	if ( fd < 0 ) return "";
	close( fd );

	// ǰΤ
	fdetach( Buf );

	// å
	if ( !fattach( d, Buf ) )
		return Buf;	// 

	// Ԥե
	remove( Buf );
	return "";
}

// ʸʣ
char *CopyString( const char* p )
{
	int len;
	char *r;
	assert( p );

	len = strlen( p );
	r = (char*)malloc( sizeof( char ) * ( len + 1 ) );
	if ( !r ) {
		fprintf( stderr, "ERROR Syuhitu client : Out of memory.\n" );
		return NULL;
	}
	strcpy( r, p );
	return r;
}

// doorΥե̾
string GetDoorFilePath()
{
	string r;
	const char *p = getenv( SCEV_COMMUNITY_PATH );
	if ( !p ) {
		fprintf( stderr, "ERROR Syuhitu client : %s environment valuable is empty.\n", SCEV_COMMUNITY_PATH );
		return "";
	}

	r = AddYen( string( p ) ) + SCPX_DOOR;

	return r;
}

// Фư
bool StartServer()
{
	string DoorFileName = GetDoorFilePath();
	const char *pServerPath = getenv( SCEV_SERVER_PATH );
	char wBuf[256];
	int fd[2] = { -1, -1 };
	bool r;
	int i;
	CProcStart procStart;

	// doorͭݤǧ
	// ѲǽǤСäˤ뤳ȤϤʤ
	if ( CDoorClient::CheckDoor( DoorFileName.c_str() ) )
		return true;

	if ( DoorFileName.empty() ) goto ERR_EXIT;

	// ФȤ̿ѤΥѥפ
	if ( pipe( fd ) ) goto ERR_EXIT;

	// Фư
	snprintf( wBuf, 256, "%d", fd[1] );
	procStart.SpecifyCommand( string( pServerPath ) );
	procStart.AddArg( DoorFileName );
	procStart.AddArg( string( wBuf ) );
	r = procStart.Start();
	if ( r < 0 ) goto ERR_EXIT;

	// ФαԤ
	i = read( fd[0], wBuf, 256 );
	if ( i > 0 && i < 256 ) {
		wBuf[i] = '\0';
		if ( strncmp( wBuf,"OK\n", i ) )
			r = false;
	}

ERR_EXIT:
	// ѥפĤ
	if ( fd[0] >= 0 ) close( fd[0] );
	if ( fd[1] >= 0 ) close( fd[1] );

	// ɬפ˱ƥ顼åɽ
	if ( !r )
		fprintf( stderr, "ERROR Syuhitu client : It failed to start server.\n" );

	return r;
}


// ɮư
bool StartSyuhitu( const CClientCO &option )
{
	const char *p;
	CProcStart procStart;

	p = getenv( SCEV_TAEDIT_PATH );
	if ( NULL == p ) {
		fprintf( stderr, "ERROR Syuhitu client : %s environment valuable is empty.\n", SCEV_TAEDIT_PATH );
		return false;
	}

	procStart.SpecifyCommand( string( p ) );

	if ( option.GetFileName().length() > 0 )
		procStart.AddArg( string( "/file:" ) + option.GetFileName() );

	if ( option.GetLineNumber() > 0 ) {
		char wBuf[128];
		snprintf( wBuf, 128, "/line:%d", option.GetLineNumber() );
		procStart.AddArg( string( wBuf ) );
	}

	if ( option.GetLangType().length() > 0 )
		procStart.AddArg( string( "/syntax:" ) + option.GetLangType() );

	if ( option.GetStandAlone() )
		procStart.AddArg( string( "/standalone" ) );

	if ( option.GetEncodeName().length() > 0 )
		procStart.AddArg( string( "/encode:" ) + option.GetEncodeName() );

	if ( procStart.Start() < 0 ) {
		fprintf( stderr, "ERROR Syuhitu client : It failed to start Syuhitu." );
		return false;
	}
	return true;
}

// зͳǼɮư
bool StartSyuhituByServer( const CClientCO &option )
{
	string StdOutName;	// ɸϤϢŤեΥѥ̾
	string StdErrName;	// Ʊɸ२顼
	string FileName;	// ե̾
	int LineNumber;		// ֹ
	string LangType;	// ʸ
	string EncodeName;	// 󥳡
	CNegCmd negcmd;
	CNegCmd retcmd;
	bool r = false;
	int len;
	int i;

	// ɸϤɸ२顼Ϥե˴ϢŤ
	StdOutName = AttachStdIO( 1 );
	if ( StdOutName.length() == 0 )
		fprintf( stderr, "WARNIG Syuhitu client : It failed to attach stdout to file.\n" );

	StdErrName = AttachStdIO( 2 );
	if ( StdErrName.length() == 0 )
		fprintf( stderr, "WARNIG Syuhitu client : It failed to attach stderr to file.\n" );

	// ץͤ
	FileName = option.GetFileName();
	LineNumber = option.GetLineNumber();
	LangType = option.GetLangType();
	EncodeName = option.GetEncodeName();

	// ޥɼ̤
	negcmd.AddData( SCI_S_COMMAND, SCID_CMD_OPENFILE_CS );

	// ե̾
	if ( !FileName.empty() )
		negcmd.AddData( SCI_S_FILE_NAME, FileName );

	// ֹ
	if ( LineNumber > 0 )
		negcmd.AddData( SCI_S_LINE_NUMBER, LineNumber );

	// ʸ
	if ( !LangType.empty() )
		negcmd.AddData( SCI_S_SYNTAX, LangType );

	// 󥳡
	if ( !EncodeName.empty() )
		negcmd.AddData( SCI_S_ENCODE_NAME, EncodeName );

	// ɸϤΥե̾
	if ( !StdOutName.empty() )
			negcmd.AddData( SCI_S_STDOUT, StdOutName );

	// ɸ२顼ϤΥե̾
	if ( !StdErrName.empty() )
		negcmd.AddData( SCI_S_STDERR, StdErrName );

	// Ф˥ޥɤ
	r = SendCommand( negcmd, &retcmd );
	if ( r ) PrintMessage( retcmd );

	// ɸϤʤɤ˥å줿ե
	if ( StdOutName.length() > 0 ) {
		fdetach( StdOutName.c_str() );
		remove( StdOutName.c_str() );
	}
	if ( StdErrName.length() > 0 ) {
		fdetach( StdErrName.c_str() );
		remove( StdErrName.c_str() );
	}

	return r;
}

// Ф˥ޥɤ
bool SendCommand( const CNegCmd &negcmd, CNegCmd *pRetNC )
{
	string DoorFileName;
	VPtr< char > pRetBuf;
	CDoorClient doorClient;

	// doorΥե̾
	DoorFileName = GetDoorFilePath();
	if ( DoorFileName.length() <= 0 ) return false;

	// door򳫤
	if ( !doorClient.Open( DoorFileName.c_str() ) ) {
		fprintf( stderr, "ERROR Syuhitu client : The server might stopped.\n" );
		return false;
	}

	// doorƤӽФ
	pRetBuf = doorClient.Call( &negcmd );
	if ( !pRetBuf.GetPtr() ) {
		// ƤӽФ˼Ԥ
		fprintf( stderr, "ERROR Syuhitu client : It failed to call server.\n" );
		return false;
	}

	// ̤᤹
	CNegCmd rmsg( pRetBuf.GetPtr(), pRetBuf.GetLen() );
	if ( pRetNC ) (*pRetNC) = rmsg;
	return true;
}

// ͤΥåɽ
// äϡ⤷ʤǿ֤
bool PrintMessage( const CNegCmd &rmsg )
{
	string ServerErrorMsg;

	// OKʤ齪λ
	if ( rmsg.GetData( SCI_R_STATUS, SCID_RSTAT_ERR ) == SCID_RSTAT_OK )
		return true;

	// 顼å
	switch ( rmsg.GetData( SCI_R_MSG_NUMBER, SCID_RMSG_UNEXPENTED ) ) {
	case SCID_RMSG_OUTOFMEMORY:
		ServerErrorMsg = "Out of memory";
		break;
	case SCID_RMSG_FILEISOPEND:
		ServerErrorMsg = "Specified file has been opened by another syuhitu.";
		break;
	case SCID_RMSG_TAEDIT_IS_EXIST:
		ServerErrorMsg = "Syuhitu instance is exist.";
		break;
	case SCID_RMSG_SERVER_REVOKED:
		ServerErrorMsg = "Server will be revoked.";
		break;
	case SCID_RMSG_CMDDATA_INSUFFICIENCY:
		ServerErrorMsg = "Unexpected error (Command data is unsufficiency).";
		break;
	default:
		ServerErrorMsg = rmsg.GetData( SCI_R_FREE_MSG, "" );
		if ( ServerErrorMsg.empty() )
			ServerErrorMsg = "Unexpected error";
	}

	// 顼åɽ
	fprintf( stderr,
		"ERROR Syuhitu client : Error was occurred in server - %s\n",
		ServerErrorMsg.c_str()
	);

	return false;
}

// Фߤ
void StopServer( bool ByForce )
{
	CNegCmd negcmd;
	CNegCmd retcmd;

	if ( ByForce )
		negcmd.AddData( SCI_S_COMMAND, SCID_CMD_STOP_FORCE_CS );
	else
		negcmd.AddData( SCI_S_COMMAND, SCID_CMD_STOP_CS );

	if ( !SendCommand( negcmd, &retcmd ) ) return ;

	if ( PrintMessage( retcmd ) ) {
		// åɽƤ
		fprintf( stderr, "Syuhitu client : It succeeded in the stop of the server.\n" );
	}
}

// ƤեΥե̾ɽ
bool ShowFName()
{
	CNegCmd negcmd;
	CNegCmd r_negcmd;
	string rstr;
	int i, j;

	// ޥɤ
	negcmd.AddData( SCI_S_COMMAND, SCID_CMD_REQUEST_FNAME );

	// ޥɤ
	if ( !SendCommand( negcmd, &r_negcmd ) ) return false;
	if ( !PrintMessage( r_negcmd ) ) return false;

	// ե̾ΰɽ
	rstr = r_negcmd.GetData( SCI_S_OTHER, "" );
	if ( rstr.length() == 0 ) {
		// ɽΤϲʤ
		return true;
	}

	// pidȥե̾ɽ
	i = 0;
	while ( i < rstr.length() ) {
		// pidɽ
		printf( "%s : ", rstr.c_str() + i );

		// ե̾ʬ򸡺
		for (; i < rstr.length() && rstr[i] != '\0'; i++ );
		if ( i >= rstr.length() ) break;
		i++;

		// ե̾ɽ
		printf( "%s\n", rstr.c_str() + i );

		// pidʬ򸡺
		for (; i < rstr.length() && rstr[i] != '\0'; i++ );
		if ( i >= rstr.length() ) break;
		i++;
	}
	return true;
}

// pid˻ꤷɮ򡢥ɥ⡼ɤذܹԤ
bool UnjoinConstructionMode( int pid )
{
	CNegCmd negcmd;
	CNegCmd retcmd;

	// ޥɤ
	negcmd.AddData( SCI_S_COMMAND, SCID_CMD_UNJOIN_CS );
	negcmd.AddData( SCI_S_PID, pid );

	// ޥɤ
	if ( !SendCommand( negcmd, &retcmd ) ) return false;
	return PrintMessage( retcmd );
}

// ե¸Ȥη̤ɽ
void PrintMessage_OnSave( const CNegCmd &retcmd )
{
	bool r = ( retcmd.GetData( SCI_R_STATUS, SCID_RSTAT_ERR ) == SCID_RSTAT_OK );
	if ( r ) {
		// ե̾ξ¸ϹԤäƤʤ
		if ( retcmd.GetData( SCI_S_FILE_NAME, "" ).length() > 0 )
			printf( "Succeed : " );
		else
			printf( "Skipped : " );
	}
	else
		printf( "Failed : " );
	printf( "%d : %s : %s : %s\n",
		retcmd.GetData( SCI_S_PID, -1 ),
		retcmd.GetData( SCI_S_FILE_NAME, "" ).c_str(),
		retcmd.GetData( SCI_S_ENCODE_NAME, "" ).c_str(),
		retcmd.GetData( SCI_S_CR_TYPE, "" ).c_str()
	);
	if ( !r ) {
		// ԤȤϥåɽ
		printf( "---" );
		PrintMessage( retcmd );
	}
}

// ꤷɮˡե¸ؼ
bool Save( const CClientCO &rOption )
{
	CNegCmd negcmd;
	CNegCmd retcmd;
	bool r = true;

	// ޥɤ
	negcmd.AddData( SCI_S_COMMAND, SCID_CMD_SAVE_CS );
	if ( rOption.GetQueryFileName() )
		negcmd.AddData( SCI_S_FLG, "query" );
	else
		negcmd.AddData( SCI_S_FLG, "nothing" );
	negcmd.AddData( SCI_S_PID, rOption.GetProcID() );
	negcmd.AddData( SCI_S_FILE_NAME, rOption.GetFileName() );
	negcmd.AddData( SCI_S_ENCODE_NAME, rOption.GetEncodeName() );
	negcmd.AddData( SCI_S_CR_TYPE, rOption.GetCRTypeName() );

	// ޥɤ
	if ( !SendCommand( negcmd, &retcmd ) ) return false;

	// ̤ɽ
	PrintMessage_OnSave( retcmd );

	return r;
}

// ٤Ƥμɮˡե¸ؼ
bool SaveAll( const CClientCO &rOption )
{
	CNegCmd negcmd;
	CNegCmd retcmd;
	vector< CNegCmd > vcmd;
	int i;
	bool r;

	// ޥɤ
	negcmd.AddData( SCI_S_COMMAND, SCID_CMD_SAVE_ALL_CS );
	if ( rOption.GetQueryFileName() )
		negcmd.AddData( SCI_S_FLG, "query" );
	else
		negcmd.AddData( SCI_S_FLG, "nothing" );

	// ޥɤ
	if ( !SendCommand( negcmd, &retcmd ) ) return false;

	// ¸ե뤴ȡ̤ɽ
	vcmd = retcmd.GetData( SCI_S_NEGCMT_VEC, vector< CNegCmd >() );
	for ( i = 0; i < vcmd.size(); i++ )
		PrintMessage_OnSave( vcmd[i] );

	return true;
}

int main( int argc, char *argv[] )
{
	string DoorFileName;
	CClientCO option;

	// ޥɤΥץ
	if ( !option.Initialize( argc, argv ) ) return 0;

	switch ( option.GetCmdType() ) {
	case CT_FILE_OPEN:
		// եΥץ

		if ( option.GetStandAlone() ) {
			// ɥξϡɮưƽλ
			if ( StartSyuhitu( option ) )
				return 0;
			else
				return 1;
		}

		// Фư
		if ( !StartServer() ) return 1;

		// ɮư
		if ( !StartSyuhituByServer( option ) ) return 1;

		break;

	case CT_BOOT_SERVER:
		// ФεưΤ
		if ( !StartServer() ) return 1;
		break;

	case CT_STOP_SERVER:
		// Ф
		StopServer( option.GetStopSvrByForce() );
		break;

	case CT_SHOW_FNMAE:
		// ƤեΥե̾ɽ
		if ( !ShowFName() ) return 1;
		break;

	case CT_UNJOIN_CONSTRUCTION_MODE:
		// ꤷɮ򥹥ɥ⡼ɤذܹԤ
		if ( !UnjoinConstructionMode( option.GetProcID() ) )
			return 1;
		break;

	case CT_SAVE:
		// ꤷɮˡե¸ؼ
		if ( !Save( option ) )
			return 1;
		break;

	case CT_SAVE_ALL:
		// ٤Ƥμɮ˥ե¸ؼ
		if ( !SaveAll( option ) )
			return 1;
		break;
	}

	return 0;
}
