////////////////////////////////////////////////////////////////////////////
// CFileWriter 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include "FileWriter.h"
#include "TaEditShell.h"

////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CFileWriter::CFileWriter() :
	pData( NULL ),
	EnableExitFlg( false ),
	InterruptFlg( false ),
	ErrorInfo(),
	CProcesingObj(),
	FaultWithTmp( false )
{

}

CFileWriter::~CFileWriter()
{

}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// 
void CFileWriter::SetInfo( const string &argFileName, const T_LineData *argData, bool argUseTmpFile )
{
	FileName = argFileName;
	pData = argData;
	EnableExitFlg = false;
	InterruptFlg = false;
	UseTmpFile = argUseTmpFile;
	FaultWithTmp = false;
}

// 񤭹ѥåɤΥȥݥ
void CFileWriter::run()
{
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	T_LineDataItr_c itr;
	T_LineDataItr_c itrLastLine;	// ǸιԤݥ
	string TmpfileName;

	EnableExitFlg = false;
	InterruptFlg = false;
	ErrorInfo = true;
	FaultWithTmp = false;

	// ƥݥΥե򤹤
	if ( UseTmpFile ) {
		if ( !MoveToTmp( FileName, &TmpfileName ) ) {
			// ʤΥåϷɻȤʤ餷
			ErrorInfo = CErrorBool( pConf->RefFaultToSaveTmpFileMsg() );
			FaultWithTmp = true;
			return ;
		}
		if ( InterruptFlg ) return ;
	}

	// ե򳫤
	FILE *outfile = fopen( FileName.c_str(), "w" );
	if ( NULL == outfile ) {
		ErrorInfo = CErrorBool( pConf->RefFaultFileOpenMsg() );
		EnableExitFlg = true;
		return ;
	}

	// ǸιԤݥȤ륤ƥ졼
	itrLastLine = pData->end();
	--itrLastLine;

	for ( itr = pData->begin(); itr != pData->end() && !ferror( outfile ) && !InterruptFlg; ++itr ) {
		// ԤĽϤ
		fputws( itr->getString().c_str(), outfile );
		// ʺǸιԤˤϲԥɤϤʤ
		if ( itr != itrLastLine ) putwc( L'\n', outfile );
	}

	if ( ferror( outfile ) )
		ErrorInfo = pConf->RefIOErrorMsg( errno );
	fclose( outfile );

	// ƥݥΥե˴
	if ( ErrorInfo && UseTmpFile && !InterruptFlg )
		unlink( TmpfileName.c_str() );

	EnableExitFlg = true;
}

// λǽݤ
bool CFileWriter::EnableExit() const
{
	return EnableExitFlg;
}

// 
void CFileWriter::Interrupt()
{
	InterruptFlg = true;
}

// 顼
CErrorBool CFileWriter::GetErrorInfo() const
{
	return ErrorInfo;
}

// ƥݥΥեذư
bool CFileWriter::MoveToTmp( const string &argFileName, string *pDestName ) const
{
	VPtr< char > pFNameBuf;
	VPtr< char > pMoveBuf;
	string wS2;
	int outfd = -1;
	FILE *infile = NULL;
	FILE *outfile = NULL;
	int readlen;
	bool r = false;
	int i;

	// ȥǥ쥯ȥƥݥե̾
	wS2 = FileName;
	for ( i = 0; i < wS2.length(); i++ ) {
		if ( wS2[i] == '/' )
			wS2.replace( i, 1, "_", 1 );
	}
	wS2 = string( "/tmp/" ) + wS2 + "_XXXXXX";

	// ե̾ѤΥХåեѰդ
	if ( !pFNameBuf.Malloc( sizeof( char ) * ( wS2.length() + 1 ) ) ) return false;
	strncpy( pFNameBuf.GetPtr(), wS2.c_str(), wS2.length() );
	pFNameBuf.GetPtr()[ wS2.length() ] = '\0';

	// ƥݥΥե򳫤
	outfd = mkstemp( pFNameBuf.GetPtr() );
	if ( -1 == outfd ) return false;
	outfile = fdopen( outfd, "wb" );
	if ( NULL == outfile ) goto ERR_EXIT;
	outfd = -1;

	// Ѥե֤̾
	(*pDestName) = pFNameBuf.GetPtr();
	pFNameBuf.Free();

	// ¸Υե򳫤
	infile = fopen( argFileName.c_str(), "rb" );
	if ( NULL == infile ) goto ERR_EXIT;

	// ȤΰưѤΥХåե
	if ( !pMoveBuf.Malloc( 65536 ) )
		goto ERR_EXIT;

	// ư
	while ( !ferror( infile ) && !feof( infile ) && !ferror( outfile ) && !feof( outfile ) && !InterruptFlg ) {
		readlen = fread( pMoveBuf.GetPtr(), sizeof( char ) , 65536, infile );
		if ( fwrite( pMoveBuf.GetPtr(), sizeof( char ) , readlen, outfile ) < readlen ) goto ERR_EXIT;
	}
	r = !ferror( infile ) && !ferror( outfile );

ERR_EXIT:
	// եĤ
	if ( infile ) fclose( infile );
	infile = NULL;
	if ( outfile ) fclose( outfile );
	outfile = NULL;
	if ( outfd >= 0 ) close( outfd );
	outfd = -1;

	return r;
}

// ƥݥեؤ¸ǼԤΤݤ
bool CFileWriter::GetFaultWithTmpFlg() const
{
	return FaultWithTmp;
}

