////////////////////////////////////////////////////////////////////////////
// CUndoListMgr 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include "UndoListMgr.h"
#include "TaEditShell.h"

////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CUndoListMgr::CUndoListMgr() :
	MaxUndoCount( 1000 )
{
	Clear();
}

CUndoListMgr::~CUndoListMgr()
{

}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// Undoǽʺ
void CUndoListMgr::SetMaxUndoCount( int argCnt )
{
	assert( NULL != this && argCnt > 0 && argCnt <= INT_MAX );
	MaxUndoCount = argCnt;
}

// ɥǽݤ
bool CUndoListMgr::EnableUndo() const
{
	list< VClsPtr< CEditCommand > >::const_iterator wItr;
	assert( NULL != this );

	// ꥹȤΥ0ʤ顢⤽UndoԲǽǤ
	if ( listUndo.size() == 0 ) return false;

	// Ƭ򼨤ƤUndoԲǽ
	if ( listUndo.begin() == itrUndo ) return false;

	return true;
}

// ɥǽݤ
bool CUndoListMgr::EnableRedo() const
{
	list< VClsPtr< CEditCommand > >::const_iterator wItr;
	assert( NULL != this );

	// ꥹȤΥ0ʤ顢⤽RedoԲǽǤ
	if ( listUndo.size() == 0 ) return false;

	// 򼨤ƤRedoԲ
	if ( listUndo.end() == itrUndo ) return false;

	wItr = listUndo.end();
	--wItr;

	// -1ΰ֤ˤTEC_ENDEDEIT򼨤Ƥ⡢RedoԲĤǤ
	if ( wItr == itrUndo && (*wItr)->GetType() == TEC_ENDEDEIT )
		return false;
	return true;
}

// UndoѤԽޥɥ֥Ȥ
list< VClsPtr< CEditCommand > > CUndoListMgr::GetUndoObj()
{
	assert( NULL != this && EnableUndo() );
	list< VClsPtr< CEditCommand > > rList;

	if ( itrUndo == listUndo.end() ) {
		// ؤƤ顢äƤ
		--itrUndo;
	}

	// λǤitrUndoTEC_ENDEDEIT򼨤ƤϤǤ
	assert( (*itrUndo)->GetType() == TEC_ENDEDEIT );
	assert( itrUndo != listUndo.begin() );

	// TEC_ENDEDEITޤǡǤѥꥹȤɲä
	--itrUndo;
	while ( itrUndo != listUndo.begin() && (*itrUndo)->GetType() != TEC_ENDEDEIT ) {
		rList.push_back( (*itrUndo) );
		--itrUndo;
	}
	if ( itrUndo == listUndo.begin() ) {
		// ƬãϡƬǤͤΥꥹȤäƤʤ
		rList.push_back( (*itrUndo) );
	}

	// ˥塼򹹿
	UpdateMenuStatus();
	return rList;
}

// RedoѤԽޥɥ֥Ȥ
list< VClsPtr< CEditCommand > > CUndoListMgr::GetRedoObj()
{
	assert( NULL != this && EnableRedo() );
	list< VClsPtr< CEditCommand > > rList;

	if ( (*itrUndo)->GetType() == TEC_ENDEDEIT ) {
		// ߥݥȤƤǤTEC_ENDEDEITʤСĿʤƤ
		++itrUndo;
	}

	// TEC_ENDEDEITޤǡǤѥꥹȤɲä
	while ( itrUndo != listUndo.end() && (*itrUndo)->GetType() != TEC_ENDEDEIT ) {
		rList.push_back( (*itrUndo) );
		++itrUndo;
	}

	// ˥塼򹹿
	UpdateMenuStatus();
	return rList;
}

// Խޥɥ֥Ȥɲä
void CUndoListMgr::PushBack( VClsPtr< CEditCommand > pObj )
{
	assert( NULL != this );

	// UndoꥹȤθȾʬ
	if ( itrUndo != listUndo.end() ) {
		// ⤷ؤƤΤTEC_ENDEDEITǤä顢μǤ
		if ( (*itrUndo)->GetType() == TEC_ENDEDEIT )
			++itrUndo;
		listUndo.erase( itrUndo, listUndo.end() );
	}

	// Ǥɲä
	listUndo.push_back( pObj );

	// ꥹȤĶϡƬΤΤ
	if ( listUndo.size() > MaxUndoCount ) {
		list< VClsPtr< CEditCommand > >::iterator wItr = listUndo.begin();
		wItr++;
		listUndo.erase( listUndo.begin(), wItr );
	}

	// ݥȤ
	itrUndo = listUndo.end();

	UpdateMenuStatus();
}

// Խνλ򼨤֥Ȥɲ
void CUndoListMgr::EndEdit()
{
	VClsPtr< CEditCommand > p = new CEditCommand( TEC_ENDEDEIT );
	PushBack( p );
}

// 
void CUndoListMgr::Clear()
{
	assert( NULL != this );
	listUndo.clear();
	itrUndo = listUndo.end();
}

// Undo/Redo˥塼ξ֤򹹿
void CUndoListMgr::UpdateMenuStatus() const
{
	assert( NULL != this );
	m_TaEditShell->SetEnableUndoMenu( EnableUndo() );
	m_TaEditShell->SetEnableRedoMenu( EnableRedo() );
}
