////////////////////////////////////////////////////////////////////////////
// CTaEditDraw 饹Υ󥿥ե
//
////////////////////////////////////////////////////////////////////////////

#if !defined( TAEDITDRAW_H_INCLUDED_ )
#define TAEDITDRAW_H_INCLUDED_

#include "output/gui.h"

#include "TaEdit_std.h"

#include "ScrollInfoPacket.h"
#include "TaEditDoc.h"
#include "ScrollMgr.h"
#include "Cursor.h"
#include "Mouse.h"
#include "GCMgr.h"
#include "XimMgr.h"
#include "TextEdit.h"
#include "DrewLineCash.h"
#include "TEDrawPopup.h"

#include <Dt/Dnd.h>

class CTaEditDraw :
	public CDraw,
	public CScrEventHandler
{
public:
	CTaEditDraw();
	~CTaEditDraw();

	// 
	void OnCreate( Widget argWgt, XtPointer user_data );

	// ˲
	void OnDestroy( Widget argWgt, XtPointer user_data );

	// ɥȤɤ߹ޤ줿
	void OnReadDocument();

	// СΥ֥Ȥ
	void SetScrollMgr( CScrollMgr *argpH, CScrollMgr *argpV );

	// ޥ
	void OnMouse( Widget w, XEvent *event, Boolean *continue_to_dispatch );

	// ޥݥ󥿤ΰư
	void OnPointerMotion( Widget w, XEvent *event, Boolean *continue_to_dispatch );

	// ޥ٥
	void OnTimer();

	// ƥȤι⤵
	int GetTextHeight() const;
	int GetTextAscent() const;

	// 
	void DrawCursor( int x, int y ) const;
protected:
	void DrawCursor( int x, int y, Drawable drawable ) const;
public:

	// ʸ
	int GetCharWidth( wchar_t c, int xpos ) const;

	// ־褷ƤԤιֹ
	int GetTopLineNum() const;

	// ϰϤκüΥԥΰ֤
	int GetLeftPixPos() const;

	// ӥ塼ǤԿ
	int GetViewLineCnt() const;

	// ӥ塼
	int GetViewWidth() const;

	// ĥ
	void ScrollV( int y, bool NeedRedraw );

	// 
	void ScrollH( int x, bool NeedRedraw );

	// ̾Xɸ顢鲿ʸܤ򻻽Ф
	// pixXLeftColumnWidthˤƵXɸǤ
	int XPosToCharNum( int lineY, int pixX ) const;

	// ̾κɸ顢ʸ֤򻻽Ф
	// pixXLeftColumnWidthˤƵXɸǤ
	T_CurPos PixPosToCurPos( int pixX, int pixY ) const;

	// ̤˲褷Ƥ뤫
	// ʸƤФ١褹٤׹Կ׻
	int GetDrawedLineCnt() const;

	VClsPtr< CTextEdit > GetTextEditor();	// Խ֥Ȥ
	VClsPtr< CCursor > GetCursorInfo();		// ֥Ȥ
	const CCursor* GetCursorInfo() const;

	// ԽκԤ
	void AfterEditRedraw( const ScrollInfoPacket &rScrPacket );

	// ϰϤѲκԤ
	void AfterSelRangeRedraw( int argSLine, int argELine );

	// եξ֤
	bool GetForcusState() const;

	// եꤹ
/*	void SetForcus() const {
		Display *pDisplay = XtDisplay( m_Draw );
		Window window = XtWindow( m_Draw );
		XSetInputFocus( pDisplay, window, RevertToParent, CurrentTime );
	};*/

protected:
	// ϥХå
	void OnInput( Widget argWgt, XtPointer user_data );

	// ϥ٥
	void OnKey( Widget w, XEvent *event, Boolean *continue_to_dispatch );

	// ɽ
	void OnExpose( Widget argWgt, XtPointer user_data );

	// ѹ
	void OnResize( Widget argWgt, XtPointer user_data );

	// եν
	void OnForcus( Widget w, XEvent *event, Boolean *continue_to_dispatch );

	// ޥܥβ
	void OnMouse2Push( XButtonPressedEvent* event );

	// ޥαܥβ
	void OnMouse3Push( XButtonPressedEvent* event );

	// ޥΥܥˤؤΥ
	void OnMouseScrollUp( XButtonPressedEvent* event );

	// ޥΥܥˤ벼ؤΥ
	void OnMouseScrollDown( XButtonPressedEvent* event );

	// ɥåץ٥
	void OnDrop( DtDndTransferCallbackStruct *pCallbackData );

	// С줿
	void OnScrValueChange( const CScrollMgr *argpMgr, int value, bool NeedRedraw );

	// ΰΥ
	void GetSize( int *pX, int *pY ) const;

	// Υ
	enum enumREDRAWTYPE {
		TED_REUSE_CHAR_INFO, // 褹
		TED_LINE_BASE	// ñ̤Ǥ̵ͭ
	};

	// ̡΢̡ˤ򥯥ꥢ
	void ClearBackScreen();

	// 
	void OnRedraw( enumREDRAWTYPE type , int argSLine, int argELine );
	void OnRedraw( enumREDRAWTYPE type );

	// ʸ־Ѥʸ
	void DrawString_ReuseCharInfo( Display *pDisplay, Drawable argDrawable, int XPos, int YPos, const T_LineDataItr_c &rItr, int LineNum, int ViewWidth ) const;

	// ̤λꤵ줿֤ʸ
	void DrawString( Display *pDisplay, Drawable argDrawable, int XPos, int YPos, const T_LineDataItr_c &rItr, int StrSPos, int StrCnt, int LineNum ) const;

	// ¦Υ
	void DrawLeftColumn( Display *pDisplay, Drawable argDrawable, int YPos, const T_LineDataItr_c &rItr, int ColW, int ColCnt ) const;

	// ǽ˲̤ɽȤΥ٥
	void OnFirstExpose();

	// եξ֤ѲФ륤٥ȥϥɥ
	static void OnForcusEvent( Widget w, XtPointer client_data, XEvent *event, Boolean *continue_to_dispatch );

	// ܡϤФ륤٥ȥϥɥ
	static void OnKeybordEvent( Widget w, XtPointer client_data, XEvent *event, Boolean *continue_to_dispatch );

	// ޥФ륤٥ȥϥɥ
	static void OnMouseEvent( Widget w, XtPointer client_data, XEvent *event, Boolean *continue_to_dispatch );

	// ޥݥ󥿤ΰưФ륤٥ȥϥɥ
	static void OnPointerMotionEvent( Widget w, XtPointer client_data, XEvent *event, Boolean *continue_to_dispatch );

	// ɥåפ줿ȤΥХå
	static void OnDropCallback( Widget w, XtPointer client_data, XtPointer callback_data );

protected:
	// ֥Хåեѥԥåޥå
	Pixmap BackgndPixmap;

	// ־褷Ƥ
	int numTopLine;

	VClsPtr< CCursor > pCursorInfo;	// ֥
	VClsPtr< CMouse > pMouseInfo;	// ޥ֥
	VClsPtr< CGCMgr > pGCMgr;	// GC֥
	VClsPtr< CXimMgr > pXimMgr;	// XIM֥
	VClsPtr< CTextEdit > pTextEditor;	// Խ֥

	int ViewLineCnt;	// åȤǽʹԿ
	int MaxLengthPix;	// äȤĹԤ褹Τפԥ
	int DrawedLineCnt_hoz;	// ߲̤˲褷Ƥ뤫¸ѡ
	vector< CDrewLineCash > vDrewLD;	// 褷ƤԤ˴ؤ

	XFontSet fontSet;	// եȥå
	int TextHeight;	// ƥȤι⤵
	int TextAscent;	// ƥȤξȾʬι⤵
	int TabWidth;	// ֤
	enumTABWIDTHCALCMETHOD TabWidth_CM;	// η׻ˡ
	const wstring *pTabString;	// ֥Ϥʸ

	CScrollMgr *pHScrollMgr;	// ʿС
	CScrollMgr *pVScrollMgr;	// ľС

	bool IsFirstExposed;	// ǽβɽäݤ

	bool ForcusState;	// եξ
						// եƤп

	int LeftColumnWidth;	// ¦˾˳ݤΰ
};

#endif // TAEDITDRAW_H_INCLUDED_

