///////////////////////////////////////////////////////////////////////////
// CConfigInfo 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include "ConfigInfo.h"

////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CConfigInfo::CConfigInfo( Widget widget )
	: m_Widget( widget ),
	pExInfoColumnColor( NULL )
{

}

CConfigInfo::~CConfigInfo()
{
	if ( pExInfoColumnColor )
		free( pExInfoColumnColor );
	pExInfoColumnColor = NULL;
}

////////////////////////////////////////////////////////////////////////////
// ؿ
////////////////////////////////////////////////////////////////////////////

// ʸ%1%9ꤵ줿ƥȤִ
template< typename T_Str, typename T_Char >
T_Str CreateMsgString( const T_Str &rMsg, int cnt, const T_Char *pvArgStr[] )
{
	T_Str RetStr;	// ͤȤʤʸݻ
	int i;

	assert( cnt >= 1 && cnt <= 9 );	// Ǥ⣹

	i = 0;
	while ( i < rMsg.length() ) {
		if ( rMsg[i] != T_Char( '%' ) ) {
			// %ʳʸRetStrɲä
			RetStr += rMsg[i];
			i++;
		}
		else {
			// %줿
			i++;

			// ñ%и̵뤹
			if ( i >= rMsg.length() ) break;

			if ( rMsg[i] >= T_Char( '1' ) && rMsg[i] < ( T_Char( '1' ) + cnt ) ) {
				// %1%cntޤǤξ
				RetStr += pvArgStr[ rMsg[i] - T_Char( '1' ) ];
			}
			else {
				if ( rMsg[i] == T_Char( '%' ) )
					RetStr += T_Char( '%' );	// %%%ĽϤ
				else {
					// ʳξϡΤޤ޽Ϥ
					RetStr += T_Char( '%' );
					RetStr += rMsg[i];
				}
			}
			i++;
		}
	}

	return RetStr;
}


////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// 
void CConfigInfo::Initialize()
{
	struct tagAppData {
		const char* OkString;				// åܥåOKܥ
		const char* CancelString;			// ƱCancel
		const char* YesString;				// ƱYes
		const char* NoString;				// ƱNo
		const char* NewFileWndTitle;		// եۤݤΡɥΥȥ
		const char* FailToConvertCharSet;	// ʸɤѴ˼
		const char* BrokenLineMsg;			// Ԥ10kۤȤΥå
		const char* DeviceIOErrorMsg;		// ϻ˥ǥХǥ顼
		const char* TextEncodeErrorMsg;		// Ϥ줿ƥȤ
		const char* IOErrorMsg;				// ¾ϻΥ顼Υå
		const char* OutOfMemoryErrorMsg;	// ­Υ顼Υå
		const char* FileNameIsNotInputtedErrorMsg;// ե̾ϤƤʤȤΥå
		const char* UnexpectedErrorMsg;		// ͽʤ顼Υå
		const char* FileIsNotExistMsg;		// ե뤬¸ߤʤȤΥå
		const char* SpecifiedNameIsDirMsg;	// ǥ쥯ȥ꤬ꤵ줿Υå
		const char* FaultFileOpenMsg;		// եΥץ˼ԤΥå
		const char* PreservationCheckMsg;	// ե¸ǧΥå
		const char* RunScriptEAGAINMsg;		// ץĶˤ롢ҥץ˼
		const char* RunScriptEINTRMsg;		// ҥץ˳ߤ줿
		const char* RunScriptENOMEMMsg;		// ­ˤҥץ˼
		const char* RunScriptCancelOpenMsg;	// ץȤˤեΥץ󤬥󥻥뤵줿
		const char* RunScriptCancelSaveMsg;	// ץȤˤեΥ֤󥻥뤵줿
		const char* ShowCancelOpenMsg;		// ץȤˤեΥץ󤬥󥻥뤵줿Ȥåɽ뤫ݤ
		const char* ShowCancelSaveMsg;		// ץȤˤեΥ֤󥻥뤵줿Ȥåɽ뤫ݤ
		const char* FaultLoadPluginLibraryMsg;	// ץ饰Υ饤֥Υɤ˼ԤȤΥå
		const char* FaultGetPluginFunctionMsg;	// ץ饰δؿΥɥ쥹μ˼ԤȤΥå
		const char* FailToGetPID;			// getpid˼ԤΥå
		const char* FailToCreateChildProcess;	// ҥץ˼ԤΥå
		const char* FileOpenDlgTitle;		// ե򳫤Υȥ
		const char* FileSaveDlgTitle;		// ̾դ¸Υȥ
		const char* NormalTextF_ColorName;	// ƥȤ褹뿧̾
		const char* NormalTextB_ColorName;	// ƥȤطʤο̾
		const char* SelectedTextF_ColorName;	// 򤵤줿ƥȤο̾
		const char* SelectedTextB_ColorName;	// 򤵤줿ƥȤطʤο̾
		const char* BackgroundColorName;	// طʤο̾
		const char* CursorColorName;		// 褹뿧̾
		const char* PreEditTextF_ColorName;	// ԽΥƥȤο̾
		const char* PreEditTextB_ColorName;	// ԽΥƥȤطʤο̾
		const char* FontName;				// ѤեȤ̾
		int TabWidth;						// Tab
		const char* CantFindTextMsg;		// оݤʸ󤬸ĤʤȤΥå
		const char* WrongRegexPatternMsg;	// ɽΥѥ󤬴ְäƤȤΥå
		const char* WRP_EofNotAnticipated;	// ɽθθͽʤEOF
		const char* WRP_OutOfMemory;		// Ʊ­
		const char* WRP_UncertainChar;		// ƱǧǤʤʸ
		const char* WRP_ZeroLengthPattern;	// ƱѥĹ0
		const char* WRP_Unexpected;		// Ʊͽʤ顼
		const char* AppTitle;			// ץꥱΥȥ̾
		const char* CharSelType;		// ʸˡ
		int LeftPadding;			// ü;
		int RightPadding;			// ü;
		int LineNumberOrigin;		// ֹγ
		int LineGapWidth;			// Դ֤
		const char* TabWidthCalculationMethod;	// η׻ˡ
		const char* TabString;				// ֥Ϥʸ
		const char* ProcUpScript;			// ץư줿Ȥ˼¹Ԥ륳ޥ
		const char* FileReadScript;			// եɤ߹߻˼¹Ԥ륳ޥ
		const char* FileAfterReadScript;	// եɤ߹߸˼¹Ԥ륳ޥ
		const char* FileBeforeWriteScript;	// ե񤭹˼¹Ԥ륳ޥ
		const char* FileWriteScript;		// ե񤭹߻˼¹Ԥ륳ޥ
		const char* FileCloseScript;		// ե뤬ĤȤ˼¹Ԥ륳ޥ
		const char* ProcDownScript;			// ץλȤ˼¹Ԥ륳ޥ
		const char* AutoIndent;				// ưǥȤ̵ͭ
		const char* IndentChar;				// ǥоݤʸ
		const char* WordCharSet;			// ñ˻Ѥʸ
		const char* DropFileOpenMethod;		// ɥåפ줿եγ
		const char* Btn2Func;				// ޥܥεư
		int MaxUndoCount;			// Undoǽʲ
		unsigned int HScrollAt;		// ưȼԤñ
		const char* ClipboardEncode;		// ʸ򥯥åץܡɤĥդȤΥ󥳡
		int ShowPrecessingDlgDelay;			// ɽޤǤٱ
		int WindowWidth;					// ֤ˤ륦ɥ
		int WindowHeight;					// ֤ˤ륦ɥι⤵
		int ScrollMouseSpeed;				// ޥǤΥ뤹®
		const char* IconImageName;			// ѥԥåޥåפ̾
		int ExInfoColumnCount;				// ̺¦ˤ⤦ĥΰο
		int ExInfoColumnWidth;				// Ƴĥΰ
		const char* ExInfoColumnColor;		// Ƴĥΰο
		const char* DrawSeparatorLine;		// ¦ΥʬΥݤ
		const char* SeparatorLineColor;		// ¦ΥʬΥο
		int AutoSaveInterval;				// ư¸Ԥֳ
		const char* AutoSaveNewFileMethod;	// ̾ʤեФ뼫ư¸ν
		int LangTypeEnableMaxSize;				// ⡼ɤѤ롢եκĹ
		const char* CPP_FileExt;				// C++⡼ɤǳեγĥ
		const char* JAVA_FileExt;				// Java⡼ɤǳեγĥ
		const char* COBOL_FileExt;				// Cobol⡼ɤǳեγĥ
		const char* JS_FileExt;					// JavaScript⡼ɤǳեγĥ
		const char* VBS_FileExt;				// VBScript⡼ɤǳեγĥ
		const char* CS_FileExt;					// C#⡼ɤǳեγĥ
		const char* CPP_NormalTextF_ColorName;	// C++Ǥ̾ʸο
		const char* CPP_KeywordF_ColorName;		// C++ǤΥɤο
		const char* CPP_CommentF_ColorName;		// C++ǤΥȤο
		const char* CPP_SringF_ColorName;		// C++Ǥʸο
		const char* JAVA_NormalTextF_ColorName;	// JavaǤ̾ʸο
		const char* JAVA_KeywordF_ColorName;	// JavaǤΥɤο
		const char* JAVA_CommentF_ColorName;	// JavaǤΥȤο
		const char* JAVA_SringF_ColorName;		// JavaǤʸο
		const char* COBOL_NormalTextF_ColorName;	// CobolǤ̾ʸο
		const char* COBOL_KeywordF_ColorName;		// CobolǤΥɤο
		const char* COBOL_CommentF_ColorName;		// CobolǤΥȤο
		const char* COBOL_SringF_ColorName;			// CobolǤʸο
		const char* COBOL_SequenceNumberF_ColorName;// CobolǤΰϢֹο
		const char* JS_NormalTextF_ColorName;	// JavaScriptǤ̾ʸο
		const char* JS_KeywordF_ColorName;		// JavaScriptǤΥɤο
		const char* JS_CommentF_ColorName;		// JavaScriptǤΥȤο
		const char* JS_SringF_ColorName;		// JavaScriptǤʸο
		const char* VBS_NormalTextF_ColorName;	// VBScriptǤ̾ʸο
		const char* VBS_KeywordF_ColorName;		// VBScriptǤΥɤο
		const char* VBS_CommentF_ColorName;		// VBScriptǤΥȤο
		const char* VBS_SringF_ColorName;		// VBScriptǤʸο
		const char* CS_NormalTextF_ColorName;	// C#Ǥ̾ʸο
		const char* CS_KeywordF_ColorName;		// C#ǤΥɤο
		const char* CS_CommentF_ColorName;		// C#ǤΥȤο
		const char* CS_SringF_ColorName;		// C#Ǥʸο
		const char* PluginConfigFileName;		// ץ饰ե̾
	} AppData;

	map< string, Pixel > mapPixelCash;	// ̾PixelͤȤбݻ륭å
	Colormap wColormap;
	Display *pDisplay = XtDisplay( m_Widget );
	Pixel black = BlackPixelOfScreen( XtScreen( m_Widget ) );
	Pixel white = WhitePixelOfScreen( XtScreen( m_Widget ) );
	int i;

	// ꥽ηȥǥե
	XtResource resources[] = {
		{ const_cast< char* >( "okBtnText" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, OkString ), XtRString, const_cast< char* >( "OK" ) },
		{ const_cast< char* >( "cancelBtnText"), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, CancelString ), XtRString, const_cast< char* >( "Cancel" ) },
		{ const_cast< char* >( "yesBtnText" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, YesString ), XtRString, const_cast< char* >( "Yes" ) },
		{ const_cast< char* >( "noBtnText" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, NoString ), XtRString, const_cast< char* >( "No" ) },
		{ const_cast< char* >( "newFileWndTitle" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, NewFileWndTitle ), XtRString, const_cast< char* >( "Untitled" ) },
		{ const_cast< char* >( "failToConvertCharSet" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, FailToConvertCharSet ), XtRString, const_cast< char* >( "Failuer to convert character set." ) },
		{ const_cast< char* >( "brokenLineMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, BrokenLineMsg ), XtRString, const_cast< char* >( "The line broke." ) },
		{ const_cast< char* >( "deviceIoErrorMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, DeviceIOErrorMsg ), XtRString, const_cast< char* >( "I/O Device Error occurred." ) },
		{ const_cast< char* >( "textEncodeErrorMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, TextEncodeErrorMsg ), XtRString, const_cast< char* >( "The data obtained from the input stream doesn't compose a correct character. " ) },
		{ const_cast< char* >( "ioErrorMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, IOErrorMsg ), XtRString, const_cast< char* >( "I/O Error occurred." ) },
		{ const_cast< char* >( "outOfMemoryErrorMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, OutOfMemoryErrorMsg ), XtRString, const_cast< char* >( "Out of memory." ) },
		{ const_cast< char* >( "fileNameIsNotInputtedErrorMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, FileNameIsNotInputtedErrorMsg ), XtRString, const_cast< char* >( "File name is not specified." ) },
		{ const_cast< char* >( "unexpectedErrorMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, UnexpectedErrorMsg ), XtRString, const_cast< char* >( "Unexpected Error." ) },
		{ const_cast< char* >( "fileIsNotExistMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, FileIsNotExistMsg ), XtRString, const_cast< char* >( "File is not Exist." ) },
		{ const_cast< char* >( "specifiedNameIsDirMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, SpecifiedNameIsDirMsg ), XtRString, const_cast< char* >( "Specified name is Dir." ) },
		{ const_cast< char* >( "faultFileOpenMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, FaultFileOpenMsg ), XtRString, const_cast< char* >( "File open Error occurred." ) },
		{ const_cast< char* >( "preservationCheckMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, PreservationCheckMsg ), XtRString, const_cast< char* >( "The file is not saved. Does it save?" ) },
		{ const_cast< char* >( "runScriptEAGAINMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, RunScriptEAGAINMsg ), XtRString, const_cast< char* >( "The number of processes exceeded restriction of a system." ) },
		{ const_cast< char* >( "runScriptEINTRMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, RunScriptEINTRMsg ), XtRString, const_cast< char* >( "Child process was interrupted." ) },
		{ const_cast< char* >( "runScriptENOMEMMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, RunScriptENOMEMMsg ), XtRString, const_cast< char* >( "The new process requires more memory than is available." ) },
		{ const_cast< char* >( "runScriptCancelOpenMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, RunScriptCancelOpenMsg ), XtRString, const_cast< char* >( "File open was canceled by File-Read-Script" ) },
		{ const_cast< char* >( "runScriptCancelSaveMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, RunScriptCancelSaveMsg ), XtRString, const_cast< char* >( "File Save was canceled by File-Before-Write-Script" ) },
		{ const_cast< char* >( "showCancelOpenMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, ShowCancelOpenMsg ), XtRString, const_cast< char* >( "True" ) },
		{ const_cast< char* >( "showCancelSaveMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, ShowCancelSaveMsg ), XtRString, const_cast< char* >( "True" ) },
		{ const_cast< char* >( "faultLoadPluginLibraryMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, FaultLoadPluginLibraryMsg ), XtRString, const_cast< char* >( "Fault to load library %1.\nReason : %2" ) },
		{ const_cast< char* >( "faultGetPluginFunctionMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, FaultGetPluginFunctionMsg ), XtRString, const_cast< char* >( "Fault to get Function %2 on library %1.\nReason : %3" ) },
		{ const_cast< char* >( "failToGetPID" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, FailToGetPID ), XtRString, const_cast< char* >( "Fail to getpid." ) },
		{ const_cast< char* >( "failToCreateChildProcess" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, FailToCreateChildProcess ), XtRString, const_cast< char* >( "Fail to create child process." ) },
		{ const_cast< char* >( "fileOpenDlgTitle" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, FileOpenDlgTitle ), XtRString, const_cast< char* >( "Open" ) },
		{ const_cast< char* >( "fileSaveDlgTitle" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, FileSaveDlgTitle ), XtRString, const_cast< char* >( "Save" ) },
		{ const_cast< char* >( "normalTextForegroundColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, NormalTextF_ColorName ), XtRString, const_cast< char* >( "Black" ) },
		{ const_cast< char* >( "normalTextBackgroundColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, NormalTextB_ColorName ), XtRString, const_cast< char* >( "White" ) },
		{ const_cast< char* >( "selectedTextForegroundColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, SelectedTextF_ColorName ), XtRString, const_cast< char* >( "White" ) },
		{ const_cast< char* >( "selectedTextBackgroundColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, SelectedTextB_ColorName ), XtRString, const_cast< char* >( "Black" ) },
		{ const_cast< char* >( "backgroundColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, BackgroundColorName ), XtRString, const_cast< char* >( "White" ) },
		{ const_cast< char* >( "cursorColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, CursorColorName ), XtRString, const_cast< char* >( "White" ) },
		{ const_cast< char* >( "preEditTextForegroundColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, PreEditTextF_ColorName ), XtRString, const_cast< char* >( "Black" ) },
		{ const_cast< char* >( "preEditTextBackgroundColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, PreEditTextB_ColorName ), XtRString, const_cast< char* >( "White" ) },
		{ const_cast< char* >( "fontName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, FontName ), XtRString, const_cast< char* >( "*-14-*" ) },
		{ const_cast< char* >( "tabWidth" ), XtCWidth, XtRInt, sizeof( int ), XtOffset( tagAppData*, TabWidth ), XtRString, const_cast< char* >( "8" ) },
		{ const_cast< char* >( "cantFindTextMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, CantFindTextMsg ), XtRString, const_cast< char* >( "Can't Find Text." ) },
		{ const_cast< char* >( "wrongRegexPatternMsg" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, WrongRegexPatternMsg ), XtRString, const_cast< char* >( "Regular expression pattern is wrong.\n%1 : %2" ) },
		{ const_cast< char* >( "WRP_EofNotAnticipated" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, WRP_EofNotAnticipated ), XtRString, const_cast< char* >( "EOF not anticipated." ) },
		{ const_cast< char* >( "WRP_OutOfMemory" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, WRP_OutOfMemory ), XtRString, const_cast< char* >( "Out of memory." ) },
		{ const_cast< char* >( "WRP_UncertainChar" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, WRP_UncertainChar ), XtRString, const_cast< char* >( "Uncertain char." ) },
		{ const_cast< char* >( "WRP_ZeroLengthPattern" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, WRP_ZeroLengthPattern ), XtRString, const_cast< char* >( "Pattern is not exist." ) },
		{ const_cast< char* >( "WRP_Unexpected" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, WRP_Unexpected ), XtRString, const_cast< char* >( "Unexpected error." ) },
		{ const_cast< char* >( "appTitle" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, AppTitle ), XtRString, const_cast< char* >( "Syuhitu" ) },
		{ const_cast< char* >( "characterSelectionType" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, CharSelType ), XtRString, const_cast< char* >( "CENTER" ) },
		{ const_cast< char* >( "leftPadding" ), XtCWidth, XtRInt, sizeof( int ), XtOffset( tagAppData*, LeftPadding ), XtRString, const_cast< char* >( "5" ) },
		{ const_cast< char* >( "rightPadding" ), XtCWidth, XtRInt, sizeof( int ), XtOffset( tagAppData*, RightPadding ), XtRString, const_cast< char* >( "5" ) },
		{ const_cast< char* >( "lineNumberOrigin" ), XtCY, XtRInt, sizeof( int ), XtOffset( tagAppData*, LineNumberOrigin ), XtRString, const_cast< char* >( "1" ) },
		{ const_cast< char* >( "lineGapWidth" ), XtCWidth, XtRInt, sizeof( int ), XtOffset( tagAppData*, LineGapWidth ), XtRString, const_cast< char* >( "0" ) },
		{ const_cast< char* >( "tabWidthCalculationMethod" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, TabWidthCalculationMethod ), XtRString, const_cast< char* >( "Flex" ) },
		{ const_cast< char* >( "tabString" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, TabString ), XtRString, const_cast< char* >( "\t" ) },
		{ const_cast< char* >( "procUpScript" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, ProcUpScript ), XtRString, const_cast< char* >( "" ) },
		{ const_cast< char* >( "fileReadScript" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, FileReadScript ), XtRString, const_cast< char* >( "" ) },
		{ const_cast< char* >( "fileAfterReadScript" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, FileAfterReadScript ), XtRString, const_cast< char* >( "" ) },
		{ const_cast< char* >( "fileBeforeWriteScript" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, FileBeforeWriteScript ), XtRString, const_cast< char* >( "" ) },
		{ const_cast< char* >( "fileWriteScript" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, FileWriteScript ), XtRString, const_cast< char* >( "" ) },
		{ const_cast< char* >( "fileCloseScript" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, FileCloseScript ), XtRString, const_cast< char* >( "" ) },
		{ const_cast< char* >( "procDownScript" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, ProcDownScript ), XtRString, const_cast< char* >( "" ) },
		{ const_cast< char* >( "autoIndent" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, AutoIndent ), XtRString, const_cast< char* >( "True" ) },
		{ const_cast< char* >( "indentChar" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, IndentChar ), XtRString, const_cast< char* >( "\t " ) },
		{ const_cast< char* >( "wordCharSet" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, WordCharSet ), XtRString, const_cast< char* >( "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_" ) },
		{ const_cast< char* >( "dropFileOpenMethod" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, DropFileOpenMethod ), XtRString, const_cast< char* >( "Current" ) },
		{ const_cast< char* >( "mouseButton2Function" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, Btn2Func ), XtRString, const_cast< char* >( "Left" ) },
		{ const_cast< char* >( "maxUndoCount" ), XtCLength, XtRInt, sizeof( int ), XtOffset( tagAppData*, MaxUndoCount ), XtRString, const_cast< char* >( "100" ) },
		{ const_cast< char* >( "hScrollAt" ), XtCWidth, XtRInt, sizeof( unsigned int ), XtOffset( tagAppData*, HScrollAt ), XtRString, const_cast< char* >( "50" ) },
		{ const_cast< char* >( "clipboardEncode" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, ClipboardEncode ), XtRString, const_cast< char* >( "ASCII" ) },
		{ const_cast< char* >( "showPrecessingDlgDelay" ), XtCInterval, XtRInt, sizeof( int ), XtOffset( tagAppData*, ShowPrecessingDlgDelay ), XtRString, const_cast< char* >( "1000" ) },
		{ const_cast< char* >( "windowWidth" ), XtCWidth, XtRInt, sizeof( int ), XtOffset( tagAppData*, WindowWidth ), XtRString, const_cast< char* >( "640" ) },
		{ const_cast< char* >( "windowHeight" ), XtCHeight, XtRInt, sizeof( int ), XtOffset( tagAppData*, WindowHeight ), XtRString, const_cast< char* >( "480" ) },
		{ const_cast< char* >( "scrollMouseSpeed" ), XtCLength, XtRInt, sizeof( int ), XtOffset( tagAppData*, ScrollMouseSpeed ), XtRString, const_cast< char* >( "3" ) },
		{ const_cast< char* >( "iconImageName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, IconImageName ), XtRString, const_cast< char* >( "" ) },
		{ const_cast< char* >( "extendInfoColumnCount" ), XtCWidth, XtRInt, sizeof( int ), XtOffset( tagAppData*, ExInfoColumnCount ), XtRString, const_cast< char* >( "0" ) },
		{ const_cast< char* >( "extendInfoColumnWidth" ), XtCWidth, XtRInt, sizeof( int ), XtOffset( tagAppData*, ExInfoColumnWidth ), XtRString, const_cast< char* >( "5" ) },
		{ const_cast< char* >( "extendInfoColumnColor" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, ExInfoColumnColor ), XtRString, const_cast< char* >( "" ) },
		{ const_cast< char* >( "drawSeparatorLine" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, DrawSeparatorLine ), XtRString, const_cast< char* >( "False" ) },
		{ const_cast< char* >( "separatorLineColor" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, SeparatorLineColor ), XtRString, const_cast< char* >( "gray" ) },
		{ const_cast< char* >( "autoSaveInterval" ), XtCInterval, XtRInt, sizeof( int ), XtOffset( tagAppData*, AutoSaveInterval ), XtRString, const_cast< char* >( "0" ) },
		{ const_cast< char* >( "autoSaveNewFileMethod" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, AutoSaveNewFileMethod ), XtRString, const_cast< char* >( "Nothig" ) },
		{ const_cast< char* >( "langTypeEnableMaxSize" ), XtCLength, XtRInt, sizeof( int ), XtOffset( tagAppData*, LangTypeEnableMaxSize ), XtRString, const_cast< char* >( "524288" ) },
		{ const_cast< char* >( "CPP_FileExt" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, CPP_FileExt ), XtRString, const_cast< char* >( "c,cc,cpp,cxx,h,hpp" ) },
		{ const_cast< char* >( "JAVA_FileExt" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, JAVA_FileExt ), XtRString, const_cast< char* >( "java" ) },
		{ const_cast< char* >( "COBOL_FileExt" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, COBOL_FileExt ), XtRString, const_cast< char* >( "cob,cbl,cobol" ) },
		{ const_cast< char* >( "JS_FileExt" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, JS_FileExt ), XtRString, const_cast< char* >( "js" ) },
		{ const_cast< char* >( "VBS_FileExt" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, VBS_FileExt ), XtRString, const_cast< char* >( "vbs" ) },
		{ const_cast< char* >( "CS_FileExt" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, CS_FileExt ), XtRString, const_cast< char* >( "cs" ) },
		{ const_cast< char* >( "CPP_NormalTextF_ColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, CPP_NormalTextF_ColorName ), XtRString, const_cast< char* >( "Black" ) },
		{ const_cast< char* >( "CPP_KeywordF_ColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, CPP_KeywordF_ColorName ), XtRString, const_cast< char* >( "Blue" ) },
		{ const_cast< char* >( "CPP_CommentF_ColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, CPP_CommentF_ColorName ), XtRString, const_cast< char* >( "green4" ) },
		{ const_cast< char* >( "CPP_SringF_ColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, CPP_SringF_ColorName ), XtRString, const_cast< char* >( "red4" ) },
		{ const_cast< char* >( "JAVA_NormalTextF_ColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, JAVA_NormalTextF_ColorName ), XtRString, const_cast< char* >( "Black" ) },
		{ const_cast< char* >( "JAVA_KeywordF_ColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, JAVA_KeywordF_ColorName ), XtRString, const_cast< char* >( "Blue" ) },
		{ const_cast< char* >( "JAVA_CommentF_ColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, JAVA_CommentF_ColorName ), XtRString, const_cast< char* >( "green4" ) },
		{ const_cast< char* >( "JAVA_SringF_ColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, JAVA_SringF_ColorName ), XtRString, const_cast< char* >( "red4" ) },
		{ const_cast< char* >( "COBOL_NormalTextF_ColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, COBOL_NormalTextF_ColorName ), XtRString, const_cast< char* >( "Black" ) },
		{ const_cast< char* >( "COBOL_KeywordF_ColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, COBOL_KeywordF_ColorName ), XtRString, const_cast< char* >( "Blue" ) },
		{ const_cast< char* >( "COBOL_CommentF_ColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, COBOL_CommentF_ColorName ), XtRString, const_cast< char* >( "green4" ) },
		{ const_cast< char* >( "COBOL_SringF_ColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, COBOL_SringF_ColorName ), XtRString, const_cast< char* >( "red4" ) },
		{ const_cast< char* >( "COBOL_SequenceNumberF_ColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, COBOL_SequenceNumberF_ColorName ), XtRString, const_cast< char* >( "DarkGrey" ) },
		{ const_cast< char* >( "JS_NormalTextF_ColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, JS_NormalTextF_ColorName ), XtRString, const_cast< char* >( "Black" ) },
		{ const_cast< char* >( "JS_KeywordF_ColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, JS_KeywordF_ColorName ), XtRString, const_cast< char* >( "Blue" ) },
		{ const_cast< char* >( "JS_CommentF_ColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, JS_CommentF_ColorName ), XtRString, const_cast< char* >( "green4" ) },
		{ const_cast< char* >( "JS_SringF_ColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, JS_SringF_ColorName ), XtRString, const_cast< char* >( "red4" ) },
		{ const_cast< char* >( "VBS_NormalTextF_ColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, VBS_NormalTextF_ColorName ), XtRString, const_cast< char* >( "Black" ) },
		{ const_cast< char* >( "VBS_KeywordF_ColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, VBS_KeywordF_ColorName ), XtRString, const_cast< char* >( "Blue" ) },
		{ const_cast< char* >( "VBS_CommentF_ColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, VBS_CommentF_ColorName ), XtRString, const_cast< char* >( "green4" ) },
		{ const_cast< char* >( "VBS_SringF_ColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, VBS_SringF_ColorName ), XtRString, const_cast< char* >( "red4" ) },
		{ const_cast< char* >( "CS_NormalTextF_ColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, CS_NormalTextF_ColorName ), XtRString, const_cast< char* >( "Black" ) },
		{ const_cast< char* >( "CS_KeywordF_ColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, CS_KeywordF_ColorName ), XtRString, const_cast< char* >( "Blue" ) },
		{ const_cast< char* >( "CS_CommentF_ColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, CS_CommentF_ColorName ), XtRString, const_cast< char* >( "green4" ) },
		{ const_cast< char* >( "CS_SringF_ColorName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, CS_SringF_ColorName ), XtRString, const_cast< char* >( "red4" ) },
		{ const_cast< char* >( "pluginConfigFileName" ), XtCString, XtRString, sizeof( const char* ), XtOffset( tagAppData*, PluginConfigFileName ), XtRString, const_cast< char* >( "" ) },
	};

	// ꥽ͤ
	XtGetApplicationResources( m_Widget, &AppData, resources, XtNumber( resources ), NULL, 0 );

	// ѿ˼
	OkStr.SetStr( AppData.OkString );
	CancelStr.SetStr( AppData.CancelString );
	YesStr.SetStr( AppData.YesString );
	NoStr.SetStr( AppData.NoString );
	NewFileWndTitleStr = AppData.NewFileWndTitle;
	FailToConvertCharSet.SetStr( AppData.FailToConvertCharSet );
	BrokenLineMsg.SetStr( AppData.BrokenLineMsg );
	DeviceIOErrorMsg.SetStr( AppData.DeviceIOErrorMsg );
	TextEncodeErrorMsg.SetStr( AppData.TextEncodeErrorMsg );
	IOErrorMsg.SetStr( AppData.IOErrorMsg );
	OutOfMemoryErrorMsg.SetStr( AppData.OutOfMemoryErrorMsg );
	FileNameIsNotInputtedErrorMsg.SetStr( AppData.FileNameIsNotInputtedErrorMsg );
	UnexpectedErrorMsg.SetStr( AppData.UnexpectedErrorMsg );
	FileIsNotExistMsg.SetStr( AppData.FileIsNotExistMsg );
	SpecifiedNameIsDirMsg.SetStr( AppData.SpecifiedNameIsDirMsg );
	FaultFileOpenMsg.SetStr( AppData.FaultFileOpenMsg );
	PreservationCheckMsg.SetStr( AppData.PreservationCheckMsg );
	RunScriptEAGAINMsg.SetStr( AppData.RunScriptEAGAINMsg );
	RunScriptEINTRMsg.SetStr( AppData.RunScriptEINTRMsg );
	RunScriptENOMEMMsg.SetStr( AppData.RunScriptENOMEMMsg );
	RunScriptCancelOpenMsg.SetStr( AppData.RunScriptCancelOpenMsg );
	RunScriptCancelSaveMsg.SetStr( AppData.RunScriptCancelSaveMsg );
	if ( strcasecmp( AppData.ShowCancelOpenMsg, "True" ) == 0 )
		ShowCancelOpenMsg = true;
	else
		ShowCancelOpenMsg = false;
	if ( strcasecmp( AppData.ShowCancelSaveMsg, "True" ) == 0 )
		ShowCancelSaveMsg = true;
	else
		ShowCancelSaveMsg = false;
	FaultLoadPluginLibraryMsg = AppData.FaultLoadPluginLibraryMsg;
	FaultGetPluginFunctionMsg = AppData.FaultGetPluginFunctionMsg;
	FailToGetPID.SetStr( AppData.FailToGetPID );
	FailToCreateChildProcess.SetStr( AppData.FailToCreateChildProcess );
	FileOpenDlgTitle.SetStr( AppData.FileOpenDlgTitle );
	FileSaveDlgTitle.SetStr( AppData.FileSaveDlgTitle );

	// 顼ޥåפ
	wColormap = DefaultColormap( pDisplay, DefaultScreen( pDisplay ) );
	mapPixelCash.clear();

	// ̾顢Pixelͤ
	NormalTextF_Color = GetColorByName( AppData.NormalTextF_ColorName, black, wColormap, pDisplay, &mapPixelCash );
	NormalTextB_Color = GetColorByName( AppData.NormalTextB_ColorName, white, wColormap, pDisplay, &mapPixelCash );
	SelectedTextF_Color = GetColorByName( AppData.SelectedTextF_ColorName, white, wColormap, pDisplay, &mapPixelCash );
	SelectedTextB_Color = GetColorByName( AppData.SelectedTextB_ColorName, black, wColormap, pDisplay, &mapPixelCash );
	BackgroundColor = GetColorByName( AppData.BackgroundColorName, white, wColormap, pDisplay, &mapPixelCash );
	CursorColor = GetColorByName( AppData.CursorColorName, white, wColormap, pDisplay, &mapPixelCash );
	PreEditTextF_Color = GetColorByName( AppData.PreEditTextF_ColorName, black, wColormap, pDisplay, &mapPixelCash );
	PreEditTextB_Color = GetColorByName( AppData.PreEditTextB_ColorName, white, wColormap, pDisplay, &mapPixelCash );

	FontName = AppData.FontName;
	TabWidth = AppData.TabWidth;
	if ( TabWidth <= 0 ) TabWidth = 1;
	if ( TabWidth > 100 ) TabWidth = 100;

	CantFindTextMsg.SetStr( AppData.CantFindTextMsg );
	JPEXT_MBStoWCS( AppData.WrongRegexPatternMsg, &WrongRegexPatternMsg );
	JPEXT_MBStoWCS( AppData.WRP_EofNotAnticipated, &WRP_EofNotAnticipated );
	JPEXT_MBStoWCS( AppData.WRP_OutOfMemory, &WRP_OutOfMemory );
	JPEXT_MBStoWCS( AppData.WRP_UncertainChar, &WRP_UncertainChar );
	JPEXT_MBStoWCS( AppData.WRP_ZeroLengthPattern, &WRP_ZeroLengthPattern );
	JPEXT_MBStoWCS( AppData.WRP_Unexpected, &WRP_Unexpected );

	AppTitle = AppData.AppTitle;

	// ʸˡ
	if ( strcasecmp( AppData.CharSelType, "left" ) == 0 )
		CharSelType = CST_LEFT;
	else
		if ( strcasecmp( AppData.CharSelType, "right" ) == 0 )
			CharSelType = CST_RIGHT;
		else
			CharSelType = CST_CENTER;

	if ( AppData.LeftPadding < 0 ) AppData.LeftPadding = 0;
	if ( AppData.LeftPadding > 1024 ) AppData.LeftPadding = 1024;
	if ( AppData.RightPadding < 0 ) AppData.RightPadding = 0;
	if ( AppData.RightPadding > 1024 ) AppData.RightPadding = 1024;
	LeftPadding = AppData.LeftPadding;
	RightPadding = AppData.RightPadding;
	LineNumberOrigin = AppData.LineNumberOrigin;
	LineGapWidth = AppData.LineGapWidth;

	// η׻ˡ
	if ( strcasecmp( AppData.TabWidthCalculationMethod, "Fix" ) == 0 )
		TabWidthCalculationMethod = TWCM_FIX;
	else
		TabWidthCalculationMethod = TWCM_FLEX;

	if ( !JPEXT_MBStoWCS( AppData.TabString, &TabString ) )
		TabString =L"\t";
	ProcUpScript = AppData.ProcUpScript;
	FileReadScript = AppData.FileReadScript;
	FileAfterReadScript = AppData.FileAfterReadScript;
	FileBeforeWriteScript = AppData.FileBeforeWriteScript;
	FileWriteScript = AppData.FileWriteScript;
	FileCloseScript = AppData.FileCloseScript;
	ProcDownScript = AppData.ProcDownScript;

	if ( strcasecmp( AppData.AutoIndent, "True" ) == 0 )
		AutoIndent = true;
	else
		AutoIndent = false;
	JPEXT_MBStoWCS( AppData.IndentChar, &IndentChar );
	JPEXT_MBStoWCS( AppData.WordCharSet, &WordCharSet );

	if ( strcasecmp( AppData.DropFileOpenMethod, "New" ) == 0 )
		DropFileOpenMethod = DFOM_NEW_WINDOW;
	else
		DropFileOpenMethod = DFOM_CURRENT_WINDOW;

	if ( strcasecmp( AppData.Btn2Func, "Left" ) == 0 )
		Btn2Func = B2F_LEFT;
	else {
		if ( strcasecmp( AppData.Btn2Func, "Left+Ctrl" ) == 0 )
			Btn2Func = B2F_LEFT_CTRL;
		else
			Btn2Func = B2F_LEFT_SHIFT;
	}
	MaxUndoCount = AppData.MaxUndoCount;
	if ( MaxUndoCount <= 0 ) MaxUndoCount = 1;
	if ( MaxUndoCount > INT_MAX ) MaxUndoCount = INT_MAX;
	HScrollAt = AppData.HScrollAt;
	if ( HScrollAt <= 0 ) HScrollAt = 1;
	ClipboardEncode = AppData.ClipboardEncode;
	ShowPrecessingDlgDelay = AppData.ShowPrecessingDlgDelay;
	if ( ShowPrecessingDlgDelay < 0 ) ShowPrecessingDlgDelay = 0;
	WindowWidth = AppData.WindowWidth;
	WindowHeight = AppData.WindowHeight;
	ScrollMouseSpeed = AppData.ScrollMouseSpeed;
	if ( ScrollMouseSpeed < 0 ) ScrollMouseSpeed = 0;
	if ( ScrollMouseSpeed > 10000 ) ScrollMouseSpeed = 10000;
	IconImageName = AppData.IconImageName;

	ExInfoColumnCount = AppData.ExInfoColumnCount;
	if ( ExInfoColumnCount < 0 ) ExInfoColumnCount = 0;
	if ( ExInfoColumnCount >= 10000 ) ExInfoColumnCount = 9999;
	ExInfoColumnWidth = AppData.ExInfoColumnWidth;
	if ( ExInfoColumnWidth <= 0 ) ExInfoColumnWidth = 1;
	if ( ExInfoColumnWidth >= 10000 ) ExInfoColumnWidth = 9999;

	pExInfoColumnColor = (Pixel*)malloc( sizeof( Pixel ) * ExInfoColumnCount );
	if ( NULL == pExInfoColumnColor ) {
		// ꤬ݤǤʤä顢
		ExInfoColumnCount = 0;
	}
	else {
		// ޤǶڤ줿̾
		const char *wp = AppData.ExInfoColumnColor;
		const char *hp = wp;
		i = 0;
		while ( (*wp) && i < ExInfoColumnCount ) {
			for (; (*wp) && (*wp) != ','; wp++ );
			string wstr( hp, wp - hp );
			pExInfoColumnColor[i] = GetColorByName( wstr.c_str(), black, wColormap, pDisplay, &mapPixelCash );
			if ( (*wp) ) wp++;
			hp = wp;
			i++;
		}
		for (; i < ExInfoColumnCount; i++ )
			pExInfoColumnColor[i] = black;
	}
	if ( strcasecmp( AppData.DrawSeparatorLine, "True" ) == 0 )
		DrawSeparatorLine = true;
	else
		DrawSeparatorLine = false;
	SeparatorLineColor = GetColorByName( AppData.SeparatorLineColor, black, wColormap, pDisplay, &mapPixelCash );
	AutoSaveInterval = AppData.AutoSaveInterval;
	if ( AutoSaveInterval < 0 ) AutoSaveInterval = 0;
	if ( AutoSaveInterval > 200000000 ) AutoSaveInterval = 200000000;
	if ( strcasecmp( AppData.AutoSaveNewFileMethod, "Nothig" ) == 0 )
		AutoSaveNewFileMethod = ASNW_NOTHING;
	else
		AutoSaveNewFileMethod = ASNW_ASC_NAME;


	if ( AppData.LangTypeEnableMaxSize >= 0 )
		LangTypeEnableMaxSize = AppData.LangTypeEnableMaxSize;
	else
		LangTypeEnableMaxSize = 0;
	CPP_FileExt = AppData.CPP_FileExt;
	JAVA_FileExt = AppData.JAVA_FileExt;
	COBOL_FileExt = AppData.COBOL_FileExt;
	JS_FileExt = AppData.JS_FileExt;
	VBS_FileExt = AppData.VBS_FileExt;
	CS_FileExt = AppData.CS_FileExt;

	CPP_NormalTextF_Color = GetColorByName( AppData.CPP_NormalTextF_ColorName, black, wColormap, pDisplay, &mapPixelCash );
	CPP_KeywordF_Color = GetColorByName( AppData.CPP_KeywordF_ColorName, black, wColormap, pDisplay, &mapPixelCash );
	CPP_CommentF_Color = GetColorByName( AppData.CPP_CommentF_ColorName, black, wColormap, pDisplay, &mapPixelCash );
	CPP_SringF_Color = GetColorByName( AppData.CPP_SringF_ColorName, black, wColormap, pDisplay, &mapPixelCash );
	JAVA_NormalTextF_Color = GetColorByName( AppData.JAVA_NormalTextF_ColorName, black, wColormap, pDisplay, &mapPixelCash );
	JAVA_KeywordF_Color = GetColorByName( AppData.JAVA_KeywordF_ColorName, black, wColormap, pDisplay, &mapPixelCash );
	JAVA_CommentF_Color = GetColorByName( AppData.JAVA_CommentF_ColorName, black, wColormap, pDisplay, &mapPixelCash );
	JAVA_SringF_Color = GetColorByName( AppData.JAVA_SringF_ColorName, black, wColormap, pDisplay, &mapPixelCash );
	COBOL_NormalTextF_Color = GetColorByName( AppData.COBOL_NormalTextF_ColorName, black, wColormap, pDisplay, &mapPixelCash );
	COBOL_KeywordF_Color = GetColorByName( AppData.COBOL_KeywordF_ColorName, black, wColormap, pDisplay, &mapPixelCash );
	COBOL_CommentF_Color = GetColorByName( AppData.COBOL_CommentF_ColorName, black, wColormap, pDisplay, &mapPixelCash );
	COBOL_SringF_Color = GetColorByName( AppData.COBOL_SringF_ColorName, black, wColormap, pDisplay, &mapPixelCash );
	COBOL_SequenceNumberF_Color = GetColorByName( AppData.COBOL_SequenceNumberF_ColorName, black, wColormap, pDisplay, &mapPixelCash );
	JS_NormalTextF_Color = GetColorByName( AppData.JS_NormalTextF_ColorName, black, wColormap, pDisplay, &mapPixelCash );
	JS_KeywordF_Color = GetColorByName( AppData.JS_KeywordF_ColorName, black, wColormap, pDisplay, &mapPixelCash );
	JS_CommentF_Color = GetColorByName( AppData.JS_CommentF_ColorName, black, wColormap, pDisplay, &mapPixelCash );
	JS_SringF_Color = GetColorByName( AppData.JS_SringF_ColorName, black, wColormap, pDisplay, &mapPixelCash );
	VBS_NormalTextF_Color = GetColorByName( AppData.VBS_NormalTextF_ColorName, black, wColormap, pDisplay, &mapPixelCash );
	VBS_KeywordF_Color = GetColorByName( AppData.VBS_KeywordF_ColorName, black, wColormap, pDisplay, &mapPixelCash );
	VBS_CommentF_Color = GetColorByName( AppData.VBS_CommentF_ColorName, black, wColormap, pDisplay, &mapPixelCash );
	VBS_SringF_Color = GetColorByName( AppData.VBS_SringF_ColorName, black, wColormap, pDisplay, &mapPixelCash );
	CS_NormalTextF_Color = GetColorByName( AppData.CS_NormalTextF_ColorName, black, wColormap, pDisplay, &mapPixelCash );
	CS_KeywordF_Color = GetColorByName( AppData.CS_KeywordF_ColorName, black, wColormap, pDisplay, &mapPixelCash );
	CS_CommentF_Color = GetColorByName( AppData.CS_CommentF_ColorName, black, wColormap, pDisplay, &mapPixelCash );
	CS_SringF_Color = GetColorByName( AppData.CS_SringF_ColorName, black, wColormap, pDisplay, &mapPixelCash );
	PluginConfigFileName = AppData.PluginConfigFileName;
}

const CCompoundStr& CConfigInfo::RefOkStr() const
{
	return OkStr;
}

const CCompoundStr& CConfigInfo::RefCancelStr() const
{
	return CancelStr;
}

const CCompoundStr& CConfigInfo::RefYesStr() const
{
	return YesStr;
}

const CCompoundStr& CConfigInfo::RefNoStr() const
{
	return NoStr;
}

const string& CConfigInfo::RefNewFileWndTitleStr() const
{
	return NewFileWndTitleStr;
}

const CCompoundStr& CConfigInfo::RefFailToConvertCharSet() const
{
	return FailToConvertCharSet;
}

const CCompoundStr& CConfigInfo::RefBrokenLineMsg() const
{
	return BrokenLineMsg;
}

const CCompoundStr& CConfigInfo::RefIOErrorMsg( int ErrorNo ) const
{
	switch ( ErrorNo ) {
	case EIO:
		return DeviceIOErrorMsg;
	case ENOMEM:
		return OutOfMemoryErrorMsg;
	case EILSEQ:
		return TextEncodeErrorMsg;
	default:
		return IOErrorMsg;
	}
}

const CCompoundStr& CConfigInfo::RefOutOfMemoryErrorMsg() const
{
	return OutOfMemoryErrorMsg;
}

const CCompoundStr& CConfigInfo::RefFileNameIsNotInputtedErrorMsg() const
{
	return FileNameIsNotInputtedErrorMsg;
}

const CCompoundStr& CConfigInfo::RefUnexpectedErrorMsg() const
{
	return UnexpectedErrorMsg;
}	

const CCompoundStr& CConfigInfo::RefFileIsNotExistMsg() const
{
	return FileIsNotExistMsg;
}

const CCompoundStr& CConfigInfo::RefSpecifiedNameIsDirMsg() const
{
	return SpecifiedNameIsDirMsg;
}

const CCompoundStr& CConfigInfo::RefFaultFileOpenMsg() const
{
	return FaultFileOpenMsg;
}

const CCompoundStr& CConfigInfo::RefPreservationCheckMsg() const
{
	return PreservationCheckMsg;
}

const CCompoundStr& CConfigInfo::RefRunScriptEAGAINMsg() const
{
	return RunScriptEAGAINMsg;
}

const CCompoundStr& CConfigInfo::RefRunScriptEINTRMsg() const
{
	return RunScriptEINTRMsg;
}

const CCompoundStr& CConfigInfo::RefRunScriptENOMEMMsg() const
{
	return RunScriptENOMEMMsg;
}

const CCompoundStr& CConfigInfo::RefRunScriptCancelOpenMsg() const
{
	return RunScriptCancelOpenMsg;
}

const CCompoundStr& CConfigInfo::RefRunScriptCancelSaveMsg() const
{
	return RunScriptCancelSaveMsg;
}

// systemؿ¹ԤȤerrnoбå
const CCompoundStr& CConfigInfo::RefRunScriptErrnoMsg( int e ) const
{
	switch ( e ) {
	case EAGAIN:
		return RefRunScriptEAGAINMsg();
	case EINTR:
		return RefRunScriptEINTRMsg();
	case ENOMEM:
		return RefRunScriptENOMEMMsg();
	}
	return RefUnexpectedErrorMsg();
}

bool CConfigInfo::GetShowCancelOpenMsg() const
{
	return ShowCancelOpenMsg;
}

bool CConfigInfo::GetShowCancelSaveMsg() const
{
	return ShowCancelSaveMsg;
}

bool CConfigInfo::GetFaultLoadPluginLibraryMsg( CCompoundStr *pCS, const string &rLibraryName, const char* pReason ) const
{
	const char *p[2] = { rLibraryName.c_str(), pReason };
	string w = CreateMsgString< string, char >( FaultLoadPluginLibraryMsg, 2, p );
	pCS->SetStr( w.c_str() );
	return true;
}

bool CConfigInfo::GetFaultGetPluginFunctionMsg( CCompoundStr *pCS, const string &rLibraryName, const string &rFunctionName, const char* pReason ) const
{
	const char *v[] = { rLibraryName.c_str(), rFunctionName.c_str(), pReason };
	string w = CreateMsgString< string, char >( FaultGetPluginFunctionMsg, 3, v );
	pCS->SetStr( w.c_str() );
	return true;
}

const CCompoundStr& CConfigInfo::RefFailToGetPID() const
{
	return FailToGetPID;
}

const CCompoundStr& CConfigInfo::RefFailToCreateChildProcess() const
{
	return FailToCreateChildProcess;
}

const CCompoundStr& CConfigInfo::RefFileOpenDlgTitle() const
{
	return FileOpenDlgTitle;
}

const CCompoundStr& CConfigInfo::RefFileSaveDlgTitle() const
{
	return FileSaveDlgTitle;
}

Pixel CConfigInfo::RefNormalTextF_Color() const
{
	return NormalTextF_Color;
}

Pixel CConfigInfo::RefNormalTextB_Color() const
{
	return NormalTextB_Color;
}

Pixel CConfigInfo::RefSelectedTextF_Color() const
{
	return SelectedTextF_Color;
}

Pixel CConfigInfo::RefSelectedTextB_Color() const
{
	return SelectedTextB_Color;
}

Pixel CConfigInfo::RefBackgroundColor() const
{
	return BackgroundColor;
}

Pixel CConfigInfo::RefCursorColor() const
{
	return CursorColor;
}

Pixel CConfigInfo::RefPreEditTextF_Color() const
{
	return PreEditTextF_Color;
}

Pixel CConfigInfo::RefPreEditTextB_Color() const
{
	return PreEditTextB_Color;
}

const string& CConfigInfo::RefFontName() const
{
	return FontName;
}

int CConfigInfo::RefTabWidth() const
{
	return TabWidth;
}

const CCompoundStr& CConfigInfo::RefCantFindTextMsg() const
{
	return CantFindTextMsg;
}

bool CConfigInfo::GetWrongRegexPatternMsg( CCompoundStr *pCS, const wstring &msg, int idx ) const
{
	wstring wStr;
	wchar_t wBuf[ 16 ];
	const wchar_t *v[2];

	// å
	swprintf( wBuf, 16, L"%d\0", idx );
	v[0] = msg.c_str();
	v[1] = wBuf;
	pCS->SetStr( CreateMsgString( WrongRegexPatternMsg, 2, v ).c_str() );
	return true;
}

const wstring& CConfigInfo::RefWRP_EofNotAnticipated() const
{
	return WRP_EofNotAnticipated;
}

const wstring& CConfigInfo::RefWRP_OutOfMemory() const
{
	return WRP_OutOfMemory;
}

const wstring& CConfigInfo::RefWRP_UncertainChar() const
{
	return WRP_UncertainChar;
}

const wstring& CConfigInfo::RefWRP_ZeroLengthPattern() const
{
	return WRP_ZeroLengthPattern;
}

const wstring& CConfigInfo::RefWRP_Unexpected() const
{
	return WRP_Unexpected;
}

const string& CConfigInfo::RefAppTitle() const
{
	return AppTitle;
}

enumCHARSELTYPE CConfigInfo::GetCharSelType() const
{
	return CharSelType;
}

unsigned int CConfigInfo::GetLeftPadding() const
{
	return LeftPadding;
}

unsigned int CConfigInfo::GetRightPadding() const
{
	return LeftPadding;
}

int CConfigInfo::GetLineNumberOrigin() const
{
	return LineNumberOrigin;
}

int CConfigInfo::GetLineGapWidth() const
{
	return LineGapWidth;
}

enumTABWIDTHCALCMETHOD CConfigInfo::GetTabWidthCalculationMethod() const
{
	return TabWidthCalculationMethod;
}

const wstring& CConfigInfo::RefTabString() const
{
	return TabString;
}

const string& CConfigInfo::RefProcUpScript() const
{
	return ProcUpScript;
}

const string& CConfigInfo::RefFileReadScript() const
{
	return FileReadScript;
}

const string& CConfigInfo::RefFileAfterReadScript() const
{
	return FileAfterReadScript;
}

const string& CConfigInfo::RefFileBeforeWriteScript() const
{
	return FileBeforeWriteScript;
}

const string& CConfigInfo::RefFileWriteScript() const
{
	return FileWriteScript;
}

const string& CConfigInfo::RefFileCloseScript() const
{
	return FileCloseScript;
}

const string& CConfigInfo::RefProcDownScript() const
{
	return ProcDownScript;
}

bool CConfigInfo::GetAutoIndent() const
{
	return AutoIndent;
}

const wstring& CConfigInfo::RefIndentChar() const
{
	return IndentChar;
}

const wstring& CConfigInfo::RefWordCharSet() const
{
	return WordCharSet;
}

enumDROPFILEOPENMETHOD CConfigInfo::GetDropFileOpenMethod() const
{
	return DropFileOpenMethod;
}

enumBTN2FUNC CConfigInfo::GetBtn2Func() const
{
	return Btn2Func;
}

int CConfigInfo::GetMaxUndoCount() const
{
	return MaxUndoCount;
}

unsigned int CConfigInfo::GetHScrollAt() const
{
	return HScrollAt;
}

const string& CConfigInfo::RefClipboardEncode() const
{
	return ClipboardEncode;
}

int CConfigInfo::GetShowPrecessingDlgDelay() const
{
	return ShowPrecessingDlgDelay;
}

int CConfigInfo::GetWindowWidth() const
{
	return WindowWidth;
}

int CConfigInfo::GetWindowHeight() const
{
	return WindowHeight;
}

int CConfigInfo::GetScrollMouseSpeed() const
{
	return ScrollMouseSpeed;
}

const string& CConfigInfo::RefIconImageName() const
{
	return IconImageName;
}

int CConfigInfo::GetExInfoColumnCount() const
{
	return ExInfoColumnCount;
}

int CConfigInfo::GetExInfoColumnWidth() const
{
	return ExInfoColumnWidth;
}

Pixel CConfigInfo::RefExInfoColumnColor( int idx ) const
{
	assert( idx >= 0 && idx < GetExInfoColumnCount() );
	return pExInfoColumnColor[idx];
}

bool CConfigInfo::GetDrawSeparatorLine() const
{
	return DrawSeparatorLine;
}

Pixel CConfigInfo::RefSeparatorLineColor() const
{
	return SeparatorLineColor;
}

int CConfigInfo::GetAutoSaveInterval() const
{
	return AutoSaveInterval;
}

enumAUTOSAVE_NEWFILE CConfigInfo::GetAutoSaveNewFileMethod() const
{
	return AutoSaveNewFileMethod;
}


unsigned int CConfigInfo::GetLangTypeEnableMaxSize() const
{
	return LangTypeEnableMaxSize;
}

const string& CConfigInfo::RefCPP_FileExt() const
{
	return CPP_FileExt;
}

const string& CConfigInfo::RefJAVA_FileExt() const
{
	return JAVA_FileExt;
}

const string& CConfigInfo::RefCOBOL_FileExt() const
{
	return COBOL_FileExt;
}

const string& CConfigInfo::RefJS_FileExt() const
{
	return JS_FileExt;
}

const string& CConfigInfo::RefVBS_FileExt() const
{
	return VBS_FileExt;
}

const string& CConfigInfo::RefCS_FileExt() const
{
	return CS_FileExt;
}

Pixel CConfigInfo::RefCPP_NormalTextF_Color() const
{
	return CPP_NormalTextF_Color;
}

Pixel CConfigInfo::RefCPP_KeywordF_Color() const
{
	return CPP_KeywordF_Color;
}

Pixel CConfigInfo::RefCPP_CommentF_Color() const
{
	return CPP_CommentF_Color;
}

Pixel CConfigInfo::RefCPP_SringF_Color() const
{
	return CPP_SringF_Color;
}

Pixel CConfigInfo::RefJAVA_NormalTextF_Color() const
{
	return JAVA_NormalTextF_Color;
}

Pixel CConfigInfo::RefJAVA_KeywordF_Color() const
{
	return JAVA_KeywordF_Color;
}

Pixel CConfigInfo::RefJAVA_CommentF_Color() const
{
	return JAVA_CommentF_Color;
}

Pixel CConfigInfo::RefJAVA_SringF_Color() const
{
	return JAVA_SringF_Color;
}

Pixel CConfigInfo::RefCOBOL_NormalTextF_Color() const
{
	return COBOL_NormalTextF_Color;
}

Pixel CConfigInfo::RefCOBOL_KeywordF_Color() const
{
	return COBOL_KeywordF_Color;
}

Pixel CConfigInfo::RefCOBOL_CommentF_Color() const
{
	return COBOL_CommentF_Color;
}

Pixel CConfigInfo::RefCOBOL_SringF_Color() const
{
	return COBOL_SringF_Color;
}

Pixel CConfigInfo::RefCOBOL_SequenceNumberF_Color() const
{
	return COBOL_SequenceNumberF_Color;
}

Pixel CConfigInfo::RefJS_NormalTextF_Color() const
{
	return JS_NormalTextF_Color;
}

Pixel CConfigInfo::RefJS_KeywordF_Color() const
{
	return JS_KeywordF_Color;
}

Pixel CConfigInfo::RefJS_CommentF_Color() const
{
	return JS_CommentF_Color;
}

Pixel CConfigInfo::RefJS_SringF_Color() const
{
	return JS_SringF_Color;
}

Pixel CConfigInfo::RefVBS_NormalTextF_Color() const
{
	return VBS_NormalTextF_Color;
}

Pixel CConfigInfo::RefVBS_KeywordF_Color() const
{
	return VBS_KeywordF_Color;
}

Pixel CConfigInfo::RefVBS_CommentF_Color() const
{
	return VBS_CommentF_Color;
}

Pixel CConfigInfo::RefVBS_SringF_Color() const
{
	return VBS_SringF_Color;
}

Pixel CConfigInfo::RefCS_NormalTextF_Color() const
{
	return CS_NormalTextF_Color;
}

Pixel CConfigInfo::RefCS_KeywordF_Color() const
{
	return CS_KeywordF_Color;
}

Pixel CConfigInfo::RefCS_CommentF_Color() const
{
	return CS_CommentF_Color;
}

Pixel CConfigInfo::RefCS_SringF_Color() const
{
	return CS_SringF_Color;
}

const string& CConfigInfo::RefPluginConfigFileName() const
{
	return PluginConfigFileName;
}

// ̾Pixelͤ
Pixel CConfigInfo::GetColorByName(
	const string& rStr,
	Pixel DefColor,
	Colormap argCM,
	Display *pDisplay,
	map< string, Pixel > *pPixelCash ) const
{
	XColor screen_def;
	XColor exact_def;
	map< string, Pixel >::iterator itr;
	Pixel r;

	// å夵Ƥ뿧򸡺
	itr = pPixelCash->find( rStr );
	if ( itr != pPixelCash->end() )
		return itr->second;	// å夵ƤPixel֤ͤ

	if ( !XLookupColor( pDisplay, argCM, rStr.c_str(), &exact_def, &screen_def ) ) {
		r = DefColor;	// ԤʥǥեȤο֤
		goto EXIT_L;
	}

	// ԥͤ
	if ( !XAllocColor( pDisplay, argCM, &screen_def ) ) {
		r = DefColor;	// 
		goto EXIT_L;
	}

	r = screen_def.pixel;

EXIT_L:
	pPixelCash->insert( pair< string, Pixel >( rStr, r ) );	// åϿ
	return r;
}


