//////////////////////////////////////////////////////////////////////////////////////
// RegTNode.h
// SRegexNFAǻѤ롢ΡɤΥ饹
//////////////////////////////////////////////////////////////////////////////////////

#if !defined( REGTNODE_H_INCLUDED_ )
#define REGTNODE_H_INCLUDED_

#include <vector>

#include "InstanceMgr.h"

namespace N_SRegex {
namespace N_SRegexNode {

//////////////////////////////////////////////////////////////////////////////////////
// Ūʪ

// ܤΥΡ
template < typename T_Char, typename T_Ptn, typename T_Text >
class EpsilonNode
{
protected:
	typedef EpsilonNode< T_Char, T_Ptn, T_Text > T_EPSNODE;

public:
	EpsilonNode(){};

	// ΥΡɤɲ
	void AddNextNode( EpsilonNode *pNextNode )
	{
		vNextNode.push_back( pNextNode );
	};

	// ΥΡɤο
	int GetNextNodeCnt() const
	{
		return vNextNode.size();
	};

	// ޥå
	// ޥå鿿֤ޥåϰϤνü򼨤ݥ󥿤ppTerm֤
	virtual bool Match( T_Text pText, T_Text *ppTerm )
	{
		// ܤȤ롣˻Ƥ椭֤Τä齪λ
		// ̵ä鵶֤
		for ( int i = 0; i < GetNextNodeCnt() && !(*pIsInterrupted); i++ ) {
			if ( vNextNode[i]->Match( pText, ppTerm ) )
				return true;
		}
		return false;
	};

	// ߥե饰Υɥ쥹
	void SetInterruptedFlgAdr( volatile bool *p )
	{
		pIsInterrupted = p;
	}

private:
	std::vector< EpsilonNode* > vNextNode;	// ΥΡɤ

protected:
	volatile bool *pIsInterrupted;		// ߥե饰
};

// ʸȥޥåΡ
template < typename T_Char, typename T_Ptn, typename T_Text >
class StringNode : public EpsilonNode< T_Char, T_Ptn, T_Text >
{
public:
	StringNode() : T_EPSNODE(){};

	// ޥå
	virtual bool Match( T_Text pText, T_Text *ppTerm )
	{
		// ߤƤ鵶֤ƽλ
		if ( (*pIsInterrupted) ) return false;

		// ݻƤʸȤΥޥå
		for ( int i = 0; i < vString.size(); i++ ) {
			if ( !( vString[i] == (*pText) ) ) return false;
			++pText;
		}

		// ˿ʤ
		return T_EPSNODE::Match( pText, ppTerm );
	};

	// ʸꤹ
	void PushBackChar( T_Char c )
	{
		vString.push_back( c );
	};

protected:
	std::vector< T_Char > vString;	// оȤʸ
};

// ǤդΰʸȥޥåΡ
template < typename T_Char, typename T_Ptn, typename T_Text >
class ArbitCharNode : public EpsilonNode< T_Char, T_Ptn, T_Text >
{
public:
	ArbitCharNode() : T_EPSNODE(){};

	// ޥå
	virtual bool Match( T_Text pText, T_Text *ppTerm )
	{
		// ߤƤ鵶֤ƽλ
		if ( (*pIsInterrupted) ) return false;

		// pTextãƤϥޥåʤ
		if ( T_Char( '\0' ) == (*pText) ) return false;

		++pText;	// ʸ

		// ˿ʤ
		return T_EPSNODE::Match( pText, ppTerm );
	};
};

// ǽ֤򼨤Ρ
template < typename T_Char, typename T_Ptn, typename T_Text >
class TermNode : public EpsilonNode< T_Char, T_Ptn, T_Text >
{
public:
	TermNode() : T_EPSNODE(){};

	// ޥå
	virtual bool Match( T_Text pText, T_Text *ppTerm )
	{
		(*ppTerm) = pText;	// üΰ֤ppTermꤹ롣
		return true;	// ǽ֤ãΤǿ֤
	}
};

// ȤξݻΡ
template < typename T_Char, typename T_Ptn, typename T_Text >
class BackwardInfoNode : public EpsilonNode< T_Char, T_Ptn, T_Text >
{
public:
	BackwardInfoNode() : T_EPSNODE(), pRightNode( NULL ){};

	// ޥå
	virtual bool Match( T_Text pText, T_Text *ppTerm )
	{
		// ߤƤ鵶֤ƽλ
		if ( (*pIsInterrupted) ) return false;

		MatchPos = pText;
		// ʬ¦ΡɤǤä硢α¦Ρɤ롣
		if ( pRightNode ) pRightNode->MatchPos = pText;
		return T_EPSNODE::Match( pText, ppTerm );
	};

	T_Text GetMatchPos() const {
		return MatchPos;
	};

	T_Text GetRightPos() const {
		assert( NULL != pRightNode );
		return pRightNode->GetMatchPos();
	}

	void SetRightNode( BackwardInfoNode* argp )
	{
		pRightNode = argp;
	}
private:
	T_Text MatchPos;
	BackwardInfoNode *pRightNode;	// ¦γ̤ΥΡ
};

// Ȥη̤򻲾ȤΡ
template < typename T_Char, typename T_Ptn, typename T_Text >
class BackwardRefNode : public EpsilonNode< T_Char, T_Ptn, T_Text >
{
	typedef BackwardInfoNode< T_Char, T_Ptn, T_Text > T_BIN;
public:
	BackwardRefNode() : T_EPSNODE(), pBackwardInfo( NULL ){};

	// ޥå
	virtual bool Match( T_Text pText, T_Text *ppTerm )
	{
		T_Text s = pBackwardInfo->GetMatchPos();
		T_Text e = pBackwardInfo->GetRightPos();

		// pTextseϰϤ˥ޥå뤫ݤ
		while ( !( s == e ) && !(*pIsInterrupted) ) {
			if ( !( (*pText) == (*s) ) ) return false;
			++s;
			++pText;
		}
		// ߤƤ鵶֤ƽλ
		if ( (*pIsInterrupted) ) return false;

		return T_EPSNODE::Match( pText, ppTerm );
	}

	void SetpBackwardInfoNode( const T_BIN *argp )
	{
		pBackwardInfo = argp;
	}
private:
	const T_BIN *pBackwardInfo;	// ȤξݻΡ
};

//////////////////////////////////////////////////////////////////////////////////////
// ֤Ρ

// ֤ΥΡ
template < typename T_Char, typename T_Ptn, typename T_Text >
class LoopNode
{
	typedef EpsilonNode< T_Char, T_Ptn, T_Text > T_EPS;
	typedef InstanceMgr< T_EPS > T_INSMGR;

protected:
	typedef LoopNode< T_Char, T_Ptn, T_Text > T_LOOPNODE;

public:
	LoopNode() : pLoop( NULL ){};

	// 롼оݤΥΡɤꤹ롣
	bool SetLoopDest( T_EPS *pArgFirst, T_EPS *pArgLast, T_INSMGR *pInsMgr )
	{
		// ߡκǽ֥֥Ȥۤ
		T_EPS *pDummyTerm = CreateNode< TermNode< T_Char, T_Ptn, T_Text > >( pInsMgr );

		pArgLast->AddNextNode( pDummyTerm );
		pLoop = pArgFirst;
		return true;
	};

protected:
	T_EPS *pLoop;
};

// Ƥʷ֤
template < typename T_Char, typename T_Ptn, typename T_Text >
class LazyLoopNode :
	public EpsilonNode< T_Char, T_Ptn, T_Text >,
	public LoopNode< T_Char, T_Ptn, T_Text >
{
public:
	LazyLoopNode() : T_EPSNODE(), T_LOOPNODE(){};

	// ޥå
	virtual bool Match( T_Text pText, T_Text *ppTerm )
	{
		do {
			// ³Υޥåߤ롣
			if ( T_EPSNODE::Match( pText, ppTerm ) )
				return true;	// ³Υޥå齪λ
		} // 롼оݤ䤹Ԥ齪λ
		while ( !(*pIsInterrupted) && pLoop->Match( pText, &pText ) );

		return false;
	};
};

// ߤʷ֤
template < typename T_Char, typename T_Ptn, typename T_Text >
class GreedyLoopNode :
	public EpsilonNode< T_Char, T_Ptn, T_Text >,
	public LoopNode< T_Char, T_Ptn, T_Text >
{
public:
	GreedyLoopNode() : T_EPSNODE(), T_LOOPNODE(){};

	// ޥå
	virtual bool Match( T_Text pText, T_Text *ppTerm )
	{
		T_Text wTerm;
		bool f = false;

		// Ƥʷ֤ʤʤʤޤǼ¹Ԥ
		do {
			if ( T_EPSNODE::Match( pText, &wTerm ) ) {
				(*ppTerm) = wTerm;
				f = true;
			}
		} while ( !(*pIsInterrupted) && pLoop->Match( pText, &pText ) );

		// ߤƤ鵶֤ƽλ
		if ( (*pIsInterrupted) ) return false;

		return f;
	};
};

//////////////////////////////////////////////////////////////////////////////////////
// ʸ饹Ρ

// ꤷʸȥޥåΡ
template < typename T_Char, typename T_Ptn, typename T_Text >
class CharClassNode : public StringNode< T_Char, T_Ptn, T_Text >
{
public:
	CharClassNode() : StringNode< T_Char, T_Ptn, T_Text >(){};

	// ޥå
	virtual bool Match( T_Text pText, T_Text *ppTerm )
	{
		// ߤƤ鵶֤ƽλ
		if ( (*pIsInterrupted) ) return false;

		// ݻƤʸƱʸǤäϡޥåȸʤ
		for ( int i = 0; i < vString.size(); i++ ) {
			if ( vString[i] == (*pText) ) {
				++pText;	// ʸ
				return T_EPSNODE::Match( pText, ppTerm );
			}
		}
		return false;
	};
};

// ꤷʸʳʸȥޥåΡ
template < typename T_Char, typename T_Ptn, typename T_Text >
class UnCharClassNode : public StringNode< T_Char, T_Ptn, T_Text >
{
public:
	UnCharClassNode() : StringNode< T_Char, T_Ptn, T_Text >(){};

	// ޥå
	virtual bool Match( T_Text pText, T_Text *ppTerm )
	{
		// ߤƤ鵶֤ƽλ
		if ( (*pIsInterrupted) ) return false;

		// ݻƤʸȰۤʤʸǤäϡޥåȸʤ
		for ( int i = 0; i < vString.size(); i++ ) {
			if ( vString[i] == (*pText) )
				return false;	// Ʊʸä
		}

		++pText;
		return T_EPSNODE::Match( pText, ppTerm );
	};
};

}	// namespace N_SRegexNode

};	// namespace N_SRegex

#endif // REGTNODE_H_INCLUDED_

