///////////////////////////////////////////////////////////////////////////
// KeywordFinder.h
// ɤΥꥹȤ椫顢ɤθԤ
///////////////////////////////////////////////////////////////////////////

#if !defined( KEYWORDFINDER_H_INCLUDED_ )
#define KEYWORDFINDER_H_INCLUDED_

#include <vector>
#include <string>

namespace NLangExt {

template < typename T_Char, bool IsSensitive = true >
class CKeywordFinder
{
public:
	CKeywordFinder( const std::vector< std::wstring > *argpVec )
		: pKeywordVec( argpVec ), CharCnt( 0 )
	{
		s = 0;
		e = argpVec->size();
	};

	// ʸӤ
	bool CompareChar( T_Char c1, T_Char c2 )
	{
		if ( IsSensitive )
			return c1 == c2;
		else {
#if 0
			const char *pLC = "abcdefghijklmnopqrstuvwxyz";
			const char *pBC = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
			int i;
			T_Char wc1, wc2;
			for ( i = 0; i < 26 && c1 != T_Char( pLC[i] ); i++ );
			if ( i >= 26 )
				wc1 = c1;
			else
				wc1 = T_Char( pBC[i] );
			for ( i = 0; i < 26 && c2 != T_Char( pLC[i] ); i++ );
			if ( i >= 26 )
				wc2 = c2;
			else
				wc2 = T_Char( pBC[i] );
			return wc1 == wc2;
#else
			// ASCIIɤ˰¸뤬
			if ( c1 >= T_Char( 'a' ) && c1 <= T_Char( 'z' ) )
				c1 &= 0xDF;
			if ( c2 >= T_Char( 'a' ) && c2 <= T_Char( 'z' ) )
				c2 &= 0xDF;
			return c1 == c2;
#endif
		}
	}

	// ʸɲäɤϰϤꤹ
	void AddChar( T_Char c )
	{
		// ʤ
		for (; s < e && s < pKeywordVec->size() && !CompareChar( (*pKeywordVec)[s][CharCnt], c ); s++ );
		// ʤ
		for ( e-- ; e > s && e > 0 && !CompareChar( (*pKeywordVec)[e][CharCnt], c ); e-- );
		e++;
		CharCnt++;
	};

	// ɤĤäݤ
	bool IsFound()
	{
		if ( s >= e )
			return false;	// ΤϤʤä
		return ( T_Char( (*pKeywordVec)[s][CharCnt] ) == T_Char( '\0' ) );
	};
protected:
	const std::vector< std::wstring > *pKeywordVec;
	int CharCnt;
	int s;
	int e;
};

};

#endif // KEYWORDFINDER_H_INCLUDED_

