////////////////////////////////////////////////////////////////////////////
// CXimMgr 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include "XimMgr.h"
#include "TaEditJPEXT.h"

////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CXimMgr::CXimMgr() :
	m_Xic( NULL ),
	m_FontSet( NULL ),
	m_FontListEntry( NULL ),
	m_FontList( NULL )
{

}

CXimMgr::~CXimMgr()
{
	Clear();
}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// 
bool CXimMgr::Initialize( Widget argWgt, VClsPtr< CConfigInfo > argpConf )
{
	Arg al[20];
	int ac = 0;
	const string &rFontName = argpConf->RefFontName();
	Display *pDisplay = XtDisplay( argWgt );
	Screen *scr = XtScreen( argWgt );
	Window wnd = XtWindow( argWgt );
	int i;
	XPoint pt = { 20, 20 };

	// եȤξ
	m_FontSet = JPEXT_CreateFontSet( pDisplay, rFontName.c_str() );
	m_FontListEntry = XmFontListEntryCreate( XmFONTLIST_DEFAULT_TAG, XmFONT_IS_FONTSET, m_FontSet );
	m_FontList = XmFontListAppendEntry( NULL, m_FontListEntry );

	m_Wgt = argWgt;
	XmImRegister( argWgt, 0 );

	XtSetArg( al[ac], XmNbackground, argpConf->RefPreEditTextB_Color() ); ac++;
	XtSetArg( al[ac], XmNforeground, argpConf->RefPreEditTextF_Color() ); ac++;
	XtSetArg( al[ac], XmNspotLocation, &pt ); ac++;
	XtSetArg( al[ac], XmNbackgroundPixmap, NULL ); ac++;
	XtSetArg( al[ac], XmNfontList, m_FontList ); ac++;
	XtSetArg( al[ac], XmNlineSpace, 1 ); ac++;
	XmImSetValues( argWgt, al, ac );

	ac = 0;
	m_Xic = XmImGetXIC( argWgt, 0, al, ac );

	return true;
}

// եä
void CXimMgr::OnForcus()
{
	Arg al[1];
	int ac = 0;

	XmImSetFocusValues( m_Wgt, al, ac ); 
}

// եǤƤä
void CXimMgr::ExitForcus()
{
	XmImUnsetFocus( m_Wgt );
}

// ϰ֤
void CXimMgr::SetPosition( int x, int y ) const
{
	Arg al[1];
	int ac = 0;
	XPoint pt = { x, y };

	XtSetArg( al[ac], XmNspotLocation, &pt ); ac++;
	XmImSetValues( m_Wgt, al, ac );
}

// ϥƥȤμ
void CXimMgr::GetInputText( XKeyPressedEvent *event, wstring *pStr, KeySym *pKeySym, bool *pOnShift, bool *pCtrl )
{
	int r;
	KeySym wKeySym;
	Status wStatus;
	char pBuf1[3] = { 0, 0, 0 };
	char *pBuf2 = pBuf1;

	// ʸ
	r = XmImMbLookupString( m_Wgt, event, pBuf1, 2, &wKeySym, &wStatus );
	if ( wStatus == XBufferOverflow ) {
		// ʸǤ­
		pBuf2 = (char*)alloca( sizeof( char ) * ( r + 1 ) );
		XmImMbLookupString( m_Wgt, event, pBuf2, r, &wKeySym, &wStatus );
		pBuf2[r] = '\0';
	}

	(*pKeySym) = wKeySym;
	(*pOnShift) = ( event->state & ShiftMask ) ? true : false;
	(*pCtrl) = ( event->state & ControlMask ) ? true : false;

	if ( wStatus == XLookupChars || wStatus == XLookupBoth ) {
		// 磻ɥХʸѴ
		JPEXT_MBStoWCS( pBuf2, pStr );
	}
	else
		(*pStr) = L"";
}

// ˴
void CXimMgr::Clear()
{
	if ( m_Xic ) XDestroyIC( m_Xic );
	XmImUnregister( m_Wgt );
	m_Xic = NULL;

	XmFontListFree( m_FontList );
	XmFontListEntryFree( &m_FontListEntry );
	XFreeFontSet( XtDisplay( m_Wgt ), m_FontSet );
}
