////////////////////////////////////////////////////////////////////////////
// TaEditJPEXT.cc Хؿ
//
////////////////////////////////////////////////////////////////////////////

#include "TaEditJPEXT.h"
#include "VPtr.h"
#include "CompoundStr.h"

#include <Xm/XmAll.h>
#include <limits.h>

using namespace NNabikiVPtr;
using namespace std;

/*//////////////////////////////////////////////////////////
// եѤδؿʤɤ
//////////////////////////////////////////////////////////*/

// ե̾եȥåȤۤ
// XLoadQueryFontؿ֤
XFontSet JPEXT_CreateFontSet( Display *pDisplay, const char *pFontName )
{
	char **missing_list;
	int missing_count;
	char *def_string;
	XFontSet fontSet;

	// ꤵ줿ե̾ǥեȥåȤۤ
	fontSet = XCreateFontSet( pDisplay, pFontName, &missing_list, &missing_count, &def_string );

	// 顢ΥեȥåȤ֤
	if ( fontSet ) return fontSet;

	// Ԥ顢Ȥꤢ餫ΥեȥåȤۤ롣
	fontSet = XCreateFontSet( pDisplay, "*", &missing_list, &missing_count, &def_string );

	// 顢ȤꤢΥեȥåȤ֤
	if ( fontSet ) return fontSet;

	// Ԥ饢ܡȤ롣
	fprintf( stderr, "Can't create fontset." );
	abort();
}


// եȥåȤ顢ʸ
// flg = 0
// flg = 1Ǿ
short JPEXT_GetFontWidth( XFontSet fs, int flg )
{
	XFontStruct **pvFontStr;
	char **pvFontName;
	short Width;
	int cnt;
	int i;

	// եȹ¤Τȥե̾ΥꥹȤ
	cnt = XFontsOfFontSet( fs, &pvFontStr, &pvFontName );

	Width = SHRT_MAX * flg;
	// ⤷ϺǾͤ
	for ( i = 0; i < cnt; i++ ) {
		if ( 0 == flg ) {
			if ( Width < pvFontStr[ i ]->max_bounds.width )
				Width = pvFontStr[ i ]->max_bounds.width;
		}
		else {
			if ( Width > pvFontStr[ i ]->min_bounds.width )
				Width = pvFontStr[ i ]->min_bounds.width;
		}
	}

	return Width;
}

// եȥåȤ顢ʸ
// (CFontStruct)->max_bounds.width֤
short JPEXT_GetMaxWidth( XFontSet fs )
{
	return JPEXT_GetFontWidth( fs, 0 );
}

// եȥåȤ顢ʸ
// (CFontStruct)->min_bounds.width֤
short JPEXT_GetMinWidth( XFontSet fs )
{
	return JPEXT_GetFontWidth( fs, 1 );
}

// ascent
short JPEXT_GetFont_ascent( XFontSet fs )
{
	XFontStruct **pvFontStr;
	char **pvFontName;
	long Max = 0;
	int cnt = XFontsOfFontSet( fs, &pvFontStr, &pvFontName );
	int i;
	for ( i = 0; i < cnt; i++ ) {
		if ( Max < pvFontStr[ i ]->ascent )
			Max = pvFontStr[ i ]->ascent;
	}
	return Max;
}

// descent
short JPEXT_GetFont_descent( XFontSet fs )
{
	XFontStruct **pvFontStr;
	char **pvFontName;
	long Max = 0;
	int i;
	int cnt = XFontsOfFontSet( fs, &pvFontStr, &pvFontName );
	for ( i = 0; i < cnt; i++ ) {
		if ( Max < pvFontStr[ i ]->descent )
			Max = pvFontStr[ i ]->descent;
	}
	return Max;
}

// եȥåȤ顢⤵
short JPEXT_GetFontHeight( XFontSet fs )
{
	return JPEXT_GetFont_ascent( fs ) + JPEXT_GetFont_descent( fs );
}

/*//////////////////////////////////////////////////////////
// ޥХʸȥ磻ɥХʸѴ
//////////////////////////////////////////////////////////*/

bool JPEXT_WCStoMBS( const wchar_t *pWcs, std::string *pMbs )
{
	VPtr< char > pBuf;
	size_t len = wcslen( pWcs );

	// ΰ
	if ( !pBuf.Malloc( len * sizeof( wchar_t ) ) )
		return false;

	// ޥХʸѴ
	wcstombs( pBuf.GetPtr(), pWcs, len * sizeof( wchar_t ) );

	// ͤ
	(*pMbs) = pBuf.GetPtr();
	return true;
}

bool JPEXT_MBStoWCS( const char *pMbs, std::wstring *pWcs )
{
	VPtr< wchar_t > pBuf;
	size_t len = strlen( pMbs );

	// ΰ
	if ( !pBuf.Malloc( len * sizeof( wchar_t ) ) )
		return false;

	// ޥХʸѴ
	mbstowcs( pBuf.GetPtr(), pMbs, len * sizeof( wchar_t ) );

	// ͤ
	(*pWcs) = pBuf.GetPtr();
	return true;
}

// åץܡɤ˥ǡꤹ
void JPEXT_SetClipboardData( Widget w, const std::wstring &rStr )
{
	Display *pDisplay = XtDisplay( w );
	Window window = XtWindow( w );
	CCompoundStr ClipLabel( "text" );
	int status;
	long item_id = 0;
	string wStr;

	// 磻ɥХʸޥХʸѴ
	if ( !JPEXT_WCStoMBS( rStr.c_str(), &wStr ) )
		return ;

	// åץܡɤå
	do {
		status = XmClipboardStartCopy(
			pDisplay, window, ClipLabel, CurrentTime, NULL, NULL, &item_id
		);
	} while ( status == ClipboardLocked );

	// ǡϿ
	do {
		status = XmClipboardCopy (
			pDisplay, window, item_id, const_cast< char* >( "STRING" ),
			(char*)wStr.c_str(), ( wStr.length() + 1 ) * sizeof( char ), 0, NULL
		);
	} while ( status == ClipboardLocked );

	// åץܡɤ˥ǡž롣
	do {
		status = XmClipboardEndCopy ( pDisplay, window, item_id );
	} while ( status == ClipboardLocked );
}

// åץܡɤǡ
void JPEXT_GetClipboardData( Widget w, std::wstring *pStr )
{
	Display *pDisplay = XtDisplay( w );
	Window window = XtWindow( w );
	int status;
	long item_id = 0;
	unsigned long DataLength = 0;
	VPtr< char > pBuf;
	const char FormatString[3][10] = { "TEXT", "C_STRING", "STRING" };
	int type;
	int i, j;

	// åץܡɤ˵ϿƤǡĹ
	type = 0;
	do {
		do {
			status = XmClipboardInquireLength(
				pDisplay, window, const_cast< char* >( FormatString[type] ), &DataLength );
		} while ( status == ClipboardLocked );
		if ( ClipboardNoData == status || 0 == DataLength )
			type++;
	} while ( type < 3 && ClipboardNoData == status );
	if ( type == 3 ) {
		(*pStr) = L"";	// ֤٤ΤϤʤ
		return ;
	}

	// ΰݤ
	if ( !pBuf.Malloc( DataLength + 1 ) ) return ;

	// åץܡɤǡ
	do {
		status = XmClipboardRetrieve(
			pDisplay, window, const_cast< char* >( FormatString[type] ), pBuf.GetPtr(),
                        DataLength, NULL, NULL );
	} while ( status == ClipboardLocked );

/*
for ( i = 0; i < DataLength; i++ ) {
	printf( "%d : %c : 0x%02X\n", i, pBuf[i], pBuf[i] );
}
printf( "\n" );
*/

	if ( type == 0 ) {
		// ISO 2022ǥ󥳡ɤƤ餷
		// ѤƤޤ
		i = 0;
		j = 0;
		while ( i < DataLength ) {
			if ( pBuf[i] != 0x1b ) {
				pBuf[j] = pBuf[i];
				i++;
				j++;
			}
			else {
				if ( i + 1 < DataLength ) {
					if ( pBuf[ i + 1 ] == '$' )
						i += 4;
					else
						i += 3;
				}
				else
					i++;
			}
		}
		DataLength = j;
	}

	pBuf[DataLength] = '\0';
	JPEXT_MBStoWCS( pBuf.GetPtr(), pStr );
}

