////////////////////////////////////////////////////////////////////////////
// CFindText 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include "FindText.h"
#include "TextMatchLib.h"
#include "TaEditShell.h"

////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CFindText::CFindText() :
	m_Semaphore( 1 ), pDoc( NULL ), EnableExitFlg( true ),
	IsMatchedFlg( false ), ErrorInfo()
{

}

CFindText::~CFindText()
{

}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// Τξꤹ
bool CFindText::SetInfo(
	const CTaEditDoc *pArgDoc,
	T_CurPos argSPos,
	const wstring &rArgPtn,
	VClsPtr< CConfigInfo > pArgConf )
{
	pDoc = pArgDoc;
	SPos = argSPos;
	IsMatchedFlg = false;

	// ѥ֥Ȥ
	if ( CreateFindObj( &m_FindObj, rArgPtn, pArgConf ) )
		return true;

	pDoc = NULL;
	return false;
}

// 򳫻Ϥ
void CFindText::start()
{
	assert( NULL != this && NULL != pDoc );
	EnableExitFlg = false;	// λԲĤΥե饰
	m_Semaphore.P();	// ޥեå
	CProcesingObj::start();	// åɤ򳫻
}

// ѥå
void CFindText::run()
{
	assert( NULL != this && NULL != pDoc );
	IsMatchedFlg = FindNext( &m_FindObj, &m_ResultRange );	// 
	m_Semaphore.V();	// ޥե
	EnableExitFlg = true;	// λǽΥե饰
}

// λǽݤ
bool CFindText::EnableExit() const
{
	return EnableExitFlg;
}

// 
void CFindText::Interrupt()
{
	m_FindObj.Interrupt();
}

// åɤνλ碌
void CFindText::WaitThreadTerminate()
{
	m_Semaphore.P();
	m_Semaphore.V();
}

// Ĥäݤ
bool CFindText::IsMatched() const
{
	return IsMatchedFlg;
}

// ̤ϰϤ
const T_SelRange& CFindText::GetMatchRange() const
{
	return m_ResultRange;
}

// 顼
CErrorBool CFindText::GetErrorInfo() const
{
	return ErrorInfo;
}

// ѥ֥Ȥι
bool CFindText::CreateFindObj(
	N_SRegex::SRegex< wchar_t, const wchar_t*, tagPseudPtr > *pFindObj,
	const wstring &rPattern,
	VClsPtr< CConfigInfo > pConf ) const
{
	// ֥Ȥ
	if ( pFindObj->Initialize( rPattern.c_str() ) )
		return true;	// 

	// ꤵ줿ѥʸˡ顼ͭ롣

	// 顼åȥ顼ȯ֤
	const wstring &rMsg = GetRegexErrString( pFindObj->GetLastError(), pConf );
	int idx = pFindObj->GetErrorPos() - rPattern.c_str();

	// ɽå
	CCompoundStr wCS;
	if ( !pConf->GetWrongRegexPatternMsg( &wCS, rMsg, idx ) )
		return false;

	// åɽ
	m_TaEditShell->ShowErrorMsgBox( wCS );
	return false;
}

// SRegexΥ顼ͤбå
const wstring& CFindText::GetRegexErrString( N_SRegex::SREGEX_ERR err, VClsPtr< CConfigInfo > pConf ) const
{
	switch ( err ) {
	case N_SRegex::SRE_EOF_NOT_ANTICIPATED:
		return pConf->RefWRP_EofNotAnticipated();

	case N_SRegex::SRE_OUT_OF_MEMORY:
		return pConf->RefWRP_OutOfMemory();

	case N_SRegex::SRE_UNCERTAIN_CHAR:
		return pConf->RefWRP_UncertainChar();

	case N_SRegex::SRE_ZERO_LENGTH_PTN:
		return pConf->RefWRP_ZeroLengthPattern();

	case N_SRegex::SRE_UNEXPENTED:
	default:
		return pConf->RefWRP_Unexpected();
	}
}

// 
bool CFindText::FindNext( T_FindObj *pFindObj, T_SelRange *pRange ) const
{
	tagPseudPtr MatchSPos, MatchEPos;	// ޥåϰϤݻ

	// Ѥεݥ󥿤
	tagPseudPtr pseudPtr( &( pDoc->RefData() ), pDoc->RefData().begin() + SPos.GetLine(), SPos );

	// 
	bool r = pFindObj->FindMatchStr( pseudPtr, &MatchSPos, &MatchEPos );

	// ̤֤
	if ( r ) (*pRange) = T_SelRange( MatchSPos.GetCurPos(), MatchEPos.GetCurPos() );
	return r;
}

