/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
// fugenViewPropPane.cpp : t@C

#include "stdafx.h"
#include "fugen.h"
#include "fugenDoc.h"
#include "fugenViewPropPane.h"
#include "Misc/UserPreference.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// fugenViewPropPane _CAO

//fugenViewPropPane::fugenViewPropPane(CGLPropDialog* propPanel)
//:CGLPropPane(propPanel),
//m_bPanFlip(FALSE), m_bPanAlways(TRUE), m_dRot(30), m_bRotFlip(FALSE){
//}

fugenViewPropPane::fugenViewPropPane(fugenDoc* pDoc)
:CGLPropPane(pDoc){
}

void fugenViewPropPane::DoDataExchange(CDataExchange* pDX)
{
	CGLPropPane::DoDataExchange(pDX);

	DDX_Control(pDX, IDC_SLIDER_PROP_VIEW_SCREEN_FRACTION, m_sldPanRatio);

	DDX_Check(pDX, IDC_CHECK_PROP_VIEW_PAN_REVERSE, m_bPanFlip);

	DDX_Check(pDX, IDC_CHECK_PROP_VIEW_PAN_PARALLEL, m_bPanAlways);

	DDX_Control(pDX, IDC_SLIDER_PROP_VIEW_ZOOM_FACTOR, m_sldZoomRatio);

	DDX_Control(pDX, IDC_SPIN_PROP_VIEW_ROTATION_INCREMENT, m_spnRot);
	DDX_Text(pDX, IDC_EDIT_PROP_VIEW_ROTATION_INCREMENT, m_dRot);
	DDV_MinMaxDouble(pDX, m_dRot, m_dRotMin, m_dRotMax);

	DDX_Check(pDX, IDC_CHECK_PROP_VIEW_ROT_REVERSE, m_bRotFlip);
}
//
//void fugenViewPropPane::LoadUserProf()
//{
//	UserPreference& pref = UserPreference::getInstance();
//
//	m_bPanFlip = pref.GetBoolValue(upv_ViewOp_TranslationFlip);
//	m_bPanAlways = pref.GetBoolValue(upv_ViewOp_TranslationAlways);
//	m_bRotFlip = pref.GetBoolValue(upv_ViewOp_RotationFlip);
//
//	pref.GetDoubleValue(upv_ViewOp_RotationDelta, m_dRot, m_dRotMin, m_dRotMax);
//	pref.GetDoubleValue(upv_ViewOp_TranslationDelta, m_dTrans, m_dTransMin, m_dTransMax);
//	pref.GetDoubleValue(upv_ViewOp_ScaleDelta, m_dZoom, m_dZoomMin, m_dZoomMax);
//}
//
//void fugenViewPropPane::DoCheckProp(CGLPropDialog& panel)
//{
//	UserPreference& pref = UserPreference::getInstance();
//
//	pref.SetBoolValue(upv_ViewOp_TranslationFlip, m_bPanFlip);
//	pref.SetBoolValue(upv_ViewOp_TranslationAlways, m_bPanAlways);
//	pref.SetBoolValue(upv_ViewOp_RotationFlip, m_bRotFlip);
//
//	pref.SetDoubleValue(upv_ViewOp_RotationDelta, m_dRot);
//	pref.SetDoubleValue(upv_ViewOp_ScaleDelta, ((m_dZoomMax - m_dZoomMin) / 100) * m_sldZoomRatio.GetPos() + m_dZoomMin);
//	pref.SetDoubleValue(upv_ViewOp_TranslationDelta, m_sldPanRatio.GetPos() * .001);
//}
//
//void fugenViewPropPane::DoInitProp(const CGLPropDialog& panel)
//{
//	m_sldPanRatio.SetRange(0, 1000); // ׂ͂ł悢
//	m_sldPanRatio.SetPos(static_cast<int>(m_dTrans * 1000));
//
//	m_sldZoomRatio.SetRange(0, 100);
//	m_sldZoomRatio.SetPos(static_cast<int>(m_dZoom * (100. / (m_dZoomMax - m_dZoomMin))) - 100);
//
//	m_spnRot.SetRange32(0, 100); // ׂ͂ł悢
//
//	//TRACE("%d %d %d\n", m_sldPanRatio.GetPos(), m_sldZoomRatio.GetPos(), m_dRot);
//}

BEGIN_MESSAGE_MAP(fugenViewPropPane, CGLPropPane)
	ON_NOTIFY(UDN_DELTAPOS, IDC_SPIN_PROP_VIEW_ROTATION_INCREMENT, OnDeltaposSpin)
	ON_BN_CLICKED(IDC_BUTTON_PROP_VIEW_DEFAULT, OnButtonPropViewDefault)
END_MESSAGE_MAP()

// fugenViewPropPane bZ[W nh

// Xs{^
void fugenViewPropPane::OnDeltaposSpin(NMHDR* pNM, LRESULT* pResult)
{
	NM_UPDOWN* pUpDown = reinterpret_cast<NM_UPDOWN*>(pNM);
	const int nIDC = (const int)pUpDown->hdr.idFrom;

	switch(nIDC){
	case IDC_SPIN_PROP_VIEW_ROTATION_INCREMENT:
		// OŃCNg
		{
			*pResult = 0;
			if(!UpdateData()){ // GfBbg{bNX (m_nRot) XV
				return;
			}
			double dRotNew = m_dRot + pUpDown->iDelta * .1;
			dRotNew = (std::max)(dRotNew, m_dRotMin);
			dRotNew = (std::min)(dRotNew, m_dRotMax);
			m_dRot = dRotNew;
			UpdateData(FALSE);
		}
		break;
	default:
		*pResult = 1;
		break;
	}
}

void fugenViewPropPane::OnButtonPropViewDefault()
{
	UserPreference& pref = UserPreference::getInstance();

	m_bPanFlip = pref.GetBoolValue(upv_ViewOp_TranslationFlip, UserPreference::DefaultValue);
	m_bPanAlways = pref.GetBoolValue(upv_ViewOp_TranslationAlways, UserPreference::DefaultValue);
	m_bRotFlip = pref.GetBoolValue(upv_ViewOp_RotationFlip, UserPreference::DefaultValue);

	m_dRot = pref.GetDoubleValue(upv_ViewOp_RotationDelta, UserPreference::DefaultValue);
	m_dTrans = pref.GetDoubleValue(upv_ViewOp_TranslationDelta, UserPreference::DefaultValue);
	m_dZoom = pref.GetDoubleValue(upv_ViewOp_ScaleDelta, UserPreference::DefaultValue);
	
	m_sldPanRatio.SetPos(static_cast<int>(m_dTrans * 1000));
	m_sldZoomRatio.SetPos(static_cast<int>(m_dZoom * (100. / (m_dZoomMax - m_dZoomMin))) - 100);

	UpdateData(FALSE);
	Invalidate();
}

void fugenViewPropPane::LoadUserProf(){
	UserPreference& pref = UserPreference::getInstance();

	m_bPanFlip = pref.GetBoolValue(upv_ViewOp_TranslationFlip);
	m_bPanAlways = pref.GetBoolValue(upv_ViewOp_TranslationAlways);
	m_bRotFlip = pref.GetBoolValue(upv_ViewOp_RotationFlip);

	pref.GetDoubleValue(upv_ViewOp_RotationDelta, m_dRot, m_dRotMin, m_dRotMax);
	pref.GetDoubleValue(upv_ViewOp_TranslationDelta, m_dTrans, m_dTransMin, m_dTransMax);
	pref.GetDoubleValue(upv_ViewOp_ScaleDelta, m_dZoom, m_dZoomMin, m_dZoomMax);

	m_sldPanRatio.SetRange(0, 1000); // ׂ͂ł悢
	m_sldPanRatio.SetPos(static_cast<int>(m_dTrans * 1000));

	m_sldZoomRatio.SetRange(0, 100);
	m_sldZoomRatio.SetPos(static_cast<int>(m_dZoom * (100. / (m_dZoomMax - m_dZoomMin))) - 100);

	m_spnRot.SetRange32(0, 100); // ׂ͂ł悢
	UpdateData(FALSE);
}

BOOL fugenViewPropPane::UpdateUserProf(){
	if(UpdateData()){
	UserPreference& pref = UserPreference::getInstance();

	pref.SetBoolValue(upv_ViewOp_TranslationFlip, m_bPanFlip==TRUE);
	pref.SetBoolValue(upv_ViewOp_TranslationAlways, m_bPanAlways==TRUE);
	pref.SetBoolValue(upv_ViewOp_RotationFlip, m_bRotFlip==TRUE);

	pref.SetDoubleValue(upv_ViewOp_RotationDelta, m_dRot);
	pref.SetDoubleValue(upv_ViewOp_ScaleDelta, ((m_dZoomMax - m_dZoomMin) / 100) * m_sldZoomRatio.GetPos() + m_dZoomMin);
	pref.SetDoubleValue(upv_ViewOp_TranslationDelta, m_sldPanRatio.GetPos() * .001);
	return TRUE;
	}
	return FALSE;
}

void fugenViewPropPane::ResetToDefaultUserProf(){
	UserPreference& pref = UserPreference::getInstance();

	m_bPanFlip = pref.GetBoolValue(upv_ViewOp_TranslationFlip, UserPreference::DefaultValue);
	m_bPanAlways = pref.GetBoolValue(upv_ViewOp_TranslationAlways, UserPreference::DefaultValue);
	m_bRotFlip = pref.GetBoolValue(upv_ViewOp_RotationFlip, UserPreference::DefaultValue);

	m_dRot = pref.GetDoubleValue(upv_ViewOp_RotationDelta, UserPreference::DefaultValue);
	m_dTrans = pref.GetDoubleValue(upv_ViewOp_TranslationDelta, UserPreference::DefaultValue);
	m_dZoom = pref.GetDoubleValue(upv_ViewOp_ScaleDelta, UserPreference::DefaultValue);
	
	m_sldPanRatio.SetPos(static_cast<int>(m_dTrans * 1000));
	m_sldZoomRatio.SetPos(static_cast<int>(m_dZoom * (100. / (m_dZoomMax - m_dZoomMin))) - 100);

	UpdateData(FALSE);
	Invalidate();
}

void fugenViewPropPane::LoadDocContext(){
	ASSERT(FALSE);
	ASSERT_VALID(m_pTargetDoc);
}

BOOL fugenViewPropPane::UpdateDocContext(){
	ASSERT(FALSE);
	ASSERT_VALID(m_pTargetDoc);
	return FALSE;
}

void fugenViewPropPane::ResetToDefaultDocContext(){
	ASSERT(FALSE);
	ASSERT_VALID(m_pTargetDoc);
}

