/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
// openglwin4.cpp
#include "stdafx.h"
#include "fugen.h"
#include "fugenView.h"
#include "Undo/IActionManager.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

IActionManager* fugenView::GetActionManager(){
	return m_spPlaneActionMgr.get();
}

const IActionManager* fugenView::GetActionManager() const{
	return m_spPlaneActionMgr.get();
}

void fugenView::SetActionManager(IActionManager* pMgr){
	m_spPlaneActionMgr.reset(pMgr);
}

MGConstructionPlane& fugenView::GetCPlane(){
	return cplane();
}

void fugenView::Refresh(){
	Invalidate(FALSE);
}

IActionManager* fugenView::GetCameraActionManager(){
	return m_spCamActionMgr.get();
}

MGOpenGLView& fugenView::GetCamera(){
	return *this;
}

void fugenView::OnCPlaneUndo(){
	m_spPlaneActionMgr->Undo();
	document().SetStatusMessage(IDS_PROMPT_UNDO_FINISH);
}

void fugenView::OnUpdateCPlaneUndoUI(CCmdUI* pCmdUI){
	pCmdUI->Enable(m_spPlaneActionMgr->CanUndo());
}

void fugenView::OnCPlaneRedo(){
	m_spPlaneActionMgr->Redo();
	document().SetStatusMessage(IDS_PROMPT_REDO_FINISH);
}

void fugenView::OnUpdateCPlaneRedoUI(CCmdUI* pCmdUI){
	pCmdUI->Enable(m_spPlaneActionMgr->CanRedo());
}

void fugenView::OnViewUndo(){
	m_spCamActionMgr->Undo();
	document().SetStatusMessage(IDS_PROMPT_UNDO_FINISH);
}

void fugenView::OnUpdateViewUndoUI(CCmdUI* pCmdUI){
	pCmdUI->Enable(m_spCamActionMgr->CanUndo());
}

void fugenView::OnViewRedo(){
	m_spCamActionMgr->Redo();
	document().SetStatusMessage(IDS_PROMPT_REDO_FINISH);
}

void fugenView::OnUpdateViewRedoUI(CCmdUI* pCmdUI){
	pCmdUI->Enable(m_spCamActionMgr->CanRedo());
}
