/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file fugenView2D.cpp
 * @brief NX fugenView2D ̎
 */
#include "stdafx.h"
#include "fugen.h"

#include <math.h>
#include "mg/Straight.h"
#include "MainFrm.h"
#include "Undo/CameraAction.h"
#include "fugenView2D.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// fugenView2D

IMPLEMENT_DYNCREATE(fugenView2D, fugenView)

fugenView2D::fugenView2D():fugenView(){
}

fugenView2D::fugenView2D(
	int coord_type,	//coordinate type: 0:(x,y), 1:(y,z), 2:(x,z) out of (x,y,z).
	char axis1,		//axis name of axis1.
	char axis2		//axis name of axis2.
):fugenView(false),
	m_coord_type(coord_type),
	m_axis1(axis1),
	m_axis2(axis2){
}

fugenView2D::~fugenView2D(){;}

BEGIN_MESSAGE_MAP(fugenView2D, fugenView)
	//{{AFX_MSG_MAP(fugenView2D)
	ON_UPDATE_COMMAND_UI(ID_VIEW_VOLUME_PLAN, OnUpdateViewVolumePlan)
	ON_UPDATE_COMMAND_UI(ID_VIEW_VOLUME_FRONT, OnUpdateViewVolumeFront)
	ON_UPDATE_COMMAND_UI(ID_VIEW_VOLUME_BACK, OnUpdateViewVolumeBack)
	ON_UPDATE_COMMAND_UI(ID_VIEW_VOLUME_BOTTOM, OnUpdateViewVolumeBottom)
	ON_UPDATE_COMMAND_UI(ID_VIEW_VOLUME_LEFT, OnUpdateViewVolumeLeft)
	ON_UPDATE_COMMAND_UI(ID_VIEW_VOLUME_RIGHT, OnUpdateViewVolumeRight)
	ON_UPDATE_COMMAND_UI(ID_VIEW_VOLUME_TOP, OnUpdateViewVolumeTop)
	ON_UPDATE_COMMAND_UI(ID_VIEW_VOLUME_PERSPECTIVE, OnUpdateViewVolumePerspective)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

void fugenView2D::OnUpdateViewVolumePlan(CCmdUI* pCmdUI){	pCmdUI->Enable(FALSE);}
void fugenView2D::OnUpdateViewVolumeFront(CCmdUI* pCmdUI){pCmdUI->Enable(FALSE);}
void fugenView2D::OnUpdateViewVolumeBack(CCmdUI* pCmdUI){	pCmdUI->Enable(FALSE);}
void fugenView2D::OnUpdateViewVolumeBottom(CCmdUI* pCmdUI){pCmdUI->Enable(FALSE);}
void fugenView2D::OnUpdateViewVolumeLeft(CCmdUI* pCmdUI){pCmdUI->Enable(FALSE);}
void fugenView2D::OnUpdateViewVolumeRight(CCmdUI* pCmdUI){pCmdUI->Enable(FALSE);}
void fugenView2D::OnUpdateViewVolumeTop(CCmdUI* pCmdUI){pCmdUI->Enable(FALSE);}
void fugenView2D::OnUpdateViewVolumePerspective(CCmdUI* pCmdUI){pCmdUI->Enable(FALSE);}

void fugenView2D::copy_view_env(const fugenView& other){
	if(dynamic_cast<const fugenView2D*>(&other)){
		copy(other);
	}
}

//display the (x,y,z) position in status bar.
void fugenView2D::display_position_in_status_bar(const MGPosition& point) const{
	if(m_coord_type<3)
		fugenView::display_position_in_status_bar(point);
	else
		display_uv_in_status_bar(point);
}

//display the (u,v) position in status bar.
//The position is obtained from the construction plane of glview().
void fugenView2D::display_uv_in_status_bar(const MGPosition& pt)const{
	fugenStatusBar& status=theStatusBar();
	status.DisplayCoord(pt[0],pt[1]);
}

////// Wn̕` //////
void fugenView2D::updateAxisPictures(float scale){
	// ̃r[ANeBuȏꍇAW𔒂`悷B
	int vp[4];
	get_viewport(vp);
	m_coordinateDrawer.set_viewport(vp);
	const MGColor* arrowColor;
	if(theApp.current_view() == this)
		arrowColor=&(MGColor::get_instance(MGColor::White));
	else
		arrowColor=&(MGColor::get_instance(MGColor::Black));

	const int len = int(scale*COORD_LENGTH);   //coordinate line length.
	const int offset = int(scale*DIST_FROM_CORNER); //offset of origin.
	int coordinates[7]={
		offset,
		len,0,
		0,len,
		0,0
	};

	if(m_coordinateDrawer.is_made()){
		m_coordinateDrawer.updateCoordinateArrow(coordinates);
	}else{
		m_coordinateDrawer.makeCoordinateArrow(coordinates, axis1(), axis2());
	}
	m_coordinateDrawer.setStaticAttribColor(*arrowColor);
	m_coordinateDrawer.set_display();
}

// Grid color change apply.
void fugenView2D::apply_grid_colors(MGContext & ctx){
	cplane().set_colorsByViewID(is_standard_view(), ctx.gridColors());
}

///Initialize model.
void fugenView2D::initializeModel(){
	// Obh
	const MGColor* gridC=getUserPrefGridColor();
	const MGBox& bx=defaultBoxModel();
	int view_num=is_standard_view();
	double span=-1.;
	MGConstructionPlane& cpl = cplane();
	cpl.setGridDataByBox(bx,view_num,gridC,span);
	if(view_num){//When standard view.
		fugenDoc& doc=document();
		MGConstructionPlane& cplMain=doc.get_main_view()->cplane();
		double uspan,vspan,nspan;
		int lnumu, lnumv;
		cplMain.get_grid_data(uspan,vspan,lnumu, lnumv,nspan);
		cpl.set_uspan(uspan);
		cpl.set_vspan(vspan);
		cpl.set_unum(lnumu);
		cpl.set_vnum(lnumv);
	}
	initializeViewingEnvironmentByBox(bx);
}

///Transform to the view whose origin is cplane's origin and
//whose eys is on the normal of the cplane.
void fugenView2D::cplaneHome(){
	CCameraAction* pAct = new CCameraAction(this);
	pAct->SaveEnvParam(IAction::ACTION_UNDO);
	const MGPlane& pl=cplane().plane();
	updateCenterScalle(pl.center());

	// ANVł͂ȂŃtbV
	redrawOnlythis();

	pAct->Do(); // SetLastAction ߂̋󑀍B
	pAct->SaveEnvParam(IAction::ACTION_REDO);
}

void fugenView2D::mouse_move_transform(const CPoint& point){
	pan(mousemove_old_point(),point);
}

//Get the view title of this view;
CString fugenView2D::viewTitle()const{
	const fugenDoc& doc=document();
	CString strTitle;
	strTitle.Format(
		IDS_FORMAT_VIEW_TITLE_2D,doc.GetTitle(),axis1(),axis2());
	return strTitle;
}

///Set the window title.
void fugenView2D::setTitle(){
	CString strTitle=viewTitle();
	GetParent()->SetWindowText(strTitle);
}
