/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

#if !defined(AFX_FUGENSTATUSBAR_H__BD0D062F_789E_4506_87F1_9A6554FD82DE__INCLUDED_)
#define AFX_FUGENSTATUSBAR_H__BD0D062F_789E_4506_87F1_9A6554FD82DE__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "mgGL/SnapPositions.h"
#include "Common/CursorRestriction.h"


/////////////////////////////////////////////////////////////////////////////
// fugenStatusBar
//The design of the Status bar is as:
// (*COMMAND_MSG,*COORD,*GRID,*ANGLE,ID_SEPARATOR).
// COMMAND_MSG: Dispays current command, and the message from the command,
//        which is handled by MGCommandBase::SetStatusMessage().
// COORD: Displays located 3D(2D) coordinates, which is handled
//        by fugenView::display_position_in_status_bar().
// GRID and ANGLE: are treated as buttons to change the status, to turn on/off
//        their mode. In ANGLE pane, ELEVATE or TAB are also displayed when
//        the mode is designated in MGLocate's sub class to input in the mode.
//        GRID's status is controled by the document(m_document), an ANGLE
//        is by the current command(subclass of MGLocate).

class MGCommandBase;
class fugenDoc;

class fugenStatusBar : public CStatusBar{

// RXgNV
public:
	fugenStatusBar();

// Agr[g
public:

// Iy[V
public:
	
	//Get the reference to the mode.
	MGCursorRestriction& restrictionMode(){return m_restriction;};

	//Get the MGCursorRestriction mode.
	void GetRestrictionModeAngle(
		MGCursorRestriction::CURSOR_RESTRICTION_MODE& mode,
		double& angle	//effective only when mode=ANGLE, and input the angle in degree.
	);

	//Set a document. When doc=null is accepted, and disbale the LButton down.
	void SetDocument(fugenDoc* doc);

	//Display the message in the command message pane.
	void DisplayCommandMessage(LPCTSTR lpszCmdMessage);

	//Display coordinates in the coordinate display pane.
	void DisplayCoord(double u, double v);
	void DisplayCoord(double x, double y, double z);
	void DisplayCoord(const CString& str);

	// t[EBhE SetIndicators ̒ɌĂ
	void SetupToolTips();

// I[o[Ch
	// ClassWizard ͉z֐̃I[o[Ch𐶐܂B
	virtual void DrawItem(LPDRAWITEMSTRUCT);
	virtual BOOL PreTranslateMessage(MSG* pMsg);

	//Update the display of this bar's ANGLE/ELEBATION/TAB mode display
	//fromth current m_restriction status.
	void updateDisplay();

	//{{AFX_VIRTUAL(fugenStatusBar)
	//}}AFX_VIRTUAL

// Cve[V
public:
	virtual ~fugenStatusBar();

	// ꂽbZ[W }bv֐
protected:
	//{{AFX_MSG(fugenStatusBar)
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	//afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	
	afx_msg LRESULT OnStatusMsg(WPARAM wParam, LPARAM lParam);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

private:
	//void SetColor();
	void UpdateTipText();

	//Test if grid mode is enabled.
	bool isGridEnabled();

	BOOL DestroyWindow();
private:
	//m_restriction is the mode of the pane IDS_INDICATOR_ANGLE.
	//The mode is FREE, ANGLE, ELEVATE, or TAB.
	//When the mode is FREE, the pane's display is inactive ANGLE(colrOff),
	//and when it is not FREE, active ANGLE, ELEVATE, or TAB(colrOn).
	MGCursorRestriction m_restriction;

	CToolTipCtrl  m_tip;
	fugenDoc* m_document;
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ ͑Os̒Oɒǉ̐錾}܂B

#endif // !defined(AFX_FUGENSTATUSBAR_H__BD0D062F_789E_4506_87F1_9A6554FD82DE__INCLUDED_)
