/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
// fugenDocContentDlg.cpp : Cve[V t@C

#include "stdafx.h"
#include "fugen.h"
#include "fugenDoc.h"
#include "fugenDocContentDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/*
struct TV_ITEM{
	UINT mask; 
	HTREEITEM hItem; 
	UINT state; 
	UINT stateMask; 
	LPSTR pszText; 
	int cchTextMax; 
	int iImage; 
	int iSelectedImage; 
	int cChildren; 
	LPARAM lParam;
} 
*/
/*
struct NM_TREEVIEW { 
	NMHDR hdr; 
	UINT action; 
	TV_ITEM itemOld; 
	TV_ITEM itemNew; 
	POINT ptDrag;
};
*/

/////////////////////////////////////////////////////////////////////////////
// fugenDocContentDlg _CAO

fugenDocContentDlg::fugenDocContentDlg(fugenDoc* pDoc)
	: CDialog(fugenDocContentDlg::IDD, 0), m_pDoc(pDoc)
{
	//{{AFX_DATA_INIT(fugenDocContentDlg)
	//}}AFX_DATA_INIT
}

void fugenDocContentDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(fugenDocContentDlg)
	DDX_Control(pDX, IDC_DOC_RICH, m_rich);
	DDX_Control(pDX, IDC_DOC_TREE, m_tree);
	//}}AFX_DATA_MAP
}

void fugenDocContentDlg::MakeTree(HTREEITEM hParentItem, const MGGroup* node){
	MGGroup::const_iterator cur = node->begin(), last = node->end();
	for(; cur != last; ++cur){
		const MGGel* gel = cur->get();
		CString strName;
		CString kindname = CA2T(gel->whoami().c_str());
		strName.Format(IDS_FORMAT_DOC_CONTENT, gel, kindname);
		HTREEITEM hNode=
		m_tree.InsertItem(TVIF_TEXT|TVIF_PARAM,strName,-1,-1,-1,-1,(LPARAM)gel,hParentItem,TVI_LAST);
		const MGGroup* grp = dynamic_cast<const MGGroup*>(gel);
		if(grp){
			MakeTree(hNode, grp);
		}
	}
}

BEGIN_MESSAGE_MAP(fugenDocContentDlg, CDialog)
	//{{AFX_MSG_MAP(fugenDocContentDlg)
	ON_NOTIFY(TVN_SELCHANGED, IDC_DOC_TREE, OnSelchangedDocTree)
	ON_WM_SIZE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// fugenDocContentDlg bZ[W nh

BOOL fugenDocContentDlg::OnInitDialog(){
	CDialog::OnInitDialog();
	ASSERT_VALID(m_pDoc);

	SetIcon(AfxGetApp()->LoadIcon(IDR_MGCLTYPE), FALSE);

	// Initialize the tree control.
	const MGGroup& root = m_pDoc->get_main_group();
	HTREEITEM hTreeItem = m_tree.InsertItem(
		TVIF_TEXT | TVIF_PARAM, m_pDoc->GetTitle(), -1,-1,-1,-1, (LPARAM)&root, TVI_ROOT, TVI_LAST);

	MakeTree(hTreeItem, &root);
	// sbNĂIuWFNg
	// SelectĂ̂悢
//	m_tree.Expand(m_tree.GetRootItem(), TVE_EXPAND);

	CString str;
	VERIFY(str.LoadString(IDS_SCREEN_FONT));
	m_font.CreatePointFont(100, str);
	m_rich.SetFont(&m_font);

	CRect rc;
	GetClientRect(rc);
	int cx = rc.Width();
	int cy = rc.Height();

	if(m_tree.GetSafeHwnd()){
		CRect rc;
		m_tree.GetClientRect(rc);
		rc.right = 200;
		rc.left = 0;
		rc.top = 0;
		rc.bottom = cy;
		m_tree.MoveWindow(rc);
	}
	if(m_rich.GetSafeHwnd()){
		CRect rc;
		m_rich.GetClientRect(rc);
		rc.top = 0;
		rc.left = 200;
		rc.right = cx;
		rc.bottom = cy;
		m_rich.MoveWindow(rc);
	}

	return TRUE;
}

void fugenDocContentDlg::OnSelchangedDocTree(NMHDR* pNMHDR, LRESULT* pResult){
	*pResult = 0;

	NM_TREEVIEW* pNMTreeView = (NM_TREEVIEW*)pNMHDR;
	TV_ITEM tv = pNMTreeView->itemNew;
	tv.mask = TVIF_PARAM;
	m_tree.GetItem(&tv);

	//m_rich.Clear();
	
	MGGel* gel = reinterpret_cast<MGGel*>(tv.lParam);
	if(!gel) return;

	m_rich.SetWindowText(CA2T(gel->string_content().c_str()));

	MGObject* obj = dynamic_cast<MGObject*>(gel);
	if(!obj) return;

	MGGroup& gp =  m_pDoc->get_main_group();
	MGGroup* stored = 0;
	MGGroup::iterator i = gp.find(obj, stored);
	MGGelPosition gelp;
	if(stored){
		gelp.set_leaf_object(obj);
		gelp.set_top_group(&gp);
		m_pDoc->set_current_object(gelp);
	}
}

void fugenDocContentDlg::OnSize(UINT nType, int cx, int cy) 
{
	CDialog::OnSize(nType, cx, cy);
	
	if(m_tree.GetSafeHwnd()){
		CRect rc;
		m_tree.GetClientRect(rc);
		rc.right = 200;
		rc.left = 0;
		rc.top = 0;
		rc.bottom = cy;
		m_tree.MoveWindow(rc);
	}
	if(m_rich.GetSafeHwnd()){
		CRect rc;
		m_rich.GetClientRect(rc);
		rc.top = 0;
		rc.left = 200;
		rc.right = cx;
		rc.bottom = cy;
		m_rich.MoveWindow(rc);
	}
}
