/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
// fugenDoc7.cpp : fugenDoc NX̓̒`s܂B

#include "stdafx.h"
#include "fugenDoc.h"
#include "Undo/IActionTarget.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// j[[T[tFCX\]COMMANDCxg֐
void fugenDoc::OnViewShading()
{
	ChangeViewMode(MGCL::SHADINGVIEW);
}

// j[[T[tFCX\]UPDATECOMMANDCxg֐
void fugenDoc::OnUpdateViewShading(CCmdUI *pCmdUI)
{
	pCmdUI->SetRadio(GetViewMode() == MGCL::SHADING);
}

// j[[C[t[\]COMMANDCxg֐
void fugenDoc::OnViewWireframe()
{
	ChangeViewMode(MGCL::WIREVIEW);
}

// j[[C[t[\]UPDATECOMMANDCxg֐
void fugenDoc::OnUpdateViewWireframe(CCmdUI *pCmdUI)
{
	pCmdUI->SetRadio(GetViewMode() == MGCL::WIRE);
}

// j[[C[ET[tFCX\]COMMANDCxg֐
void fugenDoc::OnViewWireAndShading()
{
	ChangeViewMode(MGCL::WIRE_AND_SHADINGVIEW);
}

// j[[C[ET[tFCX\]UPDATECOMMANDCxg֐
void fugenDoc::OnUpdateViewWireAndShading(CCmdUI *pCmdUI)
{
	pCmdUI->SetRadio(GetViewMode() == MGCL::WIRE_AND_SHADING);
}

void fugenDoc::ChangeViewMode(MGCL::VIEWMODE mode, bool bNotify)
{
	// ݂Ɠ[hw肳ꂽꍇ͏Ȃ
	if(mode == GetViewMode()){
		return;
	}

	m_viewMode=mode;

	// KvȂΊ֘Ar[XVBʂ͕KvB
	CWaitCursor wait;
	if(bNotify){
		UpdateAllStdViews();
	}

	// check post-condition
	ASSERT(GetViewMode() == mode);
}

// IActionTarget

IActionManager* fugenDoc::GetActionManager()
{
	return m_undoManager.get();
}

const IActionManager* fugenDoc::GetActionManager() const
{
	return m_undoManager.get();
}

void fugenDoc::SetActionManager(IActionManager* pMgr)
{
	//m_undoManager.reset(pMgr);
}

bool fugenDoc::IsDirty()const{
	fugenDoc* dc=const_cast<fugenDoc*>(this);
	return dc->IsModified() ? true:false;
}

void fugenDoc::SetDirtyFlag(bool bDirty){
	SetModifiedFlag(bDirty);
}

// StatusMessage܂

void fugenDoc::SetStatusMessage(const CString& str){
	::AfxGetMainWnd()->SendMessage(
		WM_GL_STATUSBAR, 0, (LPARAM)(LPCTSTR)str);
}

// Xe[^Xo[ɕ\镶XV
void fugenDoc::SetStatusMessage(UINT nIDS, ...){
	CString strDisplay;
	CString strFormat;
	VERIFY(strFormat.LoadString(nIDS));

	va_list argList;
	va_start(argList, nIDS);
	strDisplay.FormatV(strFormat, argList);
	va_end(argList);

	// Xe[^Xo[ɕ\
	SetStatusMessage(strDisplay);
}
