/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
// fugenCrashDlg.cpp : t@C
#include "stdafx.h"
#include "fugenCrashDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

IMPLEMENT_DYNAMIC(fugenCrashDlg, CDialog)

fugenCrashDlg::fugenCrashDlg(CWnd* pParent)
	: CDialog(IDD, pParent),
	  m_hFontLink(0),
	  m_hCursorFinger(0)
{
}

fugenCrashDlg::~fugenCrashDlg()
{
	if(m_hFontLink){
		DeleteObject(m_hFontLink);
	}
	if(m_hCursorFinger){
		DestroyCursor(m_hCursorFinger);
	}
}

void fugenCrashDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

// Retrieves a cursor resource from Windows.
HCURSOR fugenCrashDlg::GetFingerCursor() const
{
	HCURSOR hCursor;
	TCHAR strWinDir[MAX_PATH + 12] = {0};

	// Retrieve the path of the Windows(R) directory.
	::GetWindowsDirectory(strWinDir, MAX_PATH);
	// Map winhlp32 module into the address space of this process.
	VERIFY(::PathAppend(strWinDir, _T("winhlp32.exe")));

	HINSTANCE hInstHelp = ::LoadLibrary(strWinDir);
	if(hInstHelp){
		// Load the handle-cursor resource from winhlp32.
		hCursor = CopyCursor(::LoadCursor(hInstHelp, MAKEINTRESOURCE(106)));
		// Unmap winhlp32.exe module from the address space of this process.
		::FreeLibrary(hInstHelp);
	}else{
		hCursor = ::LoadCursor(0, IDC_ARROW);
	}
	return hCursor;
}

BOOL fugenCrashDlg::OnInitDialog()
{
	if(!CDialog::OnInitDialog()){
		return FALSE;
	}

	SetIcon(::AfxGetApp()->LoadIcon(IDR_MGCLTYPE), FALSE);

	m_hFontLink = (HFONT)SendMessage(WM_GETFONT, 0, 0);
	LOGFONT logfont;
	GetObject(m_hFontLink, sizeof(LOGFONT), &logfont);
	logfont.lfUnderline = TRUE;
	m_hFontLink = CreateFontIndirect(&logfont);
	SendDlgItemMessage(IDC_ISSUE_PAGE, WM_SETFONT, (WPARAM)m_hFontLink, 0);
	SendDlgItemMessage(IDC_DEV_MGCL, WM_SETFONT, (WPARAM)m_hFontLink, 0);

	m_hCursorFinger = GetFingerCursor();

	SetDlgItemText(IDC_EDIT_STACK_TRACE, m_strLog);

	return TRUE;
}

void fugenCrashDlg::SetStackLog(const CString& str)
{
	m_strLog = str;
}

BEGIN_MESSAGE_MAP(fugenCrashDlg, CDialog)
	ON_WM_CTLCOLOR()
	ON_WM_SETCURSOR()
END_MESSAGE_MAP()

HBRUSH fugenCrashDlg::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor){
	int id = pWnd->GetDlgCtrlID();
	if(id == IDC_ISSUE_PAGE || id == IDC_DEV_MGCL){
		// Blue means hot text.
		pDC->SetTextColor(RGB(0x00, 0x00, 0xff));
		pDC->SetBkMode(TRANSPARENT);
		return GetSysColorBrush(COLOR_3DFACE);
	}
	return CDialog::OnCtlColor(pDC, pWnd, nCtlColor);
}

BOOL fugenCrashDlg::OnSetCursor(CWnd*, UINT, UINT message)
{
	CPoint point;
	GetCursorPos(&point);
	if(TestHotText(IDC_DEV_MGCL, message, point)){
		return TRUE;
	}

	if(TestHotText(IDC_ISSUE_PAGE, message, point)){
		return TRUE;
	}

	// Normal state.
	SetCursor(LoadCursor(0, IDC_ARROW));
	return TRUE;
}

BOOL fugenCrashDlg::TestHotText(UINT nIDC, UINT message, const CPoint& point)
{
	CWnd* pWndCtrl = GetDlgItem(nIDC);
	CRect rect;
	pWndCtrl->GetWindowRect(&rect);
	if(!rect.PtInRect(point)){
		return FALSE;
	}

	// The mouse pointer hovers over the label IDC_ISSUE_PAGE.
	SetCursor(m_hCursorFinger);
	if(message == WM_LBUTTONDOWN){
		// Run the web browser.
		CString strAddr;
		pWndCtrl->GetWindowText(strAddr);
		if(nIDC == IDC_DEV_MGCL){
			strAddr = _T("mailto:") + strAddr;
		}
		ShellExecute(
			::AfxGetMainWnd()->GetSafeHwnd(), _T("open"), strAddr, 0, 0, SW_SHOW);
	}

	return TRUE;
}
