/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
#include "stdafx.h"
#include "fugen.h"
#include "Common/GLCommandFactory.h"
#include "fugenView.h"

#include "FileCmd/MergeTool.h"
#include "FileCmd/ExportTool.h"
#include "EditCmd/EditRebuildTool.h"
#include "EditCmd/EditJoinTool.h"
#include "EditCmd/EditExplodeTool.h"
#include "EditCmd/EditSplitTool.h"
#include "EditCmd/EditTrimTool.h"
#include "EditCmd/EditDocTreeTool.h"
#include "EditCmd/EditAttribTool.h"
#include "ViewCmd/ViewPanTool.h"
#include "ViewCmd/ViewRotateTool.h"
#include "ViewCmd/ViewZoomDynamicTool.h"
#include "ViewCmd/ViewZoomWindowTool.h"
#include "ViewCmd/ViewZoomTargetTool.h"
#include "ViewCmd/NamedViewTool.h"
#include "ViewCmd/NamedCPlaneTool.h"
#include "CurveCmd/PointSingleTool.h"
#include "CurveCmd/PointMultiTool.h"
#include "CurveCmd/PointClosestTool.h"
#include "CurveCmd/PointEndTool.h"
#include "CurveCmd/PointFromCurveLength.h"
#include "CurveCmd/PointFromCurveDivide.h"
#include "CurveCmd/LineSegmentTool.h"
#include "CurveCmd/LinePerp1Tool.h"
#include "CurveCmd/LinePerp2Tool.h"
#include "CurveCmd/LineTan1Tool.h"
//#include "CurveCmd/LineTan2.h" // H
#include "CurveCmd/LineAngled.h"
#include "CurveCmd/LineBisect.h"
#include "CurveCmd/LineExtend.h"
#include "CurveCmd/Line4Point.h"
#include "CurveCmd/LineNormal.h"
#include "CurveCmd/LineVertical.h"
#include "CurveCmd/PolylineTool.h"
#include "CurveCmd/Rectangle.h"
#include "CurveCmd/RectCenter.h"
#include "CurveCmd/Rect3Point.h"
#include "CurveCmd/RectVertical.h"
#include "CurveCmd/Polygon.h"
#include "CurveCmd/PolygonEdge.h"
#include "CurveCmd/PolygonStar.h"
#include "CurveCmd/SplineInterpTool.h"
#include "CurveCmd/SplineCPointTool.h"
#include "CurveCmd/SplineSketchTool.h"
#include "CurveCmd/SplineBezierCurveTool.h"
#include "CurveCmd/SplineCurveUpdateTangentTool.h"
#include "CurveCmd/Circle.h"
#include "CurveCmd/CircleDiamTool.h"
#include "CurveCmd/Circle3P.h"
#include "CurveCmd/CircleTTRTool.h"
#include "CurveCmd/CircleT3Tool.h"
#include "CurveCmd/Arc.h"
#include "CurveCmd/ArcSED.h"
#include "CurveCmd/ArcSET.h"
#include "CurveCmd/ArcSER.h"
#include "CurveCmd/CornerR_CCRTool.h"
#include "CurveCmd/CornerR_CCPTool.h"
#include "CurveCmd/CornerR_C3Tool.h"
#include "CurveCmd/CornerR_CPRTool.h"
#include "CurveCmd/CornerR_CPPTool.h"
#include "CurveCmd/Ellipse.h"
#include "CurveCmd/ElpsCenAxesTool.h"
#include "CurveCmd/ElpsCorner.h"
#include "CurveCmd/ElpsDiamAxesTool.h"
#include "CurveCmd/ElpsFociTool.h"
#include "CurveCmd/Parabola.h"
#include "CurveCmd/Conic.h"
#include "CurveCmd/ExtendLengthTool.h"
#include "CurveCmd/ExtendLineToPnt.h"
#include "CurveCmd/ExtendArcToPnt.h"
#include "CurveCmd/CurveChamfer.h"
#include "CurveCmd/CurveFillet.h"
#include "CurveCmd/CurveBlendTool.h"
#include "CurveCmd/Curve3DComposite.h"
#include "CurveCmd/CurveConvert.h"
#include "CurveCmd/CurveProjectionTool.h"
#include "CurveCmd/CurvePullProject.h"
#include "CurveCmd/CurveExtractCPoint.h"
#include "CurveCmd/CurveExtractWire.h"
#include "CurveCmd/CurveOffsetTool.h"
#include "CurveCmd/CurveSmoothingState.h"
#include "CurveCmd/CurveNegateTool.h"
#include "CurveCmd/CurveMoveTool.h"
#include "CurveCmd/CurveKnotRemove.h"
#include "CurveCmd/CurveKnotInsertTool.h"
#include "CurveCmd/CurveSectionTool.h"
#include "CurveCmd/CurveContourTool.h"
#include "CurveCmd/CurveDuplicateEdge.h"
#include "CurveCmd/CurveBoundaryTool.h"
#include "CurveCmd/CurveIsectTool.h"
#include "CurveCmd/CurveParamLineTool.h"
#include "SurfCmd/Rect2VTool.h"
#include "SurfCmd/RectCVTool.h"
#include "SurfCmd/Rect3PTool.h"
#include "SurfCmd/RectVertTool.h"
#include "SurfCmd/SurfCornersTool.h"
#include "SurfCmd/SurfFromEdgesTool.h"
#include "SurfCmd/SurfPlanarTool.h"
#include "SurfCmd/PlaneEquation.h"
#include "SurfCmd/SurfSweepAlongCurveTool.h"
#include "SurfCmd/SurfSweepToPointTool.h"
#include "SurfCmd/SurfSweepRibbon.h"
#include "SurfCmd/SurfRuledTool.h"
#include "SurfCmd/SurfRevolutionTool.h"
#include "SurfCmd/SurfGridPointsTool.h"
#include "SurfCmd/SurfBlendAcross.h"
#include "SurfCmd/SurfBlendAll.h"
#include "SurfCmd/SurfQuadGCon.h"
#include "SurfCmd/SurfExtend.h"
#include "SurfCmd/SurfSweepExtrudeTool.h"
#include "SurfCmd/SurfOffsetTool.h"
#include "SurfCmd/SurfRibTool.h"
#include "SurfCmd/SurfUntrim.h"
#include "SurfCmd/SurfShrink.h"
#include "SurfCmd/SurfSplitIso.h"
#include "SurfCmd/SurfSmooth.h"
#include "SurfCmd/SurfNegate.h"
#include "SurfCmd/SurfKnotInsert.h"
#include "SurfCmd/SurfKnotRemove.h"
#include "MeshCmd/MeshTool.h"
#include "TransCmd/TransMove.h"
#include "TransCmd/TransCopy.h"
#include "TransCmd/TransRotate.h"
#include "TransCmd/TransRotate3D.h"
#include "TransCmd/TransScale.h"
#include "TransCmd/TransShear.h"
#include "TransCmd/TransMirror.h"
#include "ToolCmd/PropertyTool.h"
#include "EvalCmd/EvalPoint.h"
#include "EvalCmd/EvalBoxTool.h"
#include "EvalCmd/EvalCurveCont.h"
#include "EvalCmd/EvalCurveDevi.h"
#include "EvalCmd/EvalPointCurvatureTool.h"
#include "EvalCmd/EvalPointFromUV.h"
#include "EvalCmd/EvalSurfUVDisplay.h"
#include "EvalCmd/EvalCSDevTool.h"
#include "EvalCmd/EvalSSDevTool.h"
#include "EvalCmd/EvalCSFold.h"
#include "EvalCmd/EvalSurfGauss.h"
#include "EvalCmd/EvalSurfZebraTool.h"
#include "EvalCmd/EvalDistanceTool.h"
#include "EvalCmd/EvalDistance2PTool.h"
#include "EvalCmd/EvalAngle.h"
#include "EvalCmd/EvalCurveLengthTool.h"
#include "EvalCmd/EvalKnotsTool.h"
#include "EvalCmd/EvalCPolyTool.h"
#include "EvalCmd/EvalCurveCurvatureTool.h"
#include "EvalCmd/EvalCurveRadius.h"
#include "EvalCmd/EvalEdgeShowTool.h"
#include "EvalCmd/EvalSnapPointsTool.h"
#include "EvalCmd/EvalDirectionTool.h"
#include "EvalCmd/SnapPointGenTool.h"
#include "EvalCmd/EvalTextDumpTool.h"
#include "EvalCmd/EvalTessParam.h"
#include "EvalCmd/EvalParamSpace.h"
#include "EvalCmd/EvalAllOff.h"
#include "EvalCmd/EvalArrowOff.h"
#include "EvalCmd/EvalSnapDisplayOff.h"
#include "EvalCmd/EvalTessWorld.h"
#include "ViewCmd/CPlaneOrigin.h"
#include "ViewCmd/CPlaneElevate.h"
#include "ViewCmd/CPlaneRotate.h"
#include "ViewCmd/CPlaneToObj.h"
#include "ViewCmd/CPlaneToView.h"
#include "ViewCmd/CPlaneVertical.h"
#include "ViewCmd/CPlaneAxisZ.h"
#include "ViewCmd/CPlaneTop.h"
#include "ViewCmd/CPlaneRight.h"
#include "ViewCmd/CPlaneFront.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

namespace{
	// wp[֐ev[g
	//
	// @note @a nCmdId ͗\p[[^[ƂB
	template<typename CommandT>
	MGCommandBase* CreateCommandT(fugenDoc* pDoc, UINT /*nCmdId*/)	{
		return new CommandT(pDoc);
	}

	template<typename CommandT>
	MGCommandBase* CreateCommandT2(fugenDoc* pDoc, UINT nCmdId)
	{
		return new CommandT(pDoc, nCmdId);
	}

	// ݂́um_group łȂ΃j[Iv̂悤ɂȂĂB
	// ł͂ȂāuIuWFNg΃j[IvƂB
	bool ExistAny(fugenDoc* pDoc, UINT nCmdID)
	{
		return pDoc->get_main_group().size() >= 2;
	}

	// ANeBur[݂AƕʂLł邩eXgB
	bool GridEnabled(fugenDoc* pDoc, UINT nCmdID)
	{
		fugenView* pView = theApp.currentfugenView(pDoc);
		return pView && pView->cplane().enabled();
	}
}

// R}ht@Ng[
void fugen::InitCommands()
{
	ASSERT(m_spCmdFactory.get());
	CGLCommandFactory& fctry = GetCommandFactory();

	// t@C
	fctry.RegisterCommand(ID_FILE_MERGE, CreateCommandT<MGMergeTool>);
	fctry.RegisterCommand(ID_FILE_EXPORT, CreateCommandT<MGExportTool>);

	// ҏW
	fctry.RegisterCommand(ID_EDIT_REBUILD, CreateCommandT<MGRebuildTool>);
	fctry.RegisterCommand(ID_EDIT_JOIN, CreateCommandT<MGJoinTool>);
	fctry.RegisterCommand(ID_EDIT_EXPLODE, CreateCommandT<MGExplodeTool>);
	fctry.RegisterCommand(ID_EDIT_TRIM, CreateCommandT<MGTrimTool>);
	fctry.RegisterCommand(ID_EDIT_SPLIT, CreateCommandT<MGSplitTool>);
	fctry.RegisterCommand(ID_EDIT_DOC_CONTENT, CreateCommandT<MGDocTreeTool>);
	fctry.RegisterCommand(ID_EDIT_ATTRIB, CreateCommandT<MGAttribTool>);

	// r[
	fctry.RegisterCommand(ID_VIEW_PAN, CreateCommandT<MGViewPanTool>);
	fctry.RegisterCommand(ID_VIEW_ROTATE, CreateCommandT<MGViewRotateTool>);
	fctry.RegisterCommand(ID_VIEW_ZOOM_DYNAMIC, CreateCommandT<MGViewZoomDynamicTool>);
	fctry.RegisterCommand(ID_VIEW_ZOOM_WINDOW, CreateCommandT<MGViewZoomWindowTool>);
	fctry.RegisterCommand(ID_VIEW_ZOOM_TARGET, CreateCommandT<MGViewZoomTargetTool>);
	fctry.RegisterCommand(ID_VIEW_NAMED, CreateCommandT<MGNamedViewTool>);

	// Ȑ
	fctry.RegisterCommand(ID_CURVE_POINT_SINGLE, CreateCommandT<MGPointSingleTool>);
	fctry.RegisterCommand(ID_CURVE_POINT_MULTI, CreateCommandT<MGPointMultiTool>);
	fctry.RegisterCommand(ID_CURVE_CLOSEST, CreateCommandT<MGPointClosestTool>);
	fctry.RegisterCommand(ID_CURVE_START_POINT, CreatePointEndTool); // special
	fctry.RegisterCommand(ID_CURVE_END_POINT, CreatePointEndTool); // special
	fctry.RegisterCommand(ID_CURVE_DIVIDE_BY_LENGTH, CreateCommandT<MGPointFromCurveLengthTool>);
	fctry.RegisterCommand(ID_CURVE_DIVIDE_BY_NUM, CreateCommandT<MGPointFromCurveDivideTool>);
	fctry.RegisterCommand(ID_CURVE_LINE, CreateCommandT<MGLineGeneralTool>);
	fctry.RegisterCommand(ID_CURVE_SEGMENTS, CreateCommandT<MGLineSegmentTool>);
	fctry.RegisterCommand(ID_CURVE_LINE_PERP1, CreateCommandT<MGLinePerp1Tool>);
	fctry.RegisterCommand(ID_CURVE_LINE_PERP2, CreateCommandT<MGLinePerp2Tool>);
	fctry.RegisterCommand(ID_CURVE_LINE_TANGENT1, CreateCommandT<MGLineTan1Tool>);
	fctry.RegisterCommand(ID_CURVE_LINE_ANGLED, CreateCommandT<MGLineAngledTool>);
	fctry.RegisterCommand(ID_CURVE_LINE_BISECT, CreateCommandT<MGLineBisectTool>);
	fctry.RegisterCommand(ID_CURVE_LINE_EXTEND, CreateCommandT<MGLineExtendTool>);
	fctry.RegisterCommand(ID_CURVE_LINE_4PNT, CreateCommandT<MGLine4PointTool>);
	fctry.RegisterCommand(ID_CURVE_LINE_NORMAL, CreateCommandT<MGLineNormalTool>);
	fctry.RegisterCommand(ID_CURVE_LINE_VERTICAL, CreateCommandT<MGLineVerticalTool>);
	fctry.RegisterCommand(ID_CURVE_POLYLINE, CreateCommandT<MGPolylineTool>);
	fctry.RegisterCommand(ID_CURVE_POLYGON, CreateCommandT<MGPolygonTool>);
	fctry.RegisterCommand(ID_CURVE_POLYGON_EDGE, CreateCommandT<MGPolygonEdgeTool>);
	fctry.RegisterCommand(ID_CURVE_POLYGON_STAR, CreateCommandT<MGPolygonStarTool>);
	fctry.RegisterCommand(ID_CURVE_SPLINE_CPOINT, CreateCommandT<MGSplineCPointTool>);
	fctry.RegisterCommand(ID_CURVE_SPLINE, CreateCommandT<MGSplineInterpTool>);
	fctry.RegisterCommand(ID_CURVE_SPLINE_SKETCH, CreateCommandT<MGSplineSketchTool>);
	fctry.RegisterCommand(ID_CURVE_SPLINE_BEZIER, CreateCommandT<MGSplineBezierCurveTool>);
	fctry.RegisterCommand(ID_CURVE_SPLINE_MOVE_POINT, CreateCommandT<MGSplineCurveUpdateTangentTool>);
	fctry.RegisterCommand(ID_CURVE_RECT_CC, CreateCommandT<MGRectangleTool>);
	fctry.RegisterCommand(ID_CURVE_RECT_CEN_C, CreateCommandT<MGRectCenterTool>);
	fctry.RegisterCommand(ID_CURVE_RECT_3POINTS, CreateCommandT<MGRect3PointTool>);
	fctry.RegisterCommand(ID_CURVE_RECT_VERTICAL, CreateCommandT<MGRectVerticalTool>);
	fctry.RegisterCommand(ID_CURVE_CIRCLE_CENTER_RADIUS, CreateCommandT<MGCircleTool>);
	fctry.RegisterCommand(ID_CURVE_CIRCLE_DIAMETER, CreateCommandT<MGCircleDiamTool>);
	fctry.RegisterCommand(ID_CURVE_CIRCLE_3POINTS, CreateCommandT<MGCircle3PTool>);
	fctry.RegisterCommand(ID_CURVE_CIRCLE_TTR, CreateCommandT<MGCircleTTRTool>);
	fctry.RegisterCommand(ID_CURVE_CIRCLE_T3C, CreateCommandT<MGCircleT3Tool>);
	fctry.RegisterCommand(ID_CURVE_ARC_CSA, CreateCommandT<MGArcTool>);
	fctry.RegisterCommand(ID_CURVE_ARC_SET, CreateCommandT<MGArcSETTool>);
	fctry.RegisterCommand(ID_CURVE_ARC_SED, CreateCommandT<MGArcSEDTool>);
	fctry.RegisterCommand(ID_CURVE_ARC_SER, CreateCommandT<MGArcSERTool>);
	fctry.RegisterCommand(ID_CURVE_ARC_TTR, CreateCommandT<MGCornerR_CCRTool>);
	fctry.RegisterCommand(ID_CURVE_CORNER_R_CCP, CreateCommandT<MGCornerR_CCPTool>);
	fctry.RegisterCommand(ID_CURVE_CORNER_R_C3, CreateCommandT<MGCornerR_C3Tool>);
	fctry.RegisterCommand(ID_CURVE_CORNER_R_CPR, CreateCommandT<MGCornerR_CPRTool>);
	fctry.RegisterCommand(ID_CURVE_CORNER_R_CPP, CreateCommandT<MGCornerR_CPPTool>);
	fctry.RegisterCommand(ID_CURVE_ELLIPSE_CENTER, CreateCommandT<MGEllipseTool>);
	fctry.RegisterCommand(ID_CURVE_ELLIPSE_CORNER, CreateCommandT<MGElpsCornerTool>);
	fctry.RegisterCommand(ID_CURVE_ELLIPSE_DIAMETER, CreateCommandT<MGElpsDiamAxesTool>);
	fctry.RegisterCommand(ID_CURVE_ELLIPSE_FOCI, CreateCommandT<MGElpsFociTool>);
	fctry.RegisterCommand(ID_CURVE_PARABOLA, CreateCommandT<MGParabolaTool>);
	fctry.RegisterCommand(ID_CURVE_CONIC, CreateCommandT<MGConicTool>);
	fctry.RegisterCommand(ID_CURVE_EXTEND, CreateCommandT<MGExtendLengthTool>);
	fctry.RegisterCommand(ID_CURVE_EXTEND_LINE, CreateCommandT<MGExtendLineToPnt>);
	fctry.RegisterCommand(ID_CURVE_EXTEND_ARC_POINT, CreateCommandT<MGExtendArcToPnt>);
	fctry.RegisterCommand(ID_CURVE_CHAMFER, CreateCommandT<MGCurveChamferTool>);
	fctry.RegisterCommand(ID_CURVE_FILLET, CreateCommandT<MGCurveFilletTool>);
	fctry.RegisterCommand(ID_CURVE_OFFSET, CreateCommandT<MGCurveOffsetTool>);
	fctry.RegisterCommand(ID_CURVE_BLEND, CreateCommandT<MGCurveBlendTool>);
	fctry.RegisterCommand(ID_CURVE_3D, CreateCommandT<MGCurve3DCompositeTool>);
	fctry.RegisterCommand(ID_CURVE_CONVERT_LINE, CreateCurveConvertTool); // special
	//fctry.RegisterCommand(ID_CURVE_CONVERT_ARC, CreateCurveConvertTool; // #519: p~
	fctry.RegisterCommand(ID_CURVE_PROJECT, CreateCommandT<MGCurveProjectionTool>);
	fctry.RegisterCommand(ID_CURVE_PULL_PROJECT, CreateCommandT<MGCurvePullProjectTool>);
	fctry.RegisterCommand(ID_CURVE_EXTRACT_EDGE, CreateCommandT<MGCurveDuplicateEdgeTool>);
	fctry.RegisterCommand(ID_CURVE_BOUNDARY, CreateCommandT<MGCurveBoundaryTool>);
	fctry.RegisterCommand(ID_CURVE_INTERSECTION, CreateCommandT<MGCurveIsectTool>);
	fctry.RegisterCommand(ID_CURVE_CONTOUR, CreateCommandT<MGCurveContourTool>);
	fctry.RegisterCommand(ID_CURVE_SECTION, CreateCommandT<MGCurveSectionTool>);
	fctry.RegisterCommand(ID_CURVE_ISOPARAM, CreateCommandT<MGCurveParamLineTool>);
	fctry.RegisterCommand(ID_CURVE_EXTRACT_POINT, CreateCommandT<MGCurveExtractCPointTool>);
	fctry.RegisterCommand(ID_CURVE_EXTRACT_WIRE, CreateCommandT<MGCurveExtractWireTool>);
	//fctry.RegisterCommand(ID_CURVE_CREATE_UV, CreateCommandT<MGCurveUVTool>); // #525 ɂRgAEg
	fctry.RegisterCommand(ID_CURVE_SMOOTH, CreateCommandT<MGCurveSmoothingState>);
	//fctry.RegisterCommand(ID_CURVE_REBUILD, CreateCommandT<MGCurveRebuildTool>);
	fctry.RegisterCommand(ID_CURVE_NEGATE, CreateCommandT<MGCurveNegateTool>);
	fctry.RegisterCommand(ID_CURVE_MOVE, CreateCommandT<MGCurveMoveTool>);
	fctry.RegisterCommand(ID_CURVE_INSERT_KNOT, CreateCommandT<MGCurveKnotInsertTool>);
	fctry.RegisterCommand(ID_CURVE_REMOVE_KNOT, CreateCommandT<MGCurveKnotRemoveTool>);

	// Ȗ
	//Rect
	fctry.RegisterCommand(ID_SURFACE_RECT_CC, CreateCommandT<MGRectFace2VTool>);
	fctry.RegisterCommand(ID_SURFACE_RECT_CEN_C, CreateCommandT<MGRectFaceCVTool>);
	fctry.RegisterCommand(ID_SURFACE_RECT_3POINTS, CreateCommandT<MGRectFace3PTool>);
	fctry.RegisterCommand(ID_SURFACE_RECT_VERT, CreateCommandT<MGRectFaceVertTool>);

	//Plane
	fctry.RegisterCommand(ID_SURFACE_PLANE_VERTEX, CreateCommandT<MGPlaneVertexTool>);
	fctry.RegisterCommand(ID_SURFACE_PLANE_CENTER, CreateCommandT<MGPlaneCenterTool>);
	fctry.RegisterCommand(ID_SURFACE_PLANE_3POINTS, CreateCommandT<MGPlane3PTool>);
	fctry.RegisterCommand(ID_SURFACE_PLANE_VERT, CreateCommandT<MGPlaneVertTool>);
	fctry.RegisterCommand(ID_SURFACE_PLANE_EQUATION, CreateCommandT<MGPlaneEquationTool>);

	fctry.RegisterCommand(ID_SURFACE_RIB, CreateCommandT<MGSurfRibTool>);
	fctry.RegisterCommand(ID_SURFACE_REV, CreateCommandT<MGSurfRevolutionTool>);
	fctry.RegisterCommand(ID_SURFACE_RULED, CreateCommandT<MGSurfRuledTool>);
	fctry.RegisterCommand(ID_SURFACE_CORNERS, CreateCommandT<MGSurfCornersTool>);

	//From edges
	fctry.RegisterCommand(ID_SURFACE_EDGES_2, CreateSurfFromEdgesTool); // special
	fctry.RegisterCommand(ID_SURFACE_EDGES_3, CreateSurfFromEdgesTool); // special
	fctry.RegisterCommand(ID_SURFACE_EDGES_4, CreateCommandT<MGSurfFrom4Edges>);

	fctry.RegisterCommand(ID_SURFACE_FROM_PLANAR_CURVE, CreateCommandT<MGSurfPlanarTool>);
	fctry.RegisterCommand(ID_SURFACE_FROM_GRID_POINTS, CreateCommandT<MGSurfGridPointsTool>);
	fctry.RegisterCommand(ID_SURFACE_QS, CreateCommandT<MGSurfQuadGConTool>);

	//Extrude tools
	fctry.RegisterCommand(ID_SURFACE_EXTRUDE_STRAIGHT, CreateCommandT<MGSurfSweepExtrudeTool>);
	fctry.RegisterCommand(ID_SURFACE_EXTRUDE_ALONG_CURVE, CreateCommandT<MGSurfSweepAlongCurveTool>);
	fctry.RegisterCommand(ID_SURFACE_EXTRUDE_TO_POINT, CreateCommandT<MGSurfSweepToPointTool>);
	fctry.RegisterCommand(ID_SURFACE_EXTRUDE_RIBBON, CreateCommandT<MGSurfSweepRibbonTool>);

	fctry.RegisterCommand(ID_SURFACE_EXTEND, CreateCommandT<MGSurfExtendTool>);
	fctry.RegisterCommand(ID_SURFACE_OFFSET, CreateCommandT<MGSurfOffsetTool>);
	fctry.RegisterCommand(ID_SURFACE_FUNC_ACROSS, CreateCommandT<MGSurfBlendAcrossTool>);
	fctry.RegisterCommand(ID_SURFACE_FUNC_ALL, CreateCommandT<MGSurfBlendAllTool>);

	fctry.RegisterCommand(ID_SURFACE_UNTRIM, CreateSurfUntrimTool); // special
	fctry.RegisterCommand(ID_SURFACE_UNTRIM_EXTRACT, CreateSurfUntrimTool); // special
	fctry.RegisterCommand(ID_SURFACE_SPLIT_ISOCURVE, CreateCommandT<MGSurfSplitIsoTool>);
	fctry.RegisterCommand(ID_SURFACE_SHRINK, CreateCommandT<MGSurfShrinkTool>);
	fctry.RegisterCommand(ID_SURFACE_SMOOTH, CreateCommandT<MGSurfSmoothTool>);
	fctry.RegisterCommand(ID_SURFACE_NEGATE, CreateCommandT<MGSurfNegateTool>);
	fctry.RegisterCommand(ID_SURFACE_KNOT_INSERT, CreateCommandT<MGSurfKnotInsertTool>);
	fctry.RegisterCommand(ID_SURFACE_KNOT_REMOVE, CreateCommandT<MGSurfKnotRemoveTool>);

	// bV
	fctry.RegisterCommand(ID_MESH, CreateCommandT<MGMeshTool>);

	// ό`
	fctry.RegisterCommand(ID_TRANSFORM_MOVE, CreateCommandT<MGTransMoveTool>);
	fctry.RegisterCommand(ID_TRANSFORM_COPY, CreateCommandT<MGTransCopyTool>);
	fctry.RegisterCommand(ID_TRANSFORM_ROTATE, CreateCommandT<MGTransRotateTool>);
	fctry.RegisterCommand(ID_TRANSFORM_ROTATE_3D, CreateCommandT<MGTransRotate3DTool>);
	fctry.RegisterCommand(ID_TRANSFORM_SCALE, CreateCommandT<MGTransScale1DTool>);
	fctry.RegisterCommand(ID_TRANSFORM_SHEAR, CreateCommandT<MGTransShearTool>);
	fctry.RegisterCommand(ID_TRANSFORM_MIRROR, CreateCommandT<MGTransMirrorTool>);

	// c[
	fctry.RegisterCommand(ID_CPLANE_GRID, CreatePropertyTool); //ƕʂ̐ݒ

	// hLgReLXg
	fctry.RegisterCommand(ID_CONTEXT_TOLERANCE, CreatePropertyTool);
	fctry.RegisterCommand(ID_CONTEXT_TESSPARAM, CreatePropertyTool);
	fctry.RegisterCommand(ID_CONTEXT_COLOR, CreatePropertyTool);
	fctry.RegisterCommand(ID_CONTEXT_EDIT, CreatePropertyTool);


	// 
	fctry.RegisterCommand(ID_SYSD_KNOTS, CreateCommandT<MGEvalKnotsTool>);
	fctry.RegisterCommand(ID_SYSD_CPOLY_ON, CreateCommandT<MGEvalCPolyTool>);
	fctry.RegisterCommand(ID_SYSD_CURVA_ON, CreateCommandT<MGEvalCurveCurvatureTool>);
	fctry.RegisterCommand(ID_EVAL_ARROW_ON, CreateCommandT<MGEvalDirectionTool>);
	fctry.RegisterCommand(ID_EVAL_SNAP_DISPLAY_ON, CreateCommandT<MGEvalSnapPointsTool>);
	fctry.RegisterCommand(ID_EVAL_SNAP_DISPLAY_OFF, CreateCommandT<MGEvalSnapDisplayOff>);
	fctry.RegisterCommand(ID_EVAL_SNAP_GEN, CreateCommandT<MGSnapPointGenTool>);
	fctry.RegisterCommand(ID_EVAL_POINT, CreateCommandT<MGEvalPointTool>);
	fctry.RegisterCommand(ID_EVAL_BOX, CreateCommandT<MGEvalBoxTool>);
	fctry.RegisterCommand(ID_EVAL_CURVE_CONT, CreateCommandT<MGEvalCurveContTool>);
	fctry.RegisterCommand(ID_EVAL_CURVE_DEVIATION, CreateCommandT<MGEvalCurveDeviTool>);
	fctry.RegisterCommand(ID_EVAL_POINTS_FROM_UV, CreateCommandT<MGEvalPointFromUVTool>);
	fctry.RegisterCommand(ID_EVAL_UV, CreateCommandT<MGEvalSurfUVDisplayTool>);
	fctry.RegisterCommand(ID_EVAL_CURVE_SURFACE, CreateCommandT<MGEvalCSDevTool>);
	fctry.RegisterCommand(ID_EVAL_GAP, CreateCommandT<MGEvalSSDevTool>);
	fctry.RegisterCommand(ID_EVAL_CURVE_SURFACE_2, CreateCommandT<MGEvalCSFoldTool>);
	fctry.RegisterCommand(ID_EVAL_SURFACE_GAUSS, CreateCommandT<MGEvalSurfGaussTool>);
	fctry.RegisterCommand(ID_EVAL_SURFACE_ZEBRA, CreateCommandT<MGEvalSurfZebraTool>);
	fctry.RegisterCommand(ID_EVAL_RADIUS, CreateCommandT<MGEvalPointCurvatureTool>);
	fctry.RegisterCommand(ID_EVAL_DISTANCE_2P, CreateCommandT<MGEvalDistance2PTool>);
	fctry.RegisterCommand(ID_EVAL_DISTANCE, CreateCommandT<MGEvalDistanceTool>);
	fctry.RegisterCommand(ID_EVAL_ANGLE, CreateCommandT<MGEvalAngleTool>);
	fctry.RegisterCommand(ID_RADIUS, CreateCommandT<MGEvalCurveRadiusTool>);
	fctry.RegisterCommand(ID_EDGE_SHOW, CreateCommandT<MGEvalEdgeShowTool>);
	fctry.RegisterCommand(ID_EVAL_CURVE_LENGTH, CreateCommandT<MGEvalCurveLength>);
	fctry.RegisterCommand(ID_STRING_CONTENTS, CreateCommandT<MGEvalTextDumpTool>);
	fctry.RegisterCommand(ID_TESS_PARAM, CreateCommandT<MGEvalTessParam>);
	fctry.RegisterCommand(ID_PARAM_SPACE, CreateCommandT<MGEvalParamSpace>);
	fctry.RegisterCommand(ID_EVAL_ALL_OFF, CreateCommandT<MGEvalAllOff>);
	fctry.RegisterCommand(ID_EVAL_ARROW_OFF, CreateCommandT<MGEvalArrowOff>);
	fctry.RegisterCommand(ID_TESS_WORLD, CreateCommandT<MGEvalTessWorld>);

	// _[
	/*fctry.RegisterCommand(ID_RENDER_TEST, CreateCommandT<MGRenderTestTool>);
	fctry.RegisterCommand(ID_RENDER_LIGHT_SPOT, CreateCommandT<MGRenderSpotLightTool>);
	fctry.RegisterCommand(ID_RENDER_LIGHT_POINT, CreateCommandT<MGRenderPointLightTool>);
	fctry.RegisterCommand(ID_RENDER_LIGHT_DIRECTIONAL, CreateCommandT<MGRenderDirLightTool>);
	fctry.RegisterCommand(ID_RENDER_LIGHT_RECTANGLE, CreateCommandT<MGRenderRectLightTool>);
	fctry.RegisterCommand(ID_RENDER_LIGHT_LINE, CreateCommandT<MGRenderLinearLightTool>);*/

	// }
	fctry.RegisterCommand(ID_CPLANE_ORIGIN, CreateCommandT<MGCPlaneOriginTool>);
	fctry.RegisterCommand(ID_CPLANE_ELEVATION, CreateCommandT<MGCPlaneElevateTool>);
	fctry.RegisterCommand(ID_CPLANE_ROTATION, CreateCommandT<MGCPlaneRotateTool>); // r[R}h
	fctry.RegisterCommand(ID_CPLANE_TO_OBJ, CreateCommandT<MGCPlaneToObjTool>);
	fctry.RegisterCommand(ID_CPLANE_TO_VIEW, CreateCommandT<MGCPlaneToViewTool>);
	fctry.RegisterCommand(ID_CPLANE_VERTICAL, CreateCommandT<MGCPlaneVerticalTool>);
	fctry.RegisterCommand(ID_CPLANE_Z, CreateCommandT<MGCPlaneAxisZTool>);
	fctry.RegisterCommand(ID_CPLANE_TOP, CreateCommandT<MGCPlaneTopTool>);
	fctry.RegisterCommand(ID_CPLANE_RIGHT, CreateCommandT<MGCPlaneRightTool>);
	fctry.RegisterCommand(ID_CPLANE_FRONT, CreateCommandT<MGCPlaneFrontTool>);
	fctry.RegisterCommand(ID_CPLANE_NAMED, CreateCommandT<MGNamedCPlaneTool>);

	// t@C
	fctry.RegisterUpdateUI(ID_FILE_EXPORT, ExistAny);

	// ҏW
	fctry.RegisterUpdateUI(ID_EDIT_REBUILD, ExistAny);
	fctry.RegisterUpdateUI(ID_EDIT_JOIN, ExistAny);
	fctry.RegisterUpdateUI(ID_EDIT_EXPLODE, ExistAny);
	fctry.RegisterUpdateUI(ID_EDIT_TRIM, ExistAny);
	fctry.RegisterUpdateUI(ID_EDIT_SPLIT, ExistAny);
	fctry.RegisterUpdateUI(ID_MESH, ExistAny);
	fctry.RegisterUpdateUI(ID_EDIT_ATTRIB, ExistAny);

	// Ȑ
	fctry.RegisterUpdateUI(ID_CURVE_CLOSEST, ExistAny);
	fctry.RegisterUpdateUI(ID_CURVE_START_POINT, ExistAny);
	fctry.RegisterUpdateUI(ID_CURVE_END_POINT, ExistAny);
	fctry.RegisterUpdateUI(ID_CURVE_DIVIDE_BY_LENGTH, ExistAny);
	fctry.RegisterUpdateUI(ID_CURVE_DIVIDE_BY_NUM, ExistAny);
	fctry.RegisterUpdateUI(ID_CURVE_LINE_PERP1, ExistAny);
	fctry.RegisterUpdateUI(ID_CURVE_LINE_PERP2, ExistAny);
	fctry.RegisterUpdateUI(ID_CURVE_LINE_TANGENT1, ExistAny);
	fctry.RegisterUpdateUI(ID_CURVE_LINE_TANGENT2, 0); // H
	fctry.RegisterUpdateUI(ID_CURVE_LINE_NORMAL, ExistAny);
	fctry.RegisterUpdateUI(ID_CURVE_CIRCLE_TTR, ExistAny);
	fctry.RegisterUpdateUI(ID_CURVE_CIRCLE_T3C, ExistAny);
	fctry.RegisterUpdateUI(ID_CURVE_ARC_TTR, ExistAny);
	fctry.RegisterUpdateUI(ID_CURVE_CORNER_R_CCP, ExistAny);
	fctry.RegisterUpdateUI(ID_CURVE_CORNER_R_C3, ExistAny);
	fctry.RegisterUpdateUI(ID_CURVE_CORNER_R_CPR, ExistAny);
	fctry.RegisterUpdateUI(ID_CURVE_CORNER_R_CPP, ExistAny);
	fctry.RegisterUpdateUI(ID_CURVE_EXTEND, ExistAny);
	fctry.RegisterUpdateUI(ID_CURVE_EXTEND_ARC, ExistAny);
	fctry.RegisterUpdateUI(ID_CURVE_EXTEND_ARC_POINT, ExistAny);
	fctry.RegisterUpdateUI(ID_CURVE_EXTEND_LINE, ExistAny);
	fctry.RegisterUpdateUI(ID_CURVE_CHAMFER, ExistAny);
	fctry.RegisterUpdateUI(ID_CURVE_FILLET, ExistAny);
	fctry.RegisterUpdateUI(ID_CURVE_OFFSET, ExistAny);
	fctry.RegisterUpdateUI(ID_CURVE_BLEND, ExistAny);
	fctry.RegisterUpdateUI(ID_CURVE_3D, ExistAny);
	fctry.RegisterUpdateUI(ID_CURVE_CONVERT_LINE, ExistAny);
	fctry.RegisterUpdateUI(ID_CURVE_PROJECT, ExistAny);
	fctry.RegisterUpdateUI(ID_CURVE_PULL_PROJECT, ExistAny);
	fctry.RegisterUpdateUI(ID_CURVE_EXTRACT_EDGE, ExistAny);
	fctry.RegisterUpdateUI(ID_CURVE_BOUNDARY, ExistAny);
	fctry.RegisterUpdateUI(ID_CURVE_INTERSECTION, ExistAny);
	fctry.RegisterUpdateUI(ID_CURVE_CONTOUR, ExistAny);
	fctry.RegisterUpdateUI(ID_CURVE_SECTION, ExistAny);
	fctry.RegisterUpdateUI(ID_CURVE_ISOPARAM, ExistAny);
	fctry.RegisterUpdateUI(ID_CURVE_EXTRACT_POINT, ExistAny);
	fctry.RegisterUpdateUI(ID_CURVE_EXTRACT_WIRE, ExistAny);
	//fctry.RegisterUpdateUI(ID_CURVE_CREATE_UV, ExistAny);
	fctry.RegisterUpdateUI(ID_CURVE_SMOOTH, ExistAny);
	fctry.RegisterUpdateUI(ID_CURVE_REBUILD, ExistAny);
	fctry.RegisterUpdateUI(ID_CURVE_NEGATE, ExistAny);
	fctry.RegisterUpdateUI(ID_CURVE_MOVE, ExistAny);
	fctry.RegisterUpdateUI(ID_CURVE_INSERT_KNOT, ExistAny);
	fctry.RegisterUpdateUI(ID_CURVE_REMOVE_KNOT, ExistAny);

	// Ȗ
	fctry.RegisterUpdateUI(ID_SURFACE_EDGES, ExistAny);
	fctry.RegisterUpdateUI(ID_SURFACE_EDGES_2, ExistAny);
	fctry.RegisterUpdateUI(ID_SURFACE_EDGES_3, ExistAny);
	fctry.RegisterUpdateUI(ID_SURFACE_EDGES_4, ExistAny);
	fctry.RegisterUpdateUI(ID_SURFACE_FROM_PLANAR_CURVE, ExistAny);
	fctry.RegisterUpdateUI(ID_SURFACE_EXTRUDE_ALONG_CURVE, ExistAny);
	fctry.RegisterUpdateUI(ID_SURFACE_EXTRUDE_STRAIGHT, ExistAny);
	fctry.RegisterUpdateUI(ID_SURFACE_EXTRUDE_TO_POINT, ExistAny);
	fctry.RegisterUpdateUI(ID_SURFACE_EXTRUDE_RIBBON, ExistAny);
	fctry.RegisterUpdateUI(ID_SURFACE_RULED, ExistAny);
	fctry.RegisterUpdateUI(ID_SURFACE_REV, ExistAny);
	fctry.RegisterUpdateUI(ID_SURFACE_FUNC_ACROSS, ExistAny);
	fctry.RegisterUpdateUI(ID_SURFACE_FUNC_ALL, ExistAny);
	fctry.RegisterUpdateUI(ID_SURFACE_OFFSET, ExistAny);

	fctry.RegisterUpdateUI(ID_SURFACE_BLEND, 0);
	fctry.RegisterUpdateUI(ID_SURFACE_RIB, ExistAny);
	fctry.RegisterUpdateUI(ID_SURFACE_QS, ExistAny);
	fctry.RegisterUpdateUI(ID_SURFACE_EXTEND, ExistAny);
	fctry.RegisterUpdateUI(ID_SURFACE_UNTRIM, ExistAny);
	fctry.RegisterUpdateUI(ID_SURFACE_UNTRIM_EXTRACT, ExistAny);
	fctry.RegisterUpdateUI(ID_SURFACE_SPLIT_ISOCURVE, ExistAny);
	fctry.RegisterUpdateUI(ID_SURFACE_SHRINK, ExistAny);
	fctry.RegisterUpdateUI(ID_SURFACE_SMOOTH, ExistAny);
	fctry.RegisterUpdateUI(ID_SURFACE_NEGATE, ExistAny);
	fctry.RegisterUpdateUI(ID_SURFACE_KNOT_INSERT, ExistAny);
	fctry.RegisterUpdateUI(ID_SURFACE_KNOT_REMOVE, ExistAny);

	// bV
	fctry.RegisterUpdateUI(ID_MESH, ExistAny);

	// ό`
	fctry.RegisterUpdateUI(ID_TRANSFORM_MOVE, ExistAny);
	fctry.RegisterUpdateUI(ID_TRANSFORM_COPY, ExistAny);
	fctry.RegisterUpdateUI(ID_TRANSFORM_ROTATE, ExistAny);
	fctry.RegisterUpdateUI(ID_TRANSFORM_ROTATE_3D, ExistAny);
	fctry.RegisterUpdateUI(ID_TRANSFORM_SCALE, ExistAny);
	fctry.RegisterUpdateUI(ID_TRANSFORM_SHEAR, ExistAny);
	fctry.RegisterUpdateUI(ID_TRANSFORM_MIRROR, ExistAny);

	// 
	fctry.RegisterUpdateUI(ID_EVAL_BOX, ExistAny);
	fctry.RegisterUpdateUI(ID_EVAL_CURVE_CONT, ExistAny);
	fctry.RegisterUpdateUI(ID_EVAL_CURVE_DEVIATION, ExistAny);
	fctry.RegisterUpdateUI(ID_EVAL_POINTS_FROM_UV, ExistAny);
	fctry.RegisterUpdateUI(ID_EVAL_CURVE_SURFACE, ExistAny);
	fctry.RegisterUpdateUI(ID_EVAL_CURVE_SURFACE_2, ExistAny);
	fctry.RegisterUpdateUI(ID_EVAL_GAP, ExistAny);
	fctry.RegisterUpdateUI(ID_EVAL_SURFACE_GAUSS, ExistAny);
	fctry.RegisterUpdateUI(ID_EVAL_SURFACE_ZEBRA, ExistAny);
	fctry.RegisterUpdateUI(ID_EVAL_CURVE_LENGTH, ExistAny);
	fctry.RegisterUpdateUI(ID_EVAL_RADIUS, ExistAny);
	fctry.RegisterUpdateUI(ID_EVAL_DISTANCE, ExistAny);
	fctry.RegisterUpdateUI(ID_RADIUS, ExistAny);
	fctry.RegisterUpdateUI(ID_EDGE_SHOW, ExistAny);
	fctry.RegisterUpdateUI(ID_EVAL_UV, ExistAny);

	// _[
	/*fctry.RegisterUpdateUI(ID_RENDER_TEST, ExistAny);
	fctry.RegisterUpdateUI(ID_RENDER_LIGHT_SPOT, 0);
	fctry.RegisterUpdateUI(ID_RENDER_LIGHT_POINT, 0);
	fctry.RegisterUpdateUI(ID_RENDER_LIGHT_DIRECTIONAL, 0);
	fctry.RegisterUpdateUI(ID_RENDER_LIGHT_RECTANGLE, 0);
	fctry.RegisterUpdateUI(ID_RENDER_LIGHT_LINE, 0);*/

	// }
	fctry.RegisterUpdateUI(ID_CPLANE_ORIGIN, GridEnabled);
	fctry.RegisterUpdateUI(ID_CPLANE_ELEVATION, GridEnabled);
	fctry.RegisterUpdateUI(ID_CPLANE_ROTATION, GridEnabled);
	fctry.RegisterUpdateUI(ID_CPLANE_TO_OBJ, GridEnabled);
	fctry.RegisterUpdateUI(ID_CPLANE_TO_VIEW, GridEnabled);
	fctry.RegisterUpdateUI(ID_CPLANE_VERTICAL, GridEnabled);
	fctry.RegisterUpdateUI(ID_CPLANE_VERT_CURVE, GridEnabled);
	fctry.RegisterUpdateUI(ID_CPLANE_X, GridEnabled);
	fctry.RegisterUpdateUI(ID_CPLANE_Z, GridEnabled);
	fctry.RegisterUpdateUI(ID_CPLANE_TOP, GridEnabled);
	fctry.RegisterUpdateUI(ID_CPLANE_RIGHT, GridEnabled);
	fctry.RegisterUpdateUI(ID_CPLANE_FRONT, GridEnabled);
}
