/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
#include "stdafx.h"
#include "mgGL/Context.h"
#include "Misc/vcdbgbuf.h"
#include "Misc/UserPreference.h"

#include "IO/GLFileManager.h"
#include "IO/GLMglImporter.h"
#include "IO/GLMglExporter.h"
#include "IO/GLIgesImporter.h"
#include "IO/GLIgesExporter.h"
#include "IO/GLNasImporter.h"
#include "IO/GLNasExporter.h"
#include "IO/GLUnvImporter.h"
#include "IO/GLUnvExporter.h"
#include "IO/GLStlImporter.h"
#include "IO/GLStlExporter.h"
#include "IO/GLObjImporter.h"
#include "IO/GLObjExporter.h"
#include "fugen.h"

#ifdef _DEBUG
#include "GLVersion.h"
#endif

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// file types

void fugen::InitFileHandlers()
{
	ASSERT(::AfxGetResourceHandle());

	CGLFileManager& mgr = CGLFileManager::GetInstance();

	mgr.RegisterHandler(IDS_FILTER_MG_EXT, new CGLMglImporter);
	mgr.RegisterHandler(IDS_FILTER_MG_EXT, new CGLMglExporter);

	mgr.RegisterHandler(IDS_FILTER_IGES_EXT, new CGLIgesImporter);
	mgr.RegisterHandler(IDS_FILTER_IGES_EXT, new CGLIgesExporter);

	mgr.RegisterHandler(IDS_FILTER_STL_EXT, new CGLStlImporter);
	mgr.RegisterHandler(IDS_FILTER_STL_EXT, new CGLStlExporter);

	mgr.RegisterHandler(IDS_FILTER_NAS_EXT, new CGLNasImporter);
	mgr.RegisterHandler(IDS_FILTER_NAS_EXT, new CGLNasExporter);

	mgr.RegisterHandler(IDS_FILTER_UNV_EXT, new CGLUnvImporter);
	mgr.RegisterHandler(IDS_FILTER_UNV_EXT, new CGLUnvExporter);

	mgr.RegisterHandler(IDS_FILTER_OBJ_EXT, new CGLObjImporter);
	mgr.RegisterHandler(IDS_FILTER_OBJ_EXT, new CGLObjExporter);
}

////////////////////////////////////////////////////////////////////
// configuration

void fugen::ShowAppState()
{
#ifdef _DEBUG
	COUT << "[DEBUG] " << m_pszAppName << " version " << (TCAST)GetVersionText() << 
		" " << std::endl << (TCAST)GetCopyrightText() << std::endl;

	COUT << "HTML Help path: " << m_pszHelpFilePath << std::endl;
#endif

	// Load the tolerance.
	MGTolerance& tol = MGTolerance::instance();
	const double dAngleZero = tol.angle_zero();
	const double dRelZero = tol.rc_zero();
	const double dMachZero = tol.mach_zero();
	const double dLineZero = .05;
	const double dWorldZero = .01;
	const double dMaxKnotRatio = tol.max_knot_ratio();

	double angle_zero = m_pUserPref->GetDoubleValue(upv_Tolerance_AngleZero);
	double rc_zero = m_pUserPref->GetDoubleValue(upv_Tolerance_RelZero);
	double mach_zero = m_pUserPref->GetDoubleValue(upv_Tolerance_MachineZero);
	double line_zero = m_pUserPref->GetDoubleValue(upv_Tolerance_LineZero);
	double wc_zero = m_pUserPref->GetDoubleValue(upv_Tolerance_WorldZero);
	double max_knot_ratio = m_pUserPref->GetDoubleValue(upv_Tolerance_MaxKnotRatio);

	// egX}V[菬ꍇ
	// {Av̐lŒuĂ炤
	tol.set_angle_zero(angle_zero < dMachZero ? dAngleZero : angle_zero);
	tol.set_rc_zero(rc_zero < dMachZero ? dRelZero : rc_zero);
	tol.set_mach_zero(mach_zero < dMachZero ? dMachZero : mach_zero);
	tol.set_line_zero(line_zero < dMachZero ? dLineZero : line_zero);
	tol.set_wc_zero(wc_zero < dMachZero ? dWorldZero : wc_zero);
	tol.set_max_knot_ratio(max_knot_ratio < dMachZero ? dMachZero : max_knot_ratio);

	// o̓EBhEɃgX\B
	CString strTol;
	strTol.Format(IDS_TOL_REPORT,
				  tol.mach_zero(),
				  tol.wc_zero(),
				  tol.line_zero(),
				  tol.angle_zero(),
				  tol.rc_zero(),
				  tol.max_knot_ratio());
				  
	COUT << (TCAST)strTol << std::endl;
}

void fugen::SaveAppState(){
	if(m_pUserPref.get()){
		//save into registry.
		m_pUserPref->SaveRegistry(*this);
	}
}

/////////// fobOo
namespace
{
	VCDBG::CDebugBufW streambufWout(WM_FUGEN_OUTPUT);
	VCDBG::CDebugBufW streambufWerr(WM_FUGEN_OUTPUT);
	VCDBG::CDebugBufA streambufAout(WM_FUGEN_OUTPUT);
	VCDBG::CDebugBufA streambufAerr(WM_FUGEN_OUTPUT);
}

// cout, cerr ̃obt@ւB
void fugen::InitDebugTools(){
	std::wcout.rdbuf(&streambufWout);
	std::wcerr.rdbuf(&streambufWerr);
	std::cout.rdbuf(&streambufAout);
	std::cerr.rdbuf(&streambufAerr);
}
