/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

// fugen.h : AvP[ṼC wb_[ t@C

#if !defined(AFX_GL_H__2398ABCD_D4C5_48D2_A408_C4F93610D38A__INCLUDED_)
#define AFX_GL_H__2398ABCD_D4C5_48D2_A408_C4F93610D38A__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#ifndef __AFXWIN_H__
	#error include 'stdafx.h' before including this file for PCH
#endif

class fugenView;
class fugenDoc;

class MGContext;

class UserPreference;
class CGLCommandFactory; // hLgɈړ邩ȂB

#include <utility>
#include <vector>

#include "resource.h"       // C V{

#include "Misc/GLCrashHandler.h"
#include "MainFrm.h"

/////////////////////////////////////////////////////////////////////////////
// fugen:

class fugen : public CWinApp
{
	HINSTANCE m_hRes; ///< ʌꃊ\[X DLL
	CGLCrashHandler m_crash; ///< NbVnh[ RAII IuWFNg
	std::unique_ptr<CGLCommandFactory> m_spCmdFactory; ///< R}ht@Ng[
	std::unique_ptr<UserPreference> m_pUserPref;///For singleton of UserPreference.

public:
	CDocTemplate* m_pParamTemplate;					//0
		//Document template for GLParamView.
	CDocTemplate* m_p2DxyViewTemplate;				//2
		//Document template for fugenView2Dxy.
	CDocTemplate* m_p2DyzViewTemplate;				//3
		//Document template for fugenView2Dyz.
	CDocTemplate* m_p2DxzViewTemplate;				//4
		//Document template for fugenView2Dxz.
	CDocTemplate* m_pTessWorldTemplate;				//5
		//Document template for GLTessWorldView.
	CDocTemplate* m_pTessParamTemplate;				//6
		//Document template for GLTessParamView.
	//CDocTemplate* m_pShadeTemplate;               //7
		//Document template for GLShadingView.
	//CDocTemplate* m_pRenderTemplate;              //8
		//Document template for GLRenderingView.
	CDocTemplate* m_pTexturePlaneTemplate;          //9
		//Document template for GLRenderingView.

public:
	fugen();

// I[o[Ch
	//{{AFX_VIRTUAL(fugen)
public:
	virtual BOOL InitInstance();
	virtual int ExitInstance();
	//}}AFX_VIRTUAL

// Cve[V
protected:
	//{{AFX_MSG(fugen)
	afx_msg void OnAppAbout();
	afx_msg void OnHelpWeb();
	afx_msg void OnUpdateRecentFileMenu(CCmdUI* pCmdUI);
	afx_msg void OnUpdateFileSaveAll(CCmdUI* pCmdUI);
	afx_msg void OnFileSaveAll();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

//////////////////////////////////

public:
	//Get curent CView.
	CView* current_view()const;

	//Get curent fugenView.
	fugenView* currentfugenView(const fugenDoc* pDoc)const;

	BOOL PromptFileName(CString& newFile, BOOL bOpen = TRUE);
	BOOL PromptFileNameMulti(std::vector<CString>& newFile);

	bool IsModifiedDocumentExist() const;

	fugenMainFrame* MainFrame(){return static_cast<fugenMainFrame*>(m_pMainWnd);}

	/// Access to command factory.
	CGLCommandFactory& GetCommandFactory();

	///Show output window.
	void showOutputWindow(bool show);

private:
	void AddfugenDocTemplate(CDocTemplate* pDocTemplate);

	void InitLanguage();
	void InitHelpPath(LPCTSTR lpszSuffix);
	void InitCommands();
	void InitFileHandlers();

	// cout, cerr ̃obt@ւB
	void InitDebugTools();

	void ShowAppState();

	// Registry staff.
	void SaveAppState();
};

extern fugen theApp;
fugenStatusBar& theStatusBar();
MGCursorRestriction& theCursorRestriction();
void putInOutputWindow(const CString& string);
void putInOutputWindow(const std::string& string);
void putInOutputWindow(const char string[]);


//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ ͑Os̒Oɒǉ̐錾}܂B

#endif // !defined(AFX_GL_H__2398ABCD_D4C5_48D2_A408_C4F93610D38A__INCLUDED_)
