/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/**
 * @file ViewZoomWindowTool.h
 * @brief NX MGViewZoomWindowTool ̐錾
 */
#if !defined(AFX_ZOOMWINDOWTOOL_H__09E20DC3_3C71_45C1_802E_359425498731__INCLUDED_)
#define AFX_ZOOMWINDOWTOOL_H__09E20DC3_3C71_45C1_802E_359425498731__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/RectDrawer.h"
#include "Common/CommandStateOwner.h"

/// @class MGViewZoomWindowTool ZoomWindowTool.h "ViewCmd/ZoomWindowTool.h"
///
/// Zooms to a rectangular frame.
/// A rectangular window forms to define the zoom.
class MGViewZoomWindowTool : public MGCommandBase
{
	bool m_bMLB; ///< }EX̍{^Ă邩
	mgRectDrawer m_rectangle;///<VBO to draw a rectangle by screen coordinates.

public:
	explicit MGViewZoomWindowTool(fugenDoc* pDoc);

	virtual bool can_break_into() const{ return true;}

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();

	virtual bool OnLButtonDown(fugenView* window,UINT nFlags, CPoint point);
	virtual bool OnLButtonUp(fugenView* window,CPoint old_point,UINT nFlags, CPoint point);
	virtual bool OnMouseMove(fugenView* window,UINT nFlags, CPoint point);
};

#endif // !defined(AFX_ZOOMWINDOWTOOL_H__09E20DC3_3C71_45C1_802E_359425498731__INCLUDED_)
