/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
/**
 * @file ViewZoomWindowTool.cpp
 * @brief ViewZoomWindowTool.h ̎
 */
#include "stdafx.h"
#include "fugenDoc.h"
#include "fugenView.h"
#include "ViewCmd/ViewZoomWindowTool.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// MGViewZoomWindowTool

MGViewZoomWindowTool::MGViewZoomWindowTool(fugenDoc* pDoc)
: MGCommandBase(pDoc, ID_VIEW_ZOOM_WINDOW), m_bMLB(false){
}

MGCommandBase* MGViewZoomWindowTool::initial_clone(fugenDoc* pDoc)const{
	return new MGViewZoomWindowTool(pDoc);
}

bool MGViewZoomWindowTool::initiate_tool(){
	MGCommandBase::initiate_tool();

	// ŏ̃bZ[W
	SetStatusMessage(IDS_PROMPT_ZOOM_WINDOW);
	return false;
}

bool MGViewZoomWindowTool::OnLButtonDown(fugenView* pView, UINT, CPoint point){
	m_bMLB = true;
	SetStatusMessage(IDS_PROMPT_ZOOM_DYNAMIC);
	m_rectangle.attatchToWindow(pView);
	return false;
}

bool MGViewZoomWindowTool::OnLButtonUp(fugenView* pView, CPoint, UINT, CPoint point){
	m_bMLB = false;
	m_rectangle.detachFromWindow();

	CRect rc;
	pView->GetClientRect(rc);
	int h = rc.Height();
	const CPoint& old=pView->button_down_point();

	pView->ExecPanZoom(old.x, h-old.y, point.x, h-point.y);

	return OnCommandEnd(1);// I
}

bool MGViewZoomWindowTool::OnMouseMove(fugenView* pView, UINT, CPoint point){
	if(m_bMLB){
		m_rectangle.updateRectangle();
		pView->redrawOnlythis();
	}
	pView->displaySet_position(point);
	return false;
}
