/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/**
 * @file ViewZoomTargetTool.h
 * @brief NX MGViewZoomTargetTool ̐錾
 */
#if !defined(AFX_ZOOMTARGETTOOL_H__2C723EA0_5A32_4109_965A_7C00C8A64588__INCLUDED_)
#define AFX_ZOOMTARGETTOOL_H__2C723EA0_5A32_4109_965A_7C00C8A64588__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/RectDrawer.h"
#include "Common/CommandStateOwner.h"

/// @class MGViewZoomTargetTool ZoomTargetTool.h "ViewCmd/ZoomTargetTool.h"
///
/// Zooms to a rectangular frame.
/// A rectangular window forms to define the zoom with the target point as the center of the view.
class MGViewZoomTargetTool : public MGCommandBase
{
	bool m_bMLB; ///< }EX̍{^Ă邩
	mgRectDrawer m_rectangle;///<VBO to draw a rectangle by screen coordinates.

public:
	explicit MGViewZoomTargetTool(fugenDoc* pDoc);
	virtual bool can_break_into() const{ return true;}
	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool OnLButtonDown(fugenView* window,UINT nFlags, CPoint point);
	virtual bool OnLButtonUp(fugenView* window,CPoint old_point,UINT nFlags, CPoint point);
	virtual bool OnMouseMove(fugenView* window,UINT nFlags, CPoint point);
};

#endif // !defined(AFX_ZOOMTARGETTOOL_H__2C723EA0_5A32_4109_965A_7C00C8A64588__INCLUDED_)
