/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/**
 * @file ViewZoomTargetTool.cpp
 * @brief ViewZoomTargetTool.h ̎
 */
#include "stdafx.h"
#include "fugenDoc.h"
#include "fugenView.h"
#include "ViewCmd/ViewZoomTargetTool.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// MGViewZoomTargetTool

MGViewZoomTargetTool::MGViewZoomTargetTool(fugenDoc* pDoc)
: MGCommandBase(pDoc, ID_VIEW_ZOOM_TARGET), m_bMLB(false){
}

MGCommandBase* MGViewZoomTargetTool::initial_clone(fugenDoc* pDoc) const{
	return new MGViewZoomTargetTool(pDoc);
}

bool MGViewZoomTargetTool::initiate_tool(){
	MGCommandBase::initiate_tool();
	SetStatusMessage(IDS_PROMPT_ZOOM_TARGET);
	return false;
}

bool MGViewZoomTargetTool::OnLButtonDown(fugenView* pView, UINT, CPoint point){
	m_bMLB = true;
	SetStatusMessage(IDS_PROMPT_ZOOM_DYNAMIC);
	m_rectangle.attatchToWindow(pView);
	return false;
}

bool MGViewZoomTargetTool::OnLButtonUp(fugenView* pView, CPoint, UINT, CPoint point){
	m_bMLB = false;
	m_rectangle.detachFromWindow();

	const CPoint& old=pView->button_down_point();
	// ̃R}h̃C̏
	CPoint corner = old + old - point;
	CRect rc;
	pView->GetClientRect(rc);
	int height = rc.Height();
	pView->ExecPanZoom(corner.x, height - corner.y, point.x, height - point.y);

	// I
	return OnCommandEnd(1);
}

bool MGViewZoomTargetTool::OnMouseMove(fugenView* pView, UINT nFlags, CPoint point){
	if(m_bMLB){
		const CPoint& old=pView->button_down_point();
		CPoint corner = old + old - point;
		m_rectangle.updateRectangle(corner,point);
		pView->redrawOnlythis();
	}
	MGCommandBase::OnMouseMove(pView,nFlags,point);
	return false;
}
