/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
#include "stdafx.h"
#include "fugen.h"
#include "ViewCmd/NamedViewItem.h"
#include "mg/GelFactory.h"
#include "mg/Ifstream.h"
#include "mg/Ofstream.h"
#include "mgGL/OpenGLView.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

AUTO_GEL_REGISTER(MGNamedViewItem, MGNamedViewItem::TID);

namespace{
	const UINT NAMED_VIEW_ITEM_VERSION = 1;
}

MGNamedViewItem::MGNamedViewItem(){
}

MGNamedViewItem::MGNamedViewItem(const CString& name, const MGglViewAttrib& env)
:m_env(env){
	std::string nm = CT2A(name);
	m_name=MGName(nm);
}

MGNamedViewItem::MGNamedViewItem(const CString& name, const MGOpenGLView& view)
:m_env(view){
	std::string nm = CT2A(name);
	m_name=MGName(nm);
}

MGNamedViewItem* MGNamedViewItem::clone()const{
	return new MGNamedViewItem(*this);
}

long MGNamedViewItem::identify_type() const{
	return TID;
}

std::ostream& MGNamedViewItem::toString(std::ostream& ostrm) const{
	ostrm<<"MGNamedViewItem:"<<m_name<<std::endl;
	ostrm<<","<<m_env;
	return ostrm;
}

void MGNamedViewItem::ReadMembers(MGIfstream& s){
	UINT nVersion;
	s >> nVersion;
	if(nVersion > NAMED_VIEW_ITEM_VERSION){
		// Vo[W̃t@CǂݍƂĂB
		// B
	}
	m_name.ReadMembers(s);
	s>>m_env;
}

void MGNamedViewItem::WriteMembers(MGOfstream& s) const{
	s << NAMED_VIEW_ITEM_VERSION;
	m_name.WriteMembers(s);
	s<<m_env;
}

std::string MGNamedViewItem::whoami() const{
	return "MGNamedViewItem";
}

const MGName& MGNamedViewItem::name() const{
	return m_name;
}

void MGNamedViewItem::set_name(const CString& name){
	std::string nm = CT2A(name);
	m_name=MGName(nm);
}

const MGglViewAttrib& MGNamedViewItem::view_env() const{
	return m_env;
}

void MGNamedViewItem::set_view_env(const MGglViewAttrib& view){
	m_env = view;
}

void MGNamedViewItem::set_view_env(const MGOpenGLView& view){
	m_env=view.viewAttrib();
}
