/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
#pragma once
#include "mg/Attrib.h"
#include "mgGL/Name.h"
#include "mg/Plane.h"

/// @class MGNamedCPlaneItem NamedCPlaneItem.h "ViewCmd/NamedCPlaneItem.h"
/// uOtƕʁvR}hŕۑ邽߂̃f[^NXB
class MGNamedCPlaneItem : public MGAttrib
{
	MGName m_name; ///< O
	MGPlane m_plane; ///< ʂ̂

public:
	/// identify_type p̒lB
	enum{ TID = MGATTRIB_TID | 0x00FF0002};

	/// ftHgRXgN^[
	/// @post m_name.empty()
	///       m_plane.is_null()
	MGNamedCPlaneItem();

	/// Oƒlw肵ăIuWFNgB
	/// @param[in] name ݒ̖
	/// @param[in] plane 
	/// @post m_name == name
	///       m_plane == plane
	MGNamedCPlaneItem(const CString& name, const MGPlane& plane);

	/// Rs[RXgN^[ɂN[IuWFNgԂB
	/// @return N[IuWFNg
	virtual MGNamedCPlaneItem* clone() const;

	virtual void drawAttrib(
		mgVBO& vbo,///<The target graphic object.
		bool no_color = false	///<if true, color attribute will be neglected.
	)const{		;	};

	/// @return TID
	virtual long identify_type() const;

	/// Xg[ɂóB
	/// @param[in,out] s o̓Xg[
	/// @return s
	virtual std::ostream& toString(std::ostream& ostrm) const override;

	/// ̃NX̂ԂB
	/// @return  "MGNamedCPlaneItem"
	virtual std::string whoami() const;

	/// ݒ薼̂ԂB
	/// @return m_name
	const MGName& name() const;

	/// ݒ薼̂ZbgB
	/// @post name == m_name
	void set_name(const CString& name);

	/// ƕʂ̌`ԂB
	/// @return m_plane
	const MGPlane& plane() const;

	/// ƕʂ̌`ZbgB
	/// @post plane == m_plane
	void set_plane(const MGPlane& plane);

protected:
	virtual void ReadMembers(MGIfstream& s);
	virtual void WriteMembers(MGOfstream& s) const;
};

