/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

/**
 * @file CPlaneVerticalTool.cpp
 * @brief CPlaneVerticalTool.h ̎
 */
#include "stdafx.h"
#include "fugen.h"
#include "fugenView.h"
#include "ViewCmd/CPlaneUtil.h"
#include "ViewCmd/CPlaneVertical.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// MGCPlaneVerticalTool

MGCPlaneVerticalTool::MGCPlaneVerticalTool(fugenDoc* pDoc)
: MGLocateState(pDoc,ID_CPLANE_VERTICAL),
m_pView(pDoc->get_main_view()),
m_v(m_pView->cplane().plane().normal()){
	const MGContext& ctx=*(pDoc->context());
	const MGColor* gridColors=ctx.gridColors();
	m_zColor=&gridColors[3];
	// ̎͌	m_v;
	// CPlane V݂͌CPlaneɑ΂ĐłB
}

MGCPlaneVerticalTool::MGCPlaneVerticalTool(fugenView* pView)
: MGLocateState(pView->GetDocument(),ID_CPLANE_VERTICAL),
m_pView(pView->document().get_main_view()),
m_v(m_pView->cplane().plane().normal()){
	const MGContext& ctx=*(document()->context());
	const MGColor* gridColors=ctx.gridColors();
	m_zColor=&gridColors[3];
	// ̎͌	m_v;
	// CPlane V݂͌CPlaneɑ΂ĐłB
}

MGCommandBase* MGCPlaneVerticalTool::initial_clone(fugenDoc* pDoc)const{
	return new MGCPlaneVerticalTool(pDoc);
}

void MGCPlaneVerticalTool::do_make_temporary_display(mgSysGL& sgl,fugenView* pView){
	const MGConstructionPlane& cplane = m_pView->cplane();
	switch(locates().size()){
	case 0:
		m_org = cursor();
		m_u = cplane.plane().u_deriv();
		break;
	case 1:
		m_u = (cursor() - m_org);
		break;
	}
	PreviewCPlane(sgl,cplane, m_org, m_u, m_v,m_zColor);
}

bool MGCPlaneVerticalTool::OnLocated(const MGLocateInfo& info){
	const LInfoVec& linfos=locates();	
	switch(linfos.size()){
	case 1:
		m_org = linfos[0]->point_world();// CPlane ̌_
		m_u = m_pView->cplane().plane().u_deriv();//̓ftHgl
		break;
	case 2:
		{
			// U
			const MGPosition& P0=linfos[0]->point_world();
			const MGPosition& P1=linfos[1]->point_world();
			m_u = P1-P0;
		}
	
		// vZJn
		ExecPlaneAction(m_pView, m_u, m_v, m_org);	
		setActiveView(m_pView);
		return OnCommandEnd(1); // R}hI
	default:;
	}
	return false;
}

void MGCPlaneVerticalTool::prompt_message() const{
	switch(locates().size()){
	case 0:
		SetStatusMessage(IDS_PROMPT_CPLANE_ORIGIN);
		break;
	case 1:
		SetStatusMessage(IDS_PROMPT_AXIS_X);
		break;
	}
}
