/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno             */
/* All rights reserved.                                             */
/********************************************************************/

/**
 * @file CPlaneRotate.h
 * @brief NX MGCPlaneRotateTool ̐錾
 */

#if !defined(AFX_CPLANEROTATE_H__B7C9FEA5_71FA_460A_AD4E_85C91DD70C3D__INCLUDED_)
#define AFX_CPLANEROTATE_H__B7C9FEA5_71FA_460A_AD4E_85C91DD70C3D__INCLUDED_

#pragma once
#include "mg/Straight.h"
#include "Common/LocateState.h"

/// @class MGCPlaneRotateTool CPlaneRotate.h "ViewCmd/CPlaneRotate.h"
///
/// CPlane ]ɂĕύXR}h
class MGCPlaneRotateTool : public MGLocateState{
public:
	explicit MGCPlaneRotateTool(fugenDoc* pDoc);
	virtual bool can_break_into() const{ return false;}
	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pView);
	virtual bool OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags);
	virtual bool OnLocated(const MGLocateInfo& info);

private:
	
	void execRotate(double angle);
	void prompt_message()const;

	fugenView* m_pViewTarget; //target view of the construction plane.

	const MGConstructionPlane& m_cplane;//The target construction plane to rotate.
	char m_xyzchar[3];//Name of each axis.
	MGVector m_axes[3];	//axis vectors of the construction plane.
	MGColor m_colors[3];//Color of each axis.
	double m_axisLenth[3];//draw length of each axis.

	int m_rotation_axis;	// rotation_axis, 0:u, 1:v, 2:N.
	MGPosition m_origin;//The origin of m_cplane.
};

#endif // !defined(AFX_CPLANEROTATE_H__B7C9FEA5_71FA_460A_AD4E_85C91DD70C3D__INCLUDED_)
