/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

/**
 * @file CPlaneOrigin.cpp
 * @brief CPlaneOrigin.h ̎
 */
#include "stdafx.h"
#include "fugen.h"
#include "fugenView.h"
#include "ViewCmd/CPlaneUtil.h"
#include "ViewCmd/CPlaneOrigin.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// MGCPlaneOriginTool

MGCPlaneOriginTool::MGCPlaneOriginTool(fugenDoc* pDoc)
: MGLocateState(pDoc, ID_CPLANE_ORIGIN, NO_RUBBER, POINTLINE_IPDRAW){
	const MGContext& ctx=*(pDoc->context());
	const MGColor* gridColors=ctx.gridColors();
	m_zColor=&gridColors[3];
}

MGCPlaneOriginTool::MGCPlaneOriginTool(fugenView* pView)
: MGLocateState(pView->GetDocument(), ID_CPLANE_ORIGIN, NO_RUBBER, POINTLINE_IPDRAW){
	const MGContext& ctx=*(document()->context());
	const MGColor* gridColors=ctx.gridColors();
	m_zColor=&gridColors[3];
}

MGCommandBase* MGCPlaneOriginTool::initial_clone(fugenDoc* pDoc) const{
	return new MGCPlaneOriginTool(pDoc);
}

bool MGCPlaneOriginTool::initiate_tool(){
	MGLocateState::initiate_tool();
	m_pView=theApp.currentfugenView(document());
	//The objective view is the current one when this command is invoked.

	// ŏ̃bZ[W
	SetStatusMessage(IDS_PROMPT_CPLANE_ORIGIN);
	return false;
}

void MGCPlaneOriginTool::do_make_temporary_display(mgSysGL& sgl,fugenView* pView){
	ASSERT_VALID(m_pView);

	const MGConstructionPlane& cpl = m_pView->cplane();
	const MGPlane& pl = cpl.plane();
	const MGPosition& origin = cursor();
	PreviewCPlane(sgl,cpl, origin, pl.u_deriv(), pl.v_deriv(),m_zColor);
}

bool MGCPlaneOriginTool::OnLocated(const MGLocateInfo& info){
	ASSERT_VALID(m_pView);
	ASSERT(!locates().empty());

	MGConstructionPlane& cplane = m_pView->cplane();
	const MGPosition& old = cplane.plane().center();
	const MGPosition& pos = locates().back()->point_world();

	MGPlane plNew(cplane.plane());
	plNew += (pos - old); // translation of the origin
	ExecPlaneAction(m_pView, plNew);
	setActiveView(m_pView);
	return OnCommandEnd(1); // R}hI
}
