/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

/**
 * @file CPlaneFront.cpp
 * @brief CPlaneFront.h ̎
 */
#include "stdafx.h"
#include "fugen.h"
#include "ViewCmd/CPlaneFront.h"
#include "ViewCmd/CPlaneUtil.h"
#include "fugenView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// MGCPlaneFrontTool

MGCPlaneFrontTool::MGCPlaneFrontTool(fugenDoc* pDoc)
: MGCommandBase(pDoc, ID_CPLANE_FRONT),
m_pView(pDoc->get_main_view()){
}

MGCommandBase* MGCPlaneFrontTool::initial_clone(fugenDoc* pDoc)const{
	return new MGCPlaneFrontTool(pDoc);
}

bool MGCPlaneFrontTool::initiate_tool(){
	MGCommandBase::initiate_tool();	

	ASSERT(m_pView);
	ExecPlaneAction(m_pView, mgZ_UVEC, mgX_UVEC, mgORIGIN);
	setActiveView(m_pView);
	return OnCommandEnd(1);
}
