/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

/**
 * @file CPlaneElevate.h
 * @brief NX MGCPlaneElevateTool ̐錾
 */
#if !defined(AFX_CPLANEELEVATE_H__FBD8C9F6_39D3_4824_914A_88FED402AED3__INCLUDED_)
#define AFX_CPLANEELEVATE_H__FBD8C9F6_39D3_4824_914A_88FED402AED3__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/LocateState.h"

/// @class MGCPlaneElevateTool CPlaneElevate.h "ViewCmd/CPlaneElevate.h"
///
/// Changes the elevation of the construction plane.
class MGCPlaneElevateTool : public MGLocateState{
public:
	explicit MGCPlaneElevateTool(fugenDoc* pDoc);
	//explicit MGCPlaneElevateTool(fugenView* pView);

	// default : false (not break)
	virtual bool can_break_into() const{ return true;}

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool OnLocated(const MGLocateInfo& info);

	/////////////////functions for draw_temporary()////////////
	void do_make_temporary_display(mgSysGL& sgl,fugenView* pSView);

private:
	fugenView* m_pView; // ΏۂƂȂr[(R}hÑJgr[j
	const MGColor* m_zColor;//Color of CPlane's normal.
};

#endif // !defined(AFX_CPLANEELEVATE_H__FBD8C9F6_39D3_4824_914A_88FED402AED3__INCLUDED_)
