/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

/**
 * @file CPlaneElevate.cpp
 * @brief CPlaneElevate.h ̎
 */
#include "stdafx.h"
#include "mg/Straight.h"
#include "fugen.h"
#include "fugenView.h"
#include "ViewCmd/CPlaneUtil.h"
#include "ViewCmd/CPlaneElevate.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// MGCPlaneElevateTool

MGCPlaneElevateTool::MGCPlaneElevateTool(fugenDoc* pDoc)
: MGLocateState(pDoc, ID_CPLANE_ELEVATION, NO_RUBBER, POINTLINE_IPDRAW),
m_pView(theApp.currentfugenView(pDoc)){
	const MGContext& ctx=*(pDoc->context());
	const MGColor* gridColors=ctx.gridColors();
	m_zColor=&gridColors[3];
}

MGCommandBase* MGCPlaneElevateTool::initial_clone(fugenDoc* pDoc) const{
	return new MGCPlaneElevateTool(pDoc);
}

bool MGCPlaneElevateTool::initiate_tool(){
	MGLocateState::initiate_tool();

	// }EX|C^
	const MGPlane& cpl=m_pView->cplane().plane();
	const MGVector& normal=cpl.normal();

	//Update locate's attribute
	const MGPosition& P0=cpl.center();
	setElevationRestrictionToProhibitUpdate(P0,normal);

	// ŏ̃bZ[W
	SetStatusMessage(IDS_PROMPT_CPLANE_ORIGIN);
	return false;
}

void MGCPlaneElevateTool::do_make_temporary_display(mgSysGL& sgl,fugenView* pView){
	ASSERT_VALID(m_pView);
	const MGConstructionPlane& cpl = m_pView->cplane();
	const MGPlane& pl = cpl.plane();
	const MGPosition& origin = cursor();
	PreviewCPlane(sgl,cpl, origin,pl.u_deriv(),pl.v_deriv(),m_zColor);
}

bool MGCPlaneElevateTool::OnLocated(const MGLocateInfo& info){
	MGConstructionPlane& cplane = m_pView->cplane();
	const MGPosition& old = cplane.plane().center();
	const MGPosition& pos = locates().back()->point_world();

	MGPlane plNew(cplane.plane());
	plNew += (pos - old); // translation of the origin
	ExecPlaneAction(m_pView, plNew);

	disable_AETPmode();
	setActiveView(m_pView);
	return OnCommandEnd(1); // R}hI
}
