/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

/**
 * @file CPlaneAxisZ.h
 * @brief NX MGCPlaneAxisZTool ̐錾
 */
#if !defined(AFX_CPLANEAXISZ_H__7D23C176_FDB6_4557_9A61_87E6B3984275__INCLUDED_)
#define AFX_CPLANEAXISZ_H__7D23C176_FDB6_4557_9A61_87E6B3984275__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/LocateState.h"

/// @class MGCPlaneAxisZTool CPlaneAxisZ.h "ViewCmd/CPlaneAxisZ.h"
///]FVm[}
///Vm[}w肵ACPlanẽm[}YƂ悤]
class MGCPlaneAxisZTool : public MGLocateState
{

public:
	explicit MGCPlaneAxisZTool(fugenDoc* pDoc);
	explicit MGCPlaneAxisZTool(fugenView* pView);
	virtual bool can_break_into() const{ return true;}
	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pView);
	virtual bool OnLocated(const MGLocateInfo& info);

private:
	void prompt_message() const;

	fugenView* m_pView; // ΏۂƂȂr[
	const MGVector& m_N;//normal of the view's cplane.

	MGPosition m_org;       // V CPlane ̌_
	MGUnit_vector   m_u;    // V CPlane  U  
	MGUnit_vector   m_v;    // V CPlane  V  
	const MGColor* m_zColor;//Color of CPlane's normal.
};

#endif // !defined(AFX_CPLANEAXISZ_H__7D23C176_FDB6_4557_9A61_87E6B3984275__INCLUDED_)
