/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
// GLANODisplayAction.h: interface for the CGelNoDisplayAction class.
// This class serves as MGAppearance NODisplay action
// It defines the following operations:
//
//		void Do();
//			--Notify the undo manager,
//			--Perform operation(set the object as no display or as display)
//
//		void Undo();
//			-- set the object as display or no display.
//
//		void Redo();
//			-- set the object as no display or as display.
//
//////////////////////////////////////////////////////////////////////

#if !defined(GelNODisplayAction_H)
#define GelNODisplayAction_H

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

class MGAppearance;
class MGAttribedGel;

#include "Undo/mgGelAction.h"
#include "Undo/DocAction.h"

class CGelNoDisplayAction : public CDocAction{
public:

	///Dummy action.
	CGelNoDisplayAction(fugenDoc *doc=0);

	///Add or replace action.
	///When attribed_gel already have the same type attribute as attrib,
	///this will replace the old MGGLAttrib, otherwise add attribed_gel.
	CGelNoDisplayAction(
		fugenDoc *doc,
		const MGGelPosition& gelp,///<MGObjects or MGAttribedGel to process of the following nodisplay.
		bool nodisplay=true ///<Set the gel as no display if true, as display if false.
		);
	///Add or replace action.
	///When attribed_gel already have the same type attribute as attrib,
	///this will replace the old MGGLAttrib, otherwise add attribed_gel.
	CGelNoDisplayAction(
		fugenDoc *doc,
		const MGGelPositions& gelps,///<MGObjects or MGAttribedGel to process of the following nodisplay.
		bool nodisplay=true ///<Set the gel as no display if true, as display if false.
		);

	///fXgN^
	virtual ~CGelNoDisplayAction();

	virtual	void	Do();
	virtual	void	Undo();
	virtual	void	Redo();

	///Update the views. This will be invoked by CDocAction::update_all_views,
	///when DO, Undo, or Redo operations are invoked.
	void view_update(ACTION_TYPE at);

protected:
	//The target is MGAttribedGel, the target is included in m_agelModified.
	mgGelAction m_agelModified;

	bool m_nodisplay;//Set the gel as no display if true, as display if false.

private:
	//Construct a member from one gelp data.
	void construct(const MGGelPosition& gelp);
	void do_action(bool nodisplay);

};

#endif
