/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
// GelAddAction.h: interface for the CGelAddAction class.
// This class serves as gel add action
// It defines the following operations:
//
//		void Do();
//			--Notify the undo manager,
//			--Perform operation
//
//		void Undo();
//			-- delete the added gels.
//
//		void Redo();
//			-- re-add the added gels.
//
//////////////////////////////////////////////////////////////////////

#if !defined(GelAddAction_H)
#define GelAddAction_H

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "Undo/DocAction.h"
#include "Undo/mgGelAction.h"

class fugenDoc;

class CGelAddAction : public CDocAction{

public:
	///RXgN^
	explicit CGelAddAction(fugenDoc *doc=0);
	CGelAddAction(fugenDoc *doc, const MGGelPositions& gelps);
	virtual ~CGelAddAction();

	MGGelPositions& added(){return m_gelAdded.target_gels();};

	virtual	void	Do();
	virtual	void	Undo();
	virtual	void	Redo();

protected:
	//Update the views. This will be invoked by CDocAction::update_all_views,
	//when DO, Undo, or Redo operations are invoked.
	virtual void view_update(ACTION_TYPE at);

private:
	mgGelAction m_gelAdded;

};

#endif
