/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
// DocAction.cpp: implementation of the CDocAction class.

#include "stdafx.h"
#include "fugenDoc.h"
#include "Undo/DocAction.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CDocAction::CDocAction(fugenDoc* aTarget, bool notify)
	 : CActionBase(aTarget, notify)
{
}

//Get the action target.
fugenDoc* CDocAction::actionTarget(){
	return static_cast<fugenDoc*>(GetActionTarget());
}

//Set target.
void CDocAction::set_target(fugenDoc* target){
	SetActionTarget(target);
}

//update all view.
void CDocAction::update_all_views(ACTION_TYPE at){
	fugenDoc& doc=*(actionTarget());
	view_update(at);//Invoke each action view update.
	doc.InvalidateAllStdViews();
}

void CDocAction::Do(){
	CActionBase::Do();
	actionTarget()->SetModifiedFlag(TRUE);
}
void CDocAction::Redo(){
	CActionBase::Redo();
	actionTarget()->SetModifiedFlag(TRUE);
}
void CDocAction::Undo(){
	CActionBase::Undo();
}
