/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

#pragma once
#include "Undo/IAction.h"

/// @class CActionBase ActionBase.h "Undo/ActionBase.h"
/// NX CActionBase ̓C^[tFCX IAction ̕WIȎ񋟂B
class CActionBase : public IAction
{
public:
	/// RXgN^[
	/// @param[in] actionTarget
	/// @param[in] autoNotify
	/// @post GetActionTarget() == actionTarget
	///       IsAutoNotify() == autoNotify
	CActionBase(IActionTarget* actionTarget = 0, bool autoNotify = true);

	virtual ~CActionBase(){}

	virtual void Do();
	virtual void Redo(){m_undone=false;}
	virtual void Undo(){m_undone=true;}

	virtual IActionTarget* GetActionTarget() const;
	virtual void SetActionTarget(IActionTarget* pTarget);

	virtual bool IsAutoNotify() const{ return m_autoNotify; }
	virtual void SetAutoNotify(bool an) { m_autoNotify = an; }

	virtual bool IsUndone()const{return m_undone;};

	virtual bool in_redo_stack() const{return !m_undo_stack;}
	virtual bool in_undo_stack() const{return m_undo_stack;}

	virtual void set_as_undo_stack(){m_undo_stack=true;}
	virtual void set_as_redo_stack(){m_undo_stack=false;}

private:
	/// The action target.
	/// Usually this points to a document or view object.
	IActionTarget* m_actionTarget;

	/// indicates whether the undo manager should
	/// be notified automatically of when an action
	/// has been done.
	bool m_autoNotify : 1;

	/// indicates whether the action has been undone or not;
	/// after do & redo, it's false; after undo; it's true;
	bool m_undone : 1;

	/// Indicates if this action is stacked in undo or redo stack.
	/// True if stored in undo stack, false if in redo stack.
	bool m_undo_stack : 1;

};
